﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// AdmissionInfo class.
    /// </summary>
    public class AdmissionInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The date time entered.
        /// </value>
        public DateTime? Entered { get; set; }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        /// <value>
        /// The date time requested.
        /// </value>
        public DateTime? Requested { get; set; }

        /// <summary>
        /// Gets or sets the removed date.
        /// </summary>
        /// <value>
        /// The removed.
        /// </value>
        public DateTime? Removed { get; set; }

        /// <summary>
        /// Gets or sets the problem.
        /// </summary>
        /// <value>
        /// The problem.
        /// </value>
        public string Problem { get; set; }

        /// <summary>
        /// Gets or sets the type of bed ward.
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        public string TypeOfBedWard { get; set; }

        /// <summary>
        /// Gets or sets the waiting area.
        /// </summary>
        /// <value>
        /// The waiting area.
        /// </value>
        public string WaitingArea { get; set; }

        /// <summary>
        /// Gets or sets the wait time.
        /// </summary>
        /// <value>
        /// The wait time.
        /// </value>
        public TimeSpan WaitTime { get; set; }

        /// <summary>
        /// Gets or sets the service receiving fee.
        /// </summary>
        /// <value>
        /// The service receiving fee.
        /// </value>
        public string ServiceReceivingFee { get; set; }

        /// <summary>
        /// Gets or sets the reason using fee.
        /// </summary>
        /// <value>
        /// The reason using fee.
        /// </value>
        public string ReasonUsingFee { get; set; }

        /// <summary>
        /// Gets or sets the acute.
        /// </summary>
        /// <value>
        /// The acute.
        /// </value>
        public string Acute { get; set; }

        /// <summary>
        /// Gets or sets the fee.
        /// </summary>
        /// <value>
        /// The fee.
        /// </value>
        public string Fee { get; set; }

        /// <summary>
        /// Gets or sets the contract.
        /// </summary>
        /// <value>
        /// The contract.
        /// </value>
        public string Contract { get; set; }

        /// <summary>
        /// Gets or sets the fee comments.
        /// </summary>
        /// <value>
        /// The fee comments.
        /// </value>
        public string FeeComments { get; set; }

        /// <summary>
        /// Gets or sets the room bed assigned.
        /// </summary>
        /// <value>
        /// The room bed assigned.
        /// </value>
        public string RoomBedAssigned { get; set; }

        /// <summary>
        /// Gets or sets the room bed assigned id.
        /// </summary>
        /// <value>
        /// The room bed assigned id.
        /// </value>
        public II RoomBedAssignedId { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the bed assigned date.
        /// </summary>
        /// <value>
        /// The bed assigned date.
        /// </value>
        public DateTime? BedAssignedDate { get; set; }

        /// <summary>
        /// Gets or sets the index of the record(used for paging).
        /// </summary>
        /// <value>
        /// The index.
        /// </value>
        public int Index { get; set; }

        /// <summary>
        /// Gets or sets the total records count(used for paging).
        /// </summary>
        /// <value>
        /// The total count.
        /// </value>
        public int TotalCount { get; set; }

        /// <summary>
        /// Gets or sets the id act.
        /// </summary>
        /// <value>
        /// The id act.
        /// </value>
        public string IdAct { get; set; }


        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the root patient id.
        /// </summary>
        /// <value>
        /// The root patient id.
        /// </value>
        public string RootPatientId { get; set; }

        /// <summary>
        /// Gets or sets the extension patient id.
        /// </summary>
        /// <value>
        /// The extension patient id.
        /// </value>
        public string ExtensionPatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient last four digits of SSN.
        /// </summary>
        /// <value>
        /// The patient last four digits of SSN.
        /// </value>
        public string PatientLastFourDigitsOfSSN { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is in house.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is in house; otherwise, <c>false</c>.
        /// </value>
        public bool IsInHouse { get; set; }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether bed is in isolation or not.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if bed is in isolation; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedInIsolation { get; set; }

        /// <summary>
        /// Gets or sets the bed in isolation icon.
        /// </summary>
        /// <value>
        /// The bed in isolation icon.
        /// </value>
        public IconInfo BedInIsolationIcon { get; set; }

        /// <summary>
        /// Gets or sets the wait time alert date.
        /// </summary>
        /// <value>
        /// The wait time alert date.
        /// </value>
        public DateTime? WaitTimeAlertDate { get; set; }

        /// <summary>
        /// Gets or sets the remaining wait time alert hours.
        /// </summary>
        /// <value>
        /// The remaining wait time alert hours.
        /// </value>
        public int? RemainingWaitTimeAlertHours { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether this instance is community living center.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is community living center; otherwise, <c>false</c>.
        /// </value>
        public bool IsCommunityLivingCenter { get; set; }

        #endregion
    }
}
