
USE MASTER	
GO
	
-- GET USERS SID FROM ACTIVE DIRECTORY
IF  EXISTS (SELECT srv.name FROM sys.servers srv WHERE srv.server_id != 0 AND srv.name = N'ADSI') 
	EXEC master.dbo.sp_dropserver @server=N'ADSI', @droplogins='droplogins'

EXEC master.dbo.sp_addlinkedserver @server = N'ADSI', @srvproduct=N'Active Directory Service Interfaces', @provider=N'ADSDSOObject', @datasrc=N'adsdatasource' 
EXEC master.dbo.sp_addlinkedsrvlogin @rmtsrvname=N'ADSI',@useself=N'False',@locallogin=NULL,@rmtuser=N'$(varRmtUser)',@rmtpassword='$(varRmtUserPass)'


EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'collation compatible', @optvalue=N'false' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'data access', @optvalue=N'true' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'dist', @optvalue=N'false' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'pub', @optvalue=N'false'
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'rpc', @optvalue=N'false' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'rpc out', @optvalue=N'false' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'sub', @optvalue=N'false' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'connect timeout', @optvalue=N'0' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'collation name', @optvalue=null 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'lazy schema validation', @optvalue=N'false' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'query timeout', @optvalue=N'0' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'use remote collation', @optvalue=N'true' 
EXEC master.dbo.sp_serveroption @server=N'ADSI', @optname=N'remote proc transaction promotion', @optvalue=N'true' 
	
DECLARE @global_catalog VARCHAR(100), @domainResource VARCHAR(100), @usercount INT
SET @global_catalog = '$(varGlobalCatalog)'
SET @domainResource = '$(varEISDomain)'
SET @usercount = 0
	
USE $(varBMS_AUTHZ)
SET ANSI_NULLS ON
SET NOCOUNT ON

DECLARE @stmt NVARCHAR(MAX)
SET @stmt = '
	CREATE FUNCTION [dbo].[fn_SIDToString]
		(@BinSID AS VARBINARY(100))
	RETURNS VARCHAR(100)
		AS BEGIN	 
		
	  IF LEN(@BinSID) % 4 <> 0 RETURN(NULL)	 
	  DECLARE @StringSID VARCHAR(100)
	  DECLARE @i AS INT
	  DECLARE @j AS INT
	 
	  SELECT @StringSID = ''S-'' + CONVERT(VARCHAR, CONVERT(INT, CONVERT(VARBINARY, SUBSTRING(@BinSID, 1, 1))))
	  SELECT @StringSID = @StringSID + ''-'' + CONVERT(VARCHAR, CONVERT(INT, CONVERT(VARBINARY, SUBSTRING(@BinSID, 3, 6))))
	 
	  SET @j = 9
	  SET @i = LEN(@BinSID)
	 
	  WHILE @j < @i
	  BEGIN
		DECLARE @val BINARY(4)
		SELECT @val = SUBSTRING(@BinSID, @j, 4)
		SELECT @StringSID = @StringSID + ''-'' + CONVERT(VARCHAR, CONVERT(BIGINT, CONVERT(VARBINARY, REVERSE(CONVERT(VARBINARY, @val)))))
		SET @j = @j + 4
	  END
	  RETURN ( @StringSID )
	END	'
	
IF OBJECT_ID (N'dbo.fn_SIDToString') IS NULL 
	EXEC sp_executesql @stmt
	
SET @stmt = '
		CREATE FUNCTION [dbo].[fn_Get_User_Domain](@text varchar(MAX))
		RETURNS NVARCHAR(MAX)
		AS
		BEGIN
			DECLARE @index int, @result NVARCHAR(MAX)
			SET @index = -1
			SET @result = ''''
			WHILE (LEN(@text) > 0)
				BEGIN 
					SET @index = CHARINDEX('','' ,@text) 
		    
					IF (@index = 0) AND (LEN(@text) > 0)
						BEGIN		 
							IF (@text LIKE ''DC=%'')
								SET @result = @result + ''.'' + REPLACE(@text, ''DC='', '''') + ''\''
							ELSE
								SET @result = ''.''
							RETURN RIGHT(@result, LEN(@result) - 1)
						END 

					IF (@index > 1) 
						BEGIN 
							IF (LEFT(@text, @index - 1) LIKE ''DC=%'')
								SET @result = @result + ''.'' + REPLACE(LEFT(@text, @index - 1), ''DC='', '''')		
						END     
						SET @text = RIGHT(@text, (LEN(@text) - @index))      
				END
			SET @result = @result + ''\''
			RETURN RIGHT(@result, LEN(@result) - 1)
		END  '

IF OBJECT_ID (N'dbo.fn_Get_User_Domain') IS NULL 
	EXEC sp_executesql @stmt

CREATE TABLE #users (NAME NVARCHAR(100), ROLE_ID UNIQUEIDENTIFIER, ID NVARCHAR(200), FULL_NAME NVARCHAR(MAX))
INSERT INTO #users (NAME, ROLE_ID)
SELECT NTUserName, NEWID() FROM $(varBMS_NATIONAL_FACILITY).dbo.BMS_User_Data	
CREATE TABLE #tempUsers (SID_USER nvarchar(250), USERNAME nvarchar(250), DOMAIN NVARCHAR(250))
	
DECLARE @NAMES NVARCHAR(MAX)
SET @NAMES = ''
SELECT @NAMES = @NAMES + '''' + NAME + ''',' FROM #users
IF (LEN(@NAMES) > 0) SET @NAMES = LEFT(@NAMES, LEN(@NAMES)-1)

SET @stmt = 'SELECT dbo.fn_SIDToString(objectSID) , sAMAccountName, dbo.fn_Get_User_Domain(distinguishedname) as Domain 
	FROM OPENQUERY(ADSI, ''SELECT objectSID , sAMAccountName , userPrincipalName, distinguishedname  FROM ''''GC://'+ @global_catalog +''''' where  objectClass=''''Person'''' AND objectClass=''''User'''' '')
	WHERE sAMAccountName IN (' + @NAMES + ')'	
INSERT INTO #tempUsers EXEC sp_executesql @stmt

UPDATE U
	SET ID = TU.SID_USER,
		FULL_NAME = TU.DOMAIN + TU.USERNAME
FROM #users AS U
	INNER JOIN #tempUsers AS TU ON U.NAME = TU.USERNAME
DROP TABLE #tempUsers
DELETE FROM #users WHERE ID IS NULL
GO

IF OBJECT_ID (N'dbo.fn_SIDToString') IS NOT NULL  
	DROP FUNCTION fn_SIDToString;
IF OBJECT_ID (N'dbo.fn_Get_User_Domain') IS NOT NULL  
	DROP FUNCTION fn_Get_User_Domain;

IF  EXISTS (SELECT srv.name FROM sys.servers srv WHERE srv.server_id != 0 AND srv.name = N'ADSI')	
	EXEC master.dbo.sp_dropserver N'ADSI', 'droplogins'
GO


--begin transaction

CREATE TABLE #facilities (NR INT, ID NVARCHAR(250), CODE NVARCHAR(20), NAME NVARCHAR(100), VISN NVARCHAR(5), REGION NVARCHAR(5))
DECLARE @SQL NVARCHAR(MAX), @SUPPORT_ROLE UNIQUEIDENTIFIER, @NATIONAL_ROLE UNIQUEIDENTIFIER, @REGIONAL_ROLE UNIQUEIDENTIFIER,
		@VISN_ROLE UNIQUEIDENTIFIER, @SITE_ROLE UNIQUEIDENTIFIER, @EMS_ROLE UNIQUEIDENTIFIER, @GUEST_ROLE UNIQUEIDENTIFIER,
		@ACTION_READ UNIQUEIDENTIFIER, @ACTION_WRITE UNIQUEIDENTIFIER

SET @SQL = ''
SELECT @SUPPORT_ROLE = ID FROM $(varBMS_AUTHZ).dbo.ROLE WHERE NAME = 'SupportUsers'
SELECT @NATIONAL_ROLE = ID FROM $(varBMS_AUTHZ).dbo.ROLE WHERE NAME = 'NationalUsers'
SELECT @REGIONAL_ROLE = ID FROM $(varBMS_AUTHZ).dbo.ROLE WHERE NAME = 'RegionalUsers'
SELECT @VISN_ROLE = ID FROM $(varBMS_AUTHZ).dbo.ROLE WHERE NAME = 'VisnUsers'
SELECT @SITE_ROLE = ID FROM $(varBMS_AUTHZ).dbo.ROLE WHERE NAME = 'SiteUsers'
SELECT @EMS_ROLE = ID FROM $(varBMS_AUTHZ).dbo.ROLE WHERE NAME = 'EmsStaff'
SELECT @GUEST_ROLE = ID FROM $(varBMS_AUTHZ).dbo.ROLE WHERE NAME = 'Guests'
SELECT @ACTION_READ = ID FROM $(varBMS_AUTHZ).dbo.ACTION WHERE NAME = 'BMS, Read'
SELECT @ACTION_WRITE = ID FROM $(varBMS_AUTHZ).dbo.ACTION WHERE NAME = 'BMS, Write'

--SET USER ROLES
SELECT @SQL = @SQL + '
	
	IF (SELECT COUNT(PK) FROM $(varBMS_AUTHZ).[dbo].[SID_USER] AS S WHERE S.SID = ''' + U.ID + ''') = 0
		BEGIN
			EXEC $(varBMS_AUTHZ).dbo.INS_ROLE @ID=''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@NAME=N''' + U.FULL_NAME + ''',@DESCRIPTION=N''Built-in''		
			EXEC $(varBMS_AUTHZ).dbo.INS_USER_ROLE @USER_ID=''' + U.ID + ''',@ROLE_ID=''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + '''
		END
	ELSE
		BEGIN
			UPDATE U
			SET U.ROLE_ID = R.ID FROM #users AS U 
				INNER JOIN [$(varBMS_AUTHZ)].[dbo].ROLE AS R ON U.FULL_NAME = R.NAME
				WHERE U.ID =''' + U.ID + '''
		END' + 
	
	CASE 
		WHEN UD.SupportUser = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_USER_ROLE @USER_ID=''' + U.ID + ''',@ROLE_ID=''' + CAST(@SUPPORT_ROLE AS NVARCHAR(50)) + '''' ELSE ''
	END +
	CASE
		WHEN UD.NationalUser = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_USER_ROLE @USER_ID=''' + U.ID + ''',@ROLE_ID=''' + CAST(@NATIONAL_ROLE AS NVARCHAR(50)) + '''' ELSE ''
	END +
	CASE
		WHEN UD.RegionalUser = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_USER_ROLE @USER_ID=''' + U.ID + ''',@ROLE_ID=''' + CAST(@REGIONAL_ROLE AS NVARCHAR(50)) + '''' ELSE ''
	END +
	CASE
		WHEN UD.VISNUser = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_USER_ROLE @USER_ID=''' + U.ID + ''',@ROLE_ID=''' + CAST(@VISN_ROLE AS NVARCHAR(50)) + '''' ELSE ''
	END +
	CASE
		WHEN UD.SiteUser = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_USER_ROLE @USER_ID=''' + U.ID + ''',@ROLE_ID=''' + CAST(@SITE_ROLE AS NVARCHAR(50)) + '''' ELSE ''
	END +
	CASE
		WHEN UD.EMSUser = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_USER_ROLE @USER_ID=''' + U.ID + ''',@ROLE_ID=''' + CAST(@EMS_ROLE AS NVARCHAR(50)) + '''' ELSE ''
	END +
	CASE
		WHEN UD.GuestUser = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_USER_ROLE @USER_ID=''' + U.ID + ''',@ROLE_ID=''' + CAST(@GUEST_ROLE AS NVARCHAR(50)) + '''' ELSE ''
	END
FROM #users AS U
	INNER JOIN $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_User_Data] AS UD ON U.NAME = UD.NTUserName
EXECUTE sp_executesql @SQL


-- SET PERMISSIONS ON FACILITIES
INSERT INTO #facilities (NR, ID, CODE, NAME, VISN, REGION)
SELECT RANK() OVER (ORDER BY E.PK_ENTITY), E.IDENTIFIER, CODE.IDENTIFIER_EXTENSION, O.NAME, VISN.IDENTIFIER_EXTENSION, REGION.IDENTIFIER_EXTENSION
FROM $(varBMS_EIS).dbo.ENTITY AS E
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION AND O.CODE_CODE = 'FAC'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS CODE ON CODE.FK_ENTITY = O.PFK_ORGANIZATION AND CODE.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R1 ON R1.FK_PLAYER_ENTITY = O.PFK_ORGANIZATION AND R1.CLASS_CODE = 'MBR' -- VISTA
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R2 ON R2.FK_PLAYER_ENTITY = R1.FK_SCOPER_ENTITY AND R2.CLASS_CODE = 'MBR' -- VISN
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R3 ON R3.FK_PLAYER_ENTITY = R2.FK_SCOPER_ENTITY AND R3.CLASS_CODE = 'MBR' -- REGION
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS VISN ON R2.FK_SCOPER_ENTITY = VISN.FK_ENTITY AND VISN.IDENTIFIER_ROOT = 'NUMBER'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS REGION ON R3.FK_SCOPER_ENTITY = REGION.FK_ENTITY AND REGION.IDENTIFIER_ROOT = 'NUMBER'

-- NATIONAL, SUPPORT AND GUEST USERS
SET @SQL = ''
SELECT @SQL = @SQL + 	
	CASE 
		WHEN UD.UserRead = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_RESOURCE_POLICIES @RESOURCE_ROOT=N''InfoWorld'',@RESOURCE_EXTENSION=N''' + F.ID + ''',@RESOURCE_TYPE=N''HL7-RIM-V3-ORGANIZATION'', @ROLE_ID=N''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@ACTION_ID=N''' + CAST(@ACTION_READ AS NVARCHAR(50)) + ''''
		ELSE ''
	END +
	CASE 
		WHEN UD.UserWrite = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_RESOURCE_POLICIES @RESOURCE_ROOT=N''InfoWorld'',@RESOURCE_EXTENSION=N''' + F.ID + ''',@RESOURCE_TYPE=N''HL7-RIM-V3-ORGANIZATION'', @ROLE_ID=N''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@ACTION_ID=N''' + CAST(@ACTION_WRITE AS NVARCHAR(50)) + ''''
		ELSE ''
	END
FROM #facilities AS F, #users AS U
	INNER JOIN $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_User_Data] AS UD ON U.NAME = UD.NTUserName
WHERE UD.SupportUser = 'YES' OR UD.NationalUser = 'YES' OR UD.GuestUser = 'YES'
EXECUTE sp_executesql @SQL
-- REGIONAL USERS
SET @SQL = ''
SELECT @SQL = @SQL + 	
	CASE 
		WHEN UD.UserRead = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_RESOURCE_POLICIES @RESOURCE_ROOT=N''InfoWorld'',@RESOURCE_EXTENSION=N''' + F.ID + ''',@RESOURCE_TYPE=N''HL7-RIM-V3-ORGANIZATION'', @ROLE_ID=N''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@ACTION_ID=N''' + CAST(@ACTION_READ AS NVARCHAR(50)) + ''''
		ELSE ''
	END +
	CASE 
		WHEN UD.UserWrite = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_RESOURCE_POLICIES @RESOURCE_ROOT=N''InfoWorld'',@RESOURCE_EXTENSION=N''' + F.ID + ''',@RESOURCE_TYPE=N''HL7-RIM-V3-ORGANIZATION'', @ROLE_ID=N''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@ACTION_ID=N''' + CAST(@ACTION_WRITE AS NVARCHAR(50)) + ''''
		ELSE ''
	END
FROM #facilities AS F, #users AS U
	INNER JOIN $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_User_Data] AS UD ON U.NAME = UD.NTUserName	
WHERE UD.RegionalUser = 'YES' AND UD.DefaultRegion = F.REGION

EXECUTE sp_executesql @SQL
-- VISN USERS
SET @SQL = ''
SELECT @SQL = @SQL + 	
	CASE 
		WHEN UD.UserRead = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_RESOURCE_POLICIES @RESOURCE_ROOT=N''InfoWorld'',@RESOURCE_EXTENSION=N''' + F.ID + ''',@RESOURCE_TYPE=N''HL7-RIM-V3-ORGANIZATION'', @ROLE_ID=N''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@ACTION_ID=N''' + CAST(@ACTION_READ AS NVARCHAR(50)) + ''''
		ELSE ''
	END +
	CASE 
		WHEN UD.UserWrite = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_RESOURCE_POLICIES @RESOURCE_ROOT=N''InfoWorld'',@RESOURCE_EXTENSION=N''' + F.ID + ''',@RESOURCE_TYPE=N''HL7-RIM-V3-ORGANIZATION'', @ROLE_ID=N''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@ACTION_ID=N''' + CAST(@ACTION_WRITE AS NVARCHAR(50)) + ''''
		ELSE ''
	END
FROM #facilities AS F, #users AS U
	INNER JOIN $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_User_Data] AS UD ON U.NAME = UD.NTUserName	
WHERE UD.VISNUser = 'YES' AND UD.DefaultVISN = F.VISN
EXECUTE sp_executesql @SQL
-- SITE AND EMS USERS
SET @SQL = ''
SELECT @SQL = @SQL + 	
	CASE 
		WHEN UD.UserRead = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_RESOURCE_POLICIES @RESOURCE_ROOT=N''InfoWorld'',@RESOURCE_EXTENSION=N''' + F.ID + ''',@RESOURCE_TYPE=N''HL7-RIM-V3-ORGANIZATION'', @ROLE_ID=N''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@ACTION_ID=N''' + CAST(@ACTION_READ AS NVARCHAR(50)) + ''''
		ELSE ''
	END +
	CASE 
		WHEN UD.UserWrite = 'YES' THEN ' 
			EXEC $(varBMS_AUTHZ).dbo.INS_RESOURCE_POLICIES @RESOURCE_ROOT=N''InfoWorld'',@RESOURCE_EXTENSION=N''' + F.ID + ''',@RESOURCE_TYPE=N''HL7-RIM-V3-ORGANIZATION'', @ROLE_ID=N''' + CAST(U.ROLE_ID AS NVARCHAR(50)) + ''',@ACTION_ID=N''' + CAST(@ACTION_WRITE AS NVARCHAR(50)) + ''''
		ELSE ''
	END
FROM #facilities AS F, #users AS U
	INNER JOIN $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_User_Data] AS UD ON U.NAME = UD.NTUserName	
WHERE (UD.SiteUser = 'YES' OR UD.EMSUser = 'YES') AND UD.DefaultSite = F.CODE
EXECUTE sp_executesql @SQL

-- CONFIG: INSERT DEFAULT FACILITY
SET @SQL = 'DECLARE @CONFIG_ID INT '
SELECT @SQL = @SQL + ' 
	INSERT INTO $(varBMS).dbo.CONFIG (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
	VALUES(''InfoWorld'', ''' + U.FULL_NAME + ''', ''Profile'', ''DefaultFacility'', NULL, ''USR'', ''EIS'', ''DefaultFacility'')
	SET @CONFIG_ID = IDENT_CURRENT(''[$(varBMS)].dbo.CONFIG'')
	INSERT INTO $(varBMS).dbo.CONFIG_EIS (CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID)	
	VALUES(@CONFIG_ID, ''' + F.ID + ''', ''' + F.NAME + ''', ''HL7-RIM-V3-Organization'')'
FROM $(varBMS_NATIONAL_FACILITY).[dbo].[BMS_User_Data] AS UD 
	INNER JOIN #users AS U ON UD.NTUserName = U.NAME
	INNER JOIN #facilities AS F ON UD.DefaultSite = F.CODE
WHERE UD.DefaultSite IS NOT NULL
EXECUTE sp_executesql @SQL

DROP TABLE #users
DROP TABLE #facilities

--ROLLBACK TRANSACTION