BEGIN TRY
	BEGIN TRANSACTION;
		CREATE TABLE #facilitiesTable (ID UNIQUEIDENTIFIER, CODE NVARCHAR(10), VISTA_SITE NVARCHAR(20), MEDICAL_DIVISION NVARCHAR(100), FACILITY_SECTION NVARCHAR(100))
		DECLARE @SQL NVARCHAR(MAX), @VISTA_SITE_CODE NVARCHAR(20)
		SET @VISTA_SITE_CODE = '$(varVistaSiteCode)'

		INSERT INTO #facilitiesTable (ID, CODE, VISTA_SITE, FACILITY_SECTION)
		SELECT E.IDENTIFIER, U.IDENTIFIER_EXTENSION, V.IDENTIFIER_EXTENSION, 'FacilitySettings ' + E.IDENTIFIER
		FROM $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O
			INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS U ON U.FK_ENTITY = O.PFK_ORGANIZATION AND U.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = O.PFK_ORGANIZATION AND R.CLASS_CODE = 'MBR'
			INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
		WHERE O.CODE_CODE = 'FAC' AND V.IDENTIFIER_EXTENSION = @VISTA_SITE_CODE

		DELETE C FROM $(varBMS).dbo.CONFIG AS C
		INNER JOIN #facilitiesTable AS FAC ON FAC.FACILITY_SECTION = C.SECTION
		WHERE C.CONFIG_KEY= 'MedicalCenterID'

		DELETE C FROM $(varBMS_HISTORY).dbo.CONFIG_H AS C
		INNER JOIN #facilitiesTable AS FAC ON FAC.FACILITY_SECTION = C.SECTION
		WHERE C.CONFIG_KEY= 'MedicalCenterID'

		UPDATE F
			SET F.MEDICAL_DIVISION = CP.conceptCode
			FROM #facilitiesTable AS F
				INNER JOIN $(varBMS_NATIONAL_FACILITY).dbo.BMS_Site_Data AS SD ON F.CODE = SD.SiteID
				INNER JOIN $(varBMS_EVS).dbo.conceptProperty AS CP ON SD.StationID = RIGHT(CP.conceptCode, LEN(cp.conceptCode) - charindex('_',cp.ConceptCode))
							AND CP.property = 'textualPresentation' AND CP.codingSchemeName = 'VistaMedicalCenterDivision' AND LEFT(CP.conceptCode, CHARINDEX('_', CP.conceptCode) - 1) = F.VISTA_SITE

		SET @SQL = ''
		SELECT @SQL = @SQL + ' 
			INSERT INTO $(varBMS).dbo.CONFIG  (DOMAIN_ID, USER_NAME, SECTION, CONFIG_KEY, CONFIG_VALUE, CONFIG_TYPE, VALUE_TYPE, FRIENDLY_NAME)
			VALUES (''InfoWorld'', '''', ''' + FACILITY_SECTION + ''', ''MedicalCenterID'', ''' + MEDICAL_DIVISION + ''', ''APP'', ''ST'', '''')'
		FROM #facilitiesTable 
			WHERE MEDICAL_DIVISION IS NOT NULL AND LEN(MEDICAL_DIVISION) > 0
			
		EXEC sp_executesql @SQL

		DROP TABLE #facilitiesTable
	SELECT 'Association between Facilities and Medical Center Division  - successfully updated'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;