﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.EIS;
using FC = BMS.Facade.Data;
using BMS.Facade;
using VI = BMS.VistaIntegration.FacadeContracts;
using BMS.Utils;
using DC = BMS.DataContracts;
using BMS.ServicesWrapper.BMService;
using System.ServiceModel;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Mdws;
using BMS.VistaIntegration.Cache;
using BMS.VistaIntegration.Data;
using BMS.ServicesWrapper.EVS;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.WF;
using BMS.VistaWorker2.Writer;
using BMS.VistaWorker2.Writer.Implementation;
using InfoWorld.EVS.CTSMAPI;
using System.IO;
using System.Reflection;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;
using BMS.Facade.Data;

namespace Import_VistaJob
{
    public class Utils
    {
        public const string DomainId = "InfoWorld";
        public static List<CD> genderList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { MaxSelectedCodes = int.MaxValue, VocabularyDomain = FC.Util.Vocabulary.Gender.ToString() }).ToList();
        public static DateTime MinSqlDate = DateTime.Parse("1/1/1753");

        public static VI.Admin.VistaDataType GetDataTypes()
        {
            int dataTypes = 0;
            dataTypes |= (int)VI.Admin.VistaDataType.OrderableItem;
            dataTypes |= (int)VI.Admin.VistaDataType.Specialty;
            dataTypes |= (int)VI.Admin.VistaDataType.TreatingSpecialty;
            dataTypes |= (int)VI.Admin.VistaDataType.FacilityMovementType;
            dataTypes |= (int)VI.Admin.VistaDataType.MedicalCenterDivision;

            dataTypes |= (int)VI.Admin.VistaDataType.HospitalLocation;
            dataTypes |= (int)VI.Admin.VistaDataType.WardLocation;
            dataTypes |= (int)VI.Admin.VistaDataType.RoomBed;

            return (VI.Admin.VistaDataType)dataTypes;
        }

        public static DC.VistASite GetVistaSite(VI.VistASite site, DataRetrievalMethod retrievalMethod)
        {
            DC.VistASite vistaSite = new DC.VistASite();
            vistaSite.VistaName = site.Name;
            vistaSite.Id = site.Id;
            vistaSite.TimeZoneId = site.TimeZone.Id;
            vistaSite.Number = site.Number;
            if (retrievalMethod == DataRetrievalMethod.ODBC)
            {
                vistaSite.AccessCode = site.OdbcUser;
                vistaSite.VerifyCode = site.OdbcPassword;
                vistaSite.ConnectionString = site.OdbcConnectionString;
            }
            return vistaSite;
        }

        public static IVistASession GetVistASession(VI.VistASite vistaSettings, DataRetrievalMethod retrievalMethod)
        {
            IVistASessionFactory factory = null;
            VistAConnectionInfo connection = null;
            if (retrievalMethod == DataRetrievalMethod.MDWS)
            {
                factory = new MdwsVistASessionFactory();
                connection = new VistAConnectionInfo(null, null, null);
            }
            else if (retrievalMethod == DataRetrievalMethod.ODBC)
            {
                factory = new CacheVistASessionFactory();
                connection = new VistAConnectionInfo(
                    vistaSettings.OdbcConnectionString,
                    vistaSettings.OdbcUser,
                    vistaSettings.OdbcPassword);
            }

            if (factory == null)
                return null;

            IVistASession vistaSession = factory.MakeVistASession(new VistASite(vistaSettings.Id, vistaSettings.Name, vistaSettings.Number, vistaSettings.TimeZone, null));
            vistaSession.Open(connection);

            return vistaSession;
        }

        public static string GetOrderableItemIen(string code)
        {
            int index = code.LastIndexOf('_');
            return code.Substring(index + 1);
        }

        public static DateTime GetPropertyForOrder(object obj)
        {
            if ((obj as OrderAction) != null)
                return (obj as OrderAction).DateTimeOrdered;
            else if ((obj as ScheduledAdmission) != null)
                return (obj as ScheduledAdmission).ReservationDateTime;
            else if ((obj as PatientAppointment) != null)
                return (obj as PatientAppointment).AppointmentDateTime;
            else if ((obj as PatientMovement) != null)
                return (obj as PatientMovement).DateTime;
            return DateTime.MinValue;
        }

        public static IList<CDWithProperties> GetOrderableItem(List<string> ordersOrderableItem, string vistaCode, IList<CDWithProperties> orderableItems)
        {
            if (ordersOrderableItem != null && ordersOrderableItem.Count > 0)
            {
                //select OrderableItem of the order
                string ordItem = ordersOrderableItem[0];
                //search order's OrderableItem in the ADT Orderable Items list
                int vistaSiteCodeLength = vistaCode.Length;
                int orderableItemIenLength = ordItem.Length;
                IList<CDWithProperties> cdpList = orderableItems.Where(a => (a.code.Substring(0, vistaSiteCodeLength) == vistaCode && a.code.Substring(a.code.Length - orderableItemIenLength, orderableItemIenLength) == ordItem.ToString())).ToList();
                return cdpList;
            }
            return null;
        }

        public static string GetOrderType(CDWithProperties cdp, IList<CD> orderableItemsTypes)
        {
            if (cdp != null)
            {
                // get the type property of the OrderableItem
                ConceptProperty cp = cdp.Properties.Where(a => a.PropertyName.text == "OrderableItemType").FirstOrDefault();
                if (cp != null)
                {
                    //get the type property value(type code) of the OrderableItem
                    string code = cp.PropertyValue.text;
                    //get the OrderableItemType list from EVS
                    if (orderableItemsTypes == null || orderableItemsTypes.Count == 0)
                        orderableItemsTypes = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParametersWithProperty() { VocabularyDomain = FC.Util.Vocabulary.OrderableItemType.ToString() });
                    //search type by type code
                    CD cd = orderableItemsTypes.Where(a => a.code == code).FirstOrDefault();
                    //return type display name(Admission/Discharge/Transfer)
                    return cd.displayName;
                }
            }
            return string.Empty;
        }

        public static string CreateOrderFacilitiesList(List<string> orderableItemIds, BMS.VistaIntegration.Data.VistASite vista, IList<CDWithProperties> orderableItems)
        {
            IList<CDWithProperties> cdpList = GetOrderableItem(orderableItemIds, vista.Name, orderableItems);
            if (cdpList == null)
                return null;
            StringBuilder sb = new StringBuilder();
            List<FC.Facility> facilityList = GetFacilitiesByVista(vista.Id);
            FC.Facility facility = null;
            foreach (CDWithProperties cdp in cdpList)
            {
                facility = facilityList.Where(a => a.Code == cdp.code.Split('_')[1]).FirstOrDefault();
                if (facility != null)
                {
                    sb.Append(facility.Id.extension);
                    sb.Append(",");
                }
            }
            return sb.ToString();
        }

        public static List<FC.Facility> GetFacilitiesByVista(string vistaId)
        {
            List<FC.Facility> result = new List<FC.Facility>();

            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetFacilitiesByVista.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@VISTA_UID", "'" + vistaId + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        foreach (DataRow dr in ds.Tables[0].Rows)
                            result.Add(new FC.Facility() { Id = new II(DomainId, dr["IDENTIFIER"].ToString()), Name = dr["NAME"].ToString(), Code = dr["CODE"].ToString() });
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            return result;
        }

        public static List<FC.HospitalLocation> GetHospitalLocationsByVista(string vistaId)
        {
            List<FC.HospitalLocation> result = new List<FC.HospitalLocation>();

            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetHospitalLocationsByVista.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@VISTA_UID", "'" + vistaId + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        foreach (DataRow dr in ds.Tables[0].Rows)
                            result.Add(new FC.HospitalLocation() { Id = new II(DomainId, dr["IDENTIFIER"].ToString()), Name = dr["NAME"].ToString(), Ien = dr["IEN"].ToString(), WardLocationId = dr["WARD_UID"].ToString() });
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            return result;
        }

        public static II GetPatientBySsn(string ssn)
        {
            II result = null;
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetPatientBySsn.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@PATIENT_SSN", "'" + ssn + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows != null && ds.Tables[0].Rows.Count > 0)                        
                            result = new II(DomainId, ds.Tables[0].Rows[0][0].ToString());
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            return result;
        }

        public static II GetPersonByIen(string ien, string vistaId)
        {
            II result = null;
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetPersonByIen.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@PERSON_IEN", "'" + ien + "'");
            sql = sql.Replace("@VISTA_SITE_ID", "'" + vistaId + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows != null && ds.Tables[0].Rows.Count > 0)                        
                            result = new II(DomainId, ds.Tables[0].Rows[0][0].ToString());                        
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }            
            return result;
        }

        public static List<Person> GetPersonsByVista(string vistaId)
        {
            List<Person> result = new List<Person>();
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetPersonsByVista.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@VISTA_SITE_ID", "'" + vistaId + "'");            
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        foreach (DataRow dr in ds.Tables[0].Rows)
                        {
                            result.Add(new Person() {
                                FirstName = dr["FIRST_NAME"].ToString(),
                                LastName = dr["LAST_NAME"].ToString(),
                                MiddleName = dr["MIDDLE_NAME"].ToString(),
                                Ien = dr["IEN"].ToString(),
                                Id = new II(DomainId, dr["IDENTIFIER"].ToString()) 
                            });
                        }                        
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            return result;
        }

        public static FC.Ward GetWardByIen(string ien, string vistaId)
        {
            FC.Ward result = new FC.Ward();
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetWardByIen.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@WARD_IEN", "'" + ien + "'");
            sql = sql.Replace("@VISTA_UID", "'" + vistaId + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows != null && ds.Tables[0].Rows.Count > 0)
                        {
                            DataRow dr = ds.Tables[0].Rows[0];
                            result.Name = dr[0].ToString();
                            result.Id = new II(DomainId, dr[1].ToString());
                        }
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            if (result.Id == null || string.IsNullOrEmpty(result.Id.extension) || result.Id.extension.Equals(Guid.Empty.ToString()))
                result = null;
            return result;
        }

        public static string InsertWard(WardLocation ward, string vistaId)
        {
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/InsertWardLocation.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            string uid = Guid.NewGuid().ToString();
            sql = sql.Replace("@UID", "'" + uid + "'");
            sql = sql.Replace("@WARD_NAME", "'" + ward.Name.Replace("'", "''") + "'");
            sql = sql.Replace("@WARD_IEN", "'" + ward.IEN + "'");
            sql = sql.Replace("@WARD_SPECIALTY", "'" + ward.Specialty + "'");
            sql = sql.Replace("@VISTA_UID", "'" + vistaId + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            return uid;
        }

        public static FC.Bed GetBedByIen(string ien, string wardUid)
        {
            FC.Bed result = new FC.Bed();
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetBedByIen.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@WARD_UID", "'" + wardUid + "'");
            sql = sql.Replace("@BED_IEN", "'" + ien + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows != null && ds.Tables[0].Rows.Count > 0)
                        {
                            DataRow dr = ds.Tables[0].Rows[0];
                            result.Name = dr[0].ToString();
                            result.Id = new II(DomainId, dr[1].ToString());
                        }
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            if (result.Id == null || string.IsNullOrEmpty(result.Id.extension) || result.Id.extension.Equals(Guid.Empty.ToString()))
                result = null;
            return result;
        }

        public static List<string> GetWardBedFromAdmission(string admissionIen, string vistaUid)
        {
            List<string> result = new List<string>();
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetWardBedFromAdmission.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@IEN", "'" + admissionIen + "'");
            sql = sql.Replace("@VISTA_UID", "'" + vistaUid + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMSDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.BmsConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows != null && ds.Tables[0].Rows.Count > 0)
                        {
                            DataRow dr = ds.Tables[0].Rows[0];
                            result.Add(dr[0].ToString());
                            result.Add(dr[1].ToString());
                        }
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }            
            return result;
        }

        public static string GetWardFromAdmission(string patientUid, string vistaUid, DateTime dateTime)
        {
            string result = null;
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetWardFromAdmission.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@PATIENT_UID", "'" + patientUid + "'");
            sql = sql.Replace("@VISTA_UID", "'" + vistaUid + "'");
            sql = sql.Replace("@DATE_TIME", "'" + String.Format("{0:G}", dateTime) + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMSDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.BmsConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows != null && ds.Tables[0].Rows.Count > 0)                        
                            result = ds.Tables[0].Rows[0][0].ToString();
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            return result;
        }

        public static string GetSSN(string ssn)
        {
            if (string.IsNullOrEmpty(ssn))
                return null;
            try
            {
                if (ssn.Split('-').Count() == 3)
                    return ssn;
                return ssn.Substring(0, 3) + "-" + ssn.Substring(3, 2) + "-" + ssn.Substring(5);
            }
            catch
            {
                return ssn;
            }
        }

        public static FC.Patient TranslatePatient(BMS.VistaIntegration.Data.Patient entity, BMS.VistaIntegration.FacadeContracts.VistASite vista)
        {
            FC.Patient bmsEntity = new FC.Patient();
            Dictionary<string, string> names = BMS.Utils.Utilities.SplitPersonFullName(entity.Name);
            bmsEntity.FirstName = names[Constants.PERSON_FIRST_NAME];
            bmsEntity.Gender = genderList.Where(a => a.code.ToLower() == entity.Sex.ToString().ToLower()).FirstOrDefault();
            if (bmsEntity.Gender == null)
                bmsEntity.Gender = genderList.Where(a => a.code.Equals("UNK", StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
            bmsEntity.Ien = vista.Name + "_" + entity.IEN;
            bmsEntity.LastName = names[Constants.PERSON_LAST_NAME];
            bmsEntity.MiddleName = names[Constants.PERSON_MIDDLE_NAME];
            bmsEntity.SSN = new II(Constants.SSNROOT, Utils.GetSSN(entity.SocialSecurityNumber));
            if (DateTime.Compare(entity.DateOfBirth, DateTime.Parse("1/1/1753")) < 0)
                bmsEntity.DateOfBirth = DateTime.Parse("1/1/1753");
            else
                bmsEntity.DateOfBirth = entity.DateOfBirth;
            bmsEntity.ServiceConnectedPercentage = entity.ServiceConnectedPercentage.HasValue ? entity.ServiceConnectedPercentage.Value.ToString() : string.Empty;
            bmsEntity.IsVistaValidated = true;
            bmsEntity.AdmittingDiagnosis = entity.AdmittingDiagnosis;
            bmsEntity.AttendingPhysicianId = new II(DomainId, null);
            if (entity.AttendingPhysician != null)
            {
                Dictionary<string, string> personNames = Utilities.SplitPersonFullName(entity.AttendingPhysician.Name);
                bmsEntity.AttendingPhysician = new FC.Person()
                {
                    Id = bmsEntity.AttendingPhysicianId,
                    Ien = entity.AttendingPhysician.IEN,
                    LastName = personNames[Constants.PERSON_LAST_NAME],
                    MiddleName = personNames[Constants.PERSON_MIDDLE_NAME],
                    FirstName = personNames[Constants.PERSON_FIRST_NAME],
                    VistaSite = new II(Utils.DomainId, vista.Id),
                    DateOfBirth = DateTime.MinValue
                };
            }
            bmsEntity.TreatingSpecialty = string.IsNullOrEmpty(entity.TreatingSpecialtyId) ? new CD() : new CD() { code = vista.Name + "_" + entity.TreatingSpecialtyId };
            return bmsEntity;
        }

        public static FC.HospitalLocation TranslateHospitalLocation(BMS.VistaIntegration.Data.HospitalLocation entity, string vistaSiteId)
        {
            FC.HospitalLocation bmsEntity = new FC.HospitalLocation();
            bmsEntity.Abbrevation = entity.Abbreviation;
            bmsEntity.Ien = entity.IEN;
            bmsEntity.Name = entity.Name;            
            if (!string.IsNullOrEmpty(entity.Telephone))                
                bmsEntity.Telephone = "tel:" + entity.Telephone;
            if (!string.IsNullOrEmpty(entity.WardLocationId) && entity.WardLocation != null)
            {
                FC.Ward ward = Utils.GetWardByIen(entity.WardLocationId, vistaSiteId);
                if (ward == null)
                    bmsEntity.WardLocationId = InsertWard(entity.WardLocation, vistaSiteId);
                else
                    bmsEntity.WardLocationId = ward.Id.extension;
            }
            return bmsEntity;
        }

        public static void InsertVistaOperation(string vistaId, string operationId, DateTime endDate)
        {
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/VistaOperation.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@VISTA_ID", vistaId);
            sql = sql.Replace("@OPERATION_ID", operationId);
            sql = sql.Replace("@END_DATE", endDate.ToString());
            //String strConnString = ConfigurationManager.ConnectionStrings["BMSDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            using (SqlCommand cmd = GlobalConnections.BmsConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                try
                {
                   cmd.ExecuteNonQuery();
                }
                catch (SqlException e)
                {
                    throw(e);
                }
                
            }
        }

        public static List<DC.VistaIntegrationLog> GetAlreadyExistsVistaIntegrationLogs(List<string> iens, string vistaFile, string vistaCode)
        {
            List<DC.VistaIntegrationLog> result = new List<DC.VistaIntegrationLog>();
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/GetVistaIntegrationLog.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@VISTA_SITE_CODE", "'" + vistaCode + "'");
            sql = sql.Replace("@VISTA_FILE", "'" + vistaFile + "'");
            //String strConnString = ConfigurationManager.ConnectionStrings["BMSDBConnString"].ConnectionString;
            //SqlConnection connection = new SqlConnection(strConnString);
            DataSet ds = new DataSet();
            List<string> existingIens = new List<string>();
            using (SqlCommand cmd = GlobalConnections.BmsConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    adapter.SelectCommand = cmd;
                    adapter.Fill(ds);
                    if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
                    {                        
                        foreach (DataRow dr in ds.Tables[0].Rows)
                            existingIens.Add(dr["IEN"].ToString());
                    }
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
            
            foreach (string ien in existingIens)
            {
                if (iens.Contains(ien))
                    result.Add(new DC.VistaIntegrationLog() { File = vistaFile, Ien = ien });
            }
            return result;
        }

        public static void SaveVistaIntegrationLog(string ien, string vistaCode, string vistaFileName)
        {
            string sql = "";
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/InsertVistaIntegrationLog.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            sql = sql.Replace("@P_IEN", "'" + ien + "'");
            sql = sql.Replace("@P_VISTA_FILE", "'" + vistaFileName + "'");
            sql = sql.Replace("@P_VISTA", "'" + vistaCode + "'");

            DataSet ds = new DataSet();
            using (SqlCommand cmd = GlobalConnections.BmsConnection.CreateCommand())
            {
                cmd.CommandText = sql;
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
        }

        public static void SaveAttendingForPatients(List<BMS.VistaIntegration.Data.Patient> vistaPatients, List<Person> persons)
        {
            StringBuilder sb = new StringBuilder();
            string sql = string.Empty;
            string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
            string filePath = theDirectory + "/SqlScripts/UpdateAttendingForPatient.sql";
            using (FileStream strm = File.OpenRead(filePath))
            {
                StreamReader reader = new StreamReader(strm);
                sql = reader.ReadToEnd();
            }
            
            II patientId = null;
            string attendingId = null;
            foreach (BMS.VistaIntegration.Data.Patient patient in vistaPatients)
            {                
                patientId = Utils.GetPatientBySsn(Utils.GetSSN(patient.SocialSecurityNumber));
                if (patientId != null)
                {
                    if (patient.AttendingPhysician != null && !string.IsNullOrEmpty(patient.AttendingPhysician.IEN))
                        attendingId = persons.Where(a => a.Ien == patient.AttendingPhysician.IEN).FirstOrDefault().Id.extension.ToUpper();
                    else
                        attendingId = null;
                    sb.AppendLine(sql);
                    sb.Replace("@PATIENT_UID", "'" + patientId.extension + "'").Replace("@ATTENDING_PHYSICIAN", attendingId != null ? "'" + DomainId + "_" + attendingId + "'" : "NULL");
                }
            }
            
            using (SqlCommand cmd = GlobalConnections.EisConnection.CreateCommand())
            {
                cmd.CommandText = sb.ToString();
                cmd.CommandType = CommandType.Text;
                cmd.CommandTimeout = GlobalConnections.BmsConnection.ConnectionTimeout;
                SqlDataAdapter adapter = new SqlDataAdapter();
                try
                {
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException)
                {
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                    adapter.Dispose();
                }
            }
        }
    }
}
