SELECT	O.NAME,
		E.IDENTIFIER,
		U.IDENTIFIER_EXTENSION AS 'IEN',
		TV.TRAIT_VALUE_STRING AS WARD_UID
FROM EHL7_ORGANIZATION AS O
	INNER JOIN ENTITY AS E ON O.PFK_ORGANIZATION = E.PK_ENTITY
	INNER JOIN EHL7_ROLE AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND CLASS_CODE = 'MBR'
	INNER JOIN ENTITY AS VS ON R.FK_SCOPER_ENTITY = VS.PK_ENTITY
	INNER JOIN EHL7_UID AS U ON O.PFK_ORGANIZATION = U.FK_ENTITY AND U.IDENTIFIER_ROOT = 'IEN'
	LEFT JOIN TRAIT_VALUE AS TV ON TV.FK_ENTITY = O.PFK_ORGANIZATION
	LEFT JOIN TRAIT_ASSIGNMENT_ENTITY_TYPE AS TA ON TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TA.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE
	LEFT JOIN TRAIT AS T ON TA.FK_TRAIT = T.PK_TRAIT 
WHERE VS.IDENTIFIER = @VISTA_UID AND O.CODE_CODE = 'HLOC' AND T.IDENTIFIER = 'WARD_LOCATION_ID'