﻿using System.ComponentModel;
using System;
using System.Collections.Generic;
using System.IO;

namespace BMSConfigurationWarlock
{
    public class SqlScript : INotifyPropertyChanged
    {
        private string name;
        private bool run;

        public string Name
        {
            get { return Path.GetFileName(name); }
            set 
            {
                if (name != value)
                {
                    name = value;
                    NotifyPropertyChanged(NameOf<SqlScript>.Property(e => e.Name));
                }
            }
        }

        public bool Run
        {
            get { return run; }
            set
            {
                if (run != value)
                {
                    run = value;
                    NotifyPropertyChanged(NameOf<SqlScript>.Property(e => e.Run));
                }
            }
        }

        public List<string> Variables;

        #region INotifyPropertyChanged

        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(String info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }

        #endregion
    }
}
