﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Xml.Serialization;
using System.ComponentModel;

namespace BMSConfigurationWarlock
{
    [XmlRoot("Service")]
    public class ServiceConfiguration : INotifyPropertyChanged
    {
        private string assemblyName;
        private string executablePath;

        [XmlIgnore]
        public string ExecutablePath
        {
            get { return executablePath; }
            set
            {
                if (executablePath != value)
                {
                    executablePath = value;
                    NotifyPropertyChanged(NameOf<ServiceConfiguration>.Property(e => e.ExecutablePath));
                    NotifyPropertyChanged(NameOf<ServiceConfiguration>.Property(e => e.ConfigurationPath));
                    NotifyPropertyChanged(NameOf<ServiceConfiguration>.Property(e => e.ConnectionsXmlPath));
                }
            }
        }
        public string ConfigurationPath { get { return string.Format("{0}.config", ExecutablePath); } }
        public string ConnectionsXmlPath 
        {
            get
            {
                Configuration config = ConfigurationManager.OpenExeConfiguration(ExecutablePath);
                if (config.AppSettings.Settings[Constants.DatasetPath] == null || string.IsNullOrEmpty((string)config.AppSettings.Settings[Constants.DatasetPath].Value))
                {
                    //does not have a DatasetPath
                    return "";
                }
                else
                    return Path.Combine(Path.GetDirectoryName(ExecutablePath), (string)config.AppSettings.Settings[Constants.DatasetPath].Value, Constants.ConnectionsXml);
            }
        }

        public ServiceConfiguration() 
        {
            DatabaseConnections = new List<DatabaseConnection>();
        }

        [XmlElement("AssemblyName")]
        public string AssemblyName 
        { 
            get { return assemblyName; }
            set 
            {
                if (assemblyName != value)
                {
                    assemblyName = value;
                    NotifyPropertyChanged(NameOf<ServiceConfiguration>.Property(e => e.AssemblyName));
                }
            }
        }

        [XmlElement("Connection")]
        public List<DatabaseConnection> DatabaseConnections { get; set; }

        #region INotifyPropertyChanged

        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(String info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }

        #endregion
    }
}
