﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Configuration;

namespace BMSConfigurationWarlock
{
    /// <summary>
    /// Interaction logic for GeneralConfiguration.xaml
    /// </summary>
    public partial class GeneralConfiguration : UserControl
    {
        internal GeneralConfigurationModel model;
        public event GeneralConfigurationSavedEventHandler OnSave;

        public GeneralConfiguration()
        {
            InitializeComponent();
            Loaded += new RoutedEventHandler(GeneralConfiguration_Loaded);
        }

        void GeneralConfiguration_Loaded(object sender, RoutedEventArgs e)
        {
            if (model == null)
            {
                model = new GeneralConfigurationModel();
                Populate(model);
                this.DataContext = model;
            }
        }

        private void Populate(GeneralConfigurationModel model)
        {
            try
            {
                model.Versions = ConfigurationManager.AppSettings[Constants.Versions].Split(new char[] { ';' }).ToList<string>();
            }
            catch { model.Versions = new List<string>(); }
            try
            {
                model.SelectedVersion = ConfigurationManager.AppSettings[Constants.DefaultVersion];
            }
            catch { model.SelectedVersion = String.Empty; }
            try
            {
                model.ServicesPort = ConfigurationManager.AppSettings[Constants.PreferredServicesPort];
            }
            catch { model.ServicesPort = String.Empty; }
            try
            {
                model.ServicesServer = ConfigurationManager.AppSettings[Constants.PreferredServicesServer];
            }
            catch { model.ServicesServer = String.Empty; }
            try
            {
                model.ServicesPrefix = ConfigurationManager.AppSettings[Constants.PreferredServicesPrefix];
            }
            catch { model.ServicesPrefix = String.Empty; }
            try
            {
                model.ApplicationName = ConfigurationManager.AppSettings[Constants.PreferredApplicationName];
            }
            catch { model.ApplicationName = String.Empty; }
            try
            {
                model.WebServer = ConfigurationManager.AppSettings[Constants.PreferredWebServer];
            }
            catch { model.WebServer = String.Empty; }
            try
            {
                model.DatabaseServer = ConfigurationManager.AppSettings[Constants.PreferredDatabaseServer];
            }
            catch { model.DatabaseServer = String.Empty; }
        }

        private void SaveButtonClick(object sender, RoutedEventArgs e)
        {
            SaveConfigurations();
            if (OnSave != null)
                OnSave(this, new GeneralConfigurationSavedEventArgs() { model = this.model });
        }

        private void SaveConfigurations()
        {
            System.Configuration.Configuration config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);

            //general configurations window settings
            config.AppSettings.Settings[Constants.DefaultVersion].Value = model.SelectedVersion;
            config.AppSettings.Settings[Constants.PreferredApplicationName].Value = model.ApplicationName;
            config.AppSettings.Settings[Constants.PreferredDatabaseServer].Value = model.DatabaseServer;
            config.AppSettings.Settings[Constants.PreferredServicesPort].Value = model.ServicesPort;
            config.AppSettings.Settings[Constants.PreferredServicesPrefix].Value = model.ServicesPrefix;
            config.AppSettings.Settings[Constants.PreferredServicesServer].Value = model.ServicesServer;
            config.AppSettings.Settings[Constants.PreferredWebServer].Value = model.WebServer;

            config.Save(ConfigurationSaveMode.Modified);
            ConfigurationManager.RefreshSection("appSettings");
        }
    }
}
