USE Master
GO
EXEC sp_configure 'show advanced options', 1
GO
RECONFIGURE
GO
EXEC sp_configure 'xp_cmdshell', 1
GO
RECONFIGURE
GO
EXEC sp_configure 'clr enabled', '1'
GO
RECONFIGURE

/***************
 *	Credential *
 ***************/
PRINT 'Creating BMSSqlCredential Credential'
USE [master]
GO
IF NOT EXISTS (SELECT name FROM [master].sys.credentials WHERE name = N'BMSSqlCredential')
	CREATE CREDENTIAL [BMSSqlCredential] WITH IDENTITY = N'SERVER', SECRET = N'Scubapro04'
GO

/**********
 *	Proxy *
 *********/
PRINT 'Begin BMSSqlProxy Proxy'
USE [msdb]
GO
IF  EXISTS (SELECT name FROM msdb.dbo.sysproxies WHERE name = N'BMSSqlProxy')
	begin
		PRINT 'Deleting existing BMSSqlProxy Proxy'
		EXEC msdb.dbo.sp_delete_proxy @proxy_name=N'BMSSqlProxy'
	end
GO
PRINT 'Creating BMSSqlProxy Proxy'
EXEC msdb.dbo.sp_add_proxy @proxy_name=N'BMSSqlProxy',@credential_name=N'BMSSqlCredential', @enabled=1
GO
PRINT 'Granting BMSSqlProxy subsystem rights'
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=2
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=3
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=6
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=7
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=8
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=4
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=5
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=10
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=9
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=11
GO
EXEC msdb.dbo.sp_grant_proxy_to_subsystem @proxy_name=N'BMSSqlProxy', @subsystem_id=12
GO

/********************
 *	Create Databases *
 ********************/
PRINT 'Begin BMS_AUTHZ Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS_AUTHZ')
	begin
		PRINT 'Creating BMS_AUTHZ Database'
		CREATE DATABASE [BMS_AUTHZ] ON  PRIMARY 
		( NAME = N'BMS_AUTHZ_Data', FILENAME = N'e:\BMS\Data\BMS_AUTHZ.mdf' , SIZE = 30272KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
		 LOG ON 
		( NAME = N'BMS_AUTHZ_Log', FILENAME = N'l:\BMS\Data\BMS_AUTHZ.ldf' , SIZE = 1792KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_AUTHZ_Backup')
	begin
		PRINT 'Creating BMS_AUTHZ_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_AUTHZ_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_AUTHZ_Backup.bak'
	end
GO

PRINT 'Begin BMS Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS')
	begin
		PRINT 'Creating BMS Database'
		CREATE DATABASE [BMS] ON  PRIMARY 
		( NAME = N'BMS_Data', FILENAME = N'e:\BMS\Data\BMS.mdf' , SIZE = 7168KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
		 LOG ON 
		( NAME = N'BMS_Log', FILENAME = N'l:\BMS\Data\BMS.ldf' , SIZE = 8384KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_Backup')
	begin
		PRINT 'Creating BMS_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_Backup.bak'
	end
GO

PRINT 'Begin BMS_DS Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS_DS')
	begin
		PRINT 'Creating BMS_DS Database'
		CREATE DATABASE [BMS_DS] ON  PRIMARY 
		( NAME = N'BMS_DS_Data', FILENAME = N'e:\BMS\Data\BMS_DS.mdf' , SIZE = 7488KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
		 LOG ON 
		( NAME = N'BMS_DS_Log', FILENAME = N'l:\BMS\Data\BMS_DS.ldf' , SIZE = 12672KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_DS_Backup')
	begin
		PRINT 'Creating BMS_DS_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_DS_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_DS_Backup.bak'
	end
GO

PRINT 'Begin BMS_DW Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS_DW')
	begin
		PRINT 'Creating BMS_DW Database'
		CREATE DATABASE [BMS_DW] ON  PRIMARY 
		( NAME = N'BMS_DW_Data', FILENAME = N'e:\BMS\Data\BMS_DW.mdf' , SIZE = 11264KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
		 LOG ON 
		( NAME = N'BMS_DW_Log', FILENAME = N'l:\BMS\Data\BMS_DW.ldf' , SIZE = 11200KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_DW_Backup')
	begin
		PRINT 'Creating BMS_DW_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_DW_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_DW_Backup.bak'
	end
GO

PRINT 'Begin BMS_EIS Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS_EIS')
	begin
		PRINT 'Creating BMS_EIS Database'
		CREATE DATABASE [BMS_EIS] ON  PRIMARY 
		( NAME = N'BMS_EIS_Data', FILENAME = N'e:\BMS\Data\BMS_EIS.mdf' , SIZE = 10688KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
		 LOG ON 
		( NAME = N'BMS_EIS_Log', FILENAME = N'l:\BMS\Data\BMS_EIS.ldf' , SIZE = 1024KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_EIS_Backup')
	begin
		PRINT 'Creating BMS_EIS_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_EIS_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_EIS_Backup.bak'
	end
GO

PRINT 'Begin BMS_EVS Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS_EVS')
	begin
		PRINT 'Creating BMS_EVS Database'
		CREATE DATABASE [BMS_EVS] ON  PRIMARY 
		( NAME = N'BMS_EVS_Data', FILENAME = N'e:\BMS\Data\BMS_EVS.mdf' , SIZE = 9600KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB ), 
		 FILEGROUP [ftfg_evsCatalog] 
		( NAME = N'BMS_ftrow_evsCatalog', FILENAME = N'e:\BMS\Data\BMS_EVS.EVS_evsCatalog' , SIZE = 268736KB , MAXSIZE = UNLIMITED, FILEGROWTH = 10%)
		 LOG ON 
		( NAME = N'BMS_EVS_Log', FILENAME = N'l:\BMS\Data\BMS_EVS.ldf' , SIZE = 768KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_EVS_Backup')
	begin
		PRINT 'Creating BMS_EVS_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_EVS_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_EVS_Backup.bak'
	end
GO

Print 'Begin BMS_HISTORY Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS_HISTORY')
	begin
		Print 'Creating BMS_HISTORY Database'
		CREATE DATABASE [BMS_HISTORY] ON  PRIMARY 
		( NAME = N'BMS_HISTORY_Data', FILENAME = N'e:\BMS\Data\BMS_HISTORY.mdf' , SIZE = 6144KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
		 LOG ON 
		( NAME = N'BMS_HISTORY_Log', FILENAME = N'l:\BMS\Data\BMS_HISTORY.ldf' , SIZE = 1024KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_HISTORY_Backup')
	begin
		Print 'Creating BMS_HISTORY_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_HISTORY_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_HISTORY_Backup.bak'
	end
GO

Print 'Begin BMS_InstanceStore Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS_InstanceStore')
	begin
		Print 'Creating BMS_InstanceStore Database'
		CREATE DATABASE [BMS_InstanceStore] ON  PRIMARY 
		( NAME = N'BMS_InstanceStore_Data', FILENAME = N'e:\BMS\Data\BMS_InstanceStore.mdf' , SIZE = 3328KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
		 LOG ON 
		( NAME = N'BMS_InstanceStore__Log', FILENAME = N'l:\BMS\Data\BMS_InstanceStore.ldf' , SIZE = 2560KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_InstanceStore_Backup')
	begin
		Print 'Creating BMS_InstanceStore_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_InstanceStore_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_InstanceStore_Backup.bak'
	end
GO

PRINT 'Begin BMS_VISTA Database'
USE [master]
GO
IF  NOT EXISTS (SELECT name FROM sys.databases WHERE name = N'BMS_VISTA')
	begin
		PRINT 'Creating BMS_VISTA Database'
		CREATE DATABASE [BMS_VISTA] ON  PRIMARY 
		( NAME = N'BMS_VISTA_DB_Data', FILENAME = N'e:\BMS\Data\BMS_VISTA.mdf' , SIZE = 4096KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
		 LOG ON 
		( NAME = N'BMS_VISTA_DB_Log', FILENAME = N'l:\BMS\Data\BMS_VISTA.ldf' , SIZE = 1024KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
	end
GO

IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'BMS_VISTA_Backup')
	begin
		PRINT 'Creating BMS_VISTA_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'BMS_VISTA_Backup', @physicalname = N'e:\BMS\Data\Bkups\BMS_VISTA_Backup.bak'
	end
GO

/*************************
 *	Non-BMS Related DB's *
 *************************/
IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'ReportServer_Backup')
	begin
		PRINT 'Creating ReportServer_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'ReportServer_Backup', @physicalname = N'e:\BMS\Data\Bkups\ReportServer_Backup.bak'
	end
GO

IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'ReportServerTempDB_Backup')
	begin
		PRINT 'Creating ReportServerTempDB_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'ReportServerTempDB_Backup', @physicalname = N'e:\BMS\Data\Bkups\ReportServerTempDB_Backup.bak'
	end
GO

PRINT 'Creating System Databases Backup Devices if needed'

IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'MasterDB_Backup')
	begin
		PRINT 'Creating MasterDB_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'MasterDB_Backup', @physicalname = N'e:\BMS\Data\Bkups\MasterDB_Backup.bak'
	end
GO

IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'ModelDB_Backup')
	begin
		PRINT 'Creating ModelDB_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'ModelDB_Backup', @physicalname = N'e:\BMS\Data\Bkups\ModelDB_Backup.bak'
	end
GO

IF  NOT EXISTS (SELECT name FROM master.dbo.sysdevices WHERE name = N'MsdbDB_Backup')
	begin
		PRINT 'Creating MsdbDB_Backup Device'
		EXEC master.dbo.sp_addumpdevice  @devtype = N'disk', @logicalname = N'MsdbDB_Backup', @physicalname = N'e:\BMS\Data\Bkups\MsdbDB_Backup.bak'
	end
GO

/***********************
 *	BMS - Reports Full *
 ***********************/
Print 'Creating BMS - Reports Full Job'
USE [msdb]
GO

/****** Object:  Job [BMS - Reports Full]    Script Date: 03/07/2012 15:40:56 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'BMS - Reports Full')
EXEC msdb.dbo.sp_delete_job @job_id=N'b1191751-57a7-47bd-81fc-d9d980b51b61', @delete_unused_schedule=1
GO

USE [msdb]
GO

/****** Object:  Job [BMS - Reports Full]    Script Date: 03/07/2012 15:37:07 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 03/07/2012 15:37:07 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'BMS - Reports Full', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'No description available.', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'SERVER', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Start job full]    Script Date: 03/07/2012 15:37:08 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Start job full', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'declare @d datetime', 
		@database_name=N'BMS_DS', 
		@output_file_name=N'D\BMS\Job_logs\BMS_Reports_Log.txt', 
		@flags=4
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Apelare procedura sp_infoworld_pachet_full]    Script Date: 03/07/2012 15:37:08 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Apelare procedura sp_infoworld_pachet_full', 
		@step_id=2, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'EXEC sp_infoworld_pachet_full', 
		@database_name=N'BMS_DS', 
		@output_file_name=N'D\BMS\Job_logs\BMS_Reports_Log.txt', 
		@flags=6
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Shrink BMS_DS]    Script Date: 03/07/2012 15:37:08 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Shrink BMS_DS', 
		@step_id=3, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'DBCC SHRINKFILE (2, 1);', 
		@database_name=N'BMS_DS', 
		@output_file_name=N'D\BMS\Job_logs\BMS_Reports_Log.txt', 
		@flags=6
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Clear data from DW]    Script Date: 03/07/2012 15:37:08 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Clear data from DW', 
		@step_id=4, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'EXEC usp_ETL_Clear_Data', 
		@database_name=N'BMS_DW', 
		@output_file_name=N'D\BMS\Job_logs\BMS_Reports_Log.txt', 
		@flags=6
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Apelare procedura full pe DW]    Script Date: 03/07/2012 15:37:08 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Apelare procedura full pe DW', 
		@step_id=5, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'EXEC usp_ETL_ProcessFull', 
		@database_name=N'BMS_DW', 
		@output_file_name=N'D\BMS\Job_logs\BMS_Reports_Log.txt', 
		@flags=6
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Every night', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=1, 
		@freq_subday_interval=0, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20111031, 
		@active_end_date=99991231, 
		@active_start_time=50000, 
		@active_end_time=235959, 
		@schedule_uid=N'95da48bd-0908-46fc-932e-6937605db9e9'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:

GO


/******************************
 *	BMS - Reports Incremental *
 ******************************/
Print 'Creating BMS - Reports Incremental Job'
USE [msdb]
GO
USE [msdb]
GO

/****** Object:  Job [BMS - Reports Incremental]    Script Date: 03/07/2012 15:39:55 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'BMS - Reports Incremental')
EXEC msdb.dbo.sp_delete_job @job_id=N'bab267e3-252d-40d3-a45a-c323ec7248a3', @delete_unused_schedule=1
GO

USE [msdb]
GO

/****** Object:  Job [BMS - Reports Incremental]    Script Date: 03/07/2012 15:39:55 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 03/07/2012 15:39:55 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'BMS - Reports Incremental', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'No description available.', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'SERVER', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Start job incremental]    Script Date: 03/07/2012 15:39:55 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Start job incremental', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'declare @d datetime', 
		@database_name=N'BMS_DS', 
		@output_file_name=N'D:\BMS\Job_logs\BMS_Reports_Log_Incremental.txt', 
		@flags=4
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Check state job full]    Script Date: 03/07/2012 15:39:56 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Check state job full', 
		@step_id=2, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'exec dbo.usp_Check_Job ''BMS - Reports Full''', 
		@database_name=N'BMS_DS', 
		@output_file_name=N'D:\BMS\Job_logs\BMS_Reports_Log_Incremental.txt', 
		@flags=6
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Call procedure sp_infoworld_incremental_package]    Script Date: 03/07/2012 15:39:56 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Call procedure sp_infoworld_incremental_package', 
		@step_id=3, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'EXEC sp_infoworld_incremental_package', 
		@database_name=N'BMS_DS', 
		@output_file_name=N'D:\BMS\Job_logs\BMS_Reports_Log_Incremental.txt', 
		@flags=6
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Call procedure incremental DW]    Script Date: 03/07/2012 15:39:56 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Call procedure incremental DW', 
		@step_id=4, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'exec [usp_ETL_ProcessIncremental];', 
		@database_name=N'BMS_DW', 
		@output_file_name=N'D:\BMS\Job_logs\BMS_Reports_Log_Incremental.txt', 
		@flags=6
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Every day at every 5 minutes', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=4, 
		@freq_subday_interval=5, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20111031, 
		@active_end_date=99991231, 
		@active_start_time=80000, 
		@active_end_time=40000, 
		@schedule_uid=N'cf7251c3-bce7-4924-a888-08605cba3a07'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:

GO


/*********************************
 *	BBMS - Execute WMI_UserGroup *
 *********************************/
Print 'Creating BMS - Execute WMI_UserGroup'
USE [msdb]
GO

/****** Object:  Job [BMS - Execute WMI_UserGroup]    Script Date: 03/07/2012 15:15:26 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'BMS - Execute WMI_UserGroup')
EXEC msdb.dbo.sp_delete_job @job_id=N'f733ab13-ee5a-482d-8962-792f2eeccbba', @delete_unused_schedule=1
GO

USE [msdb]
GO

/****** Object:  Job [BMS - Execute WMI_UserGroup]    Script Date: 03/07/2012 15:15:26 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 03/07/2012 15:15:26 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'BMS - Execute WMI_UserGroup', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Executes the WMI_UsersGroup executable', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'SERVER', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Call WMI_UserGroup]    Script Date: 03/07/2012 15:15:26 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Call WMI_UserGroup', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'CmdExec', 
		@command=N'"d:\BMS\WMI_UserGroup\WMI_UserGroup.exe"', 
		@output_file_name=N'd:\BMS\Job_logs\BMS_WMI_USER_GROUP.txt', 
		@flags=42, 
		@proxy_name=N'BMSSqlProxy'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Recurring - 15 mins', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=4, 
		@freq_subday_interval=15, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20120126, 
		@active_end_date=99991231, 
		@active_start_time=200, 
		@active_end_time=235959, 
		@schedule_uid=N'03757279-98a2-4284-b029-add310c47a78'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:

GO

PRINT 'Restoring Databases'
USE Master
GO
RESTORE DATABASE [BMS] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO
RESTORE DATABASE [BMS_AUTHZ] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_AUTHZ_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO
RESTORE DATABASE [BMS_DS] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_DS_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO
RESTORE DATABASE [BMS_DW] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_DW_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO
RESTORE DATABASE [BMS_EIS] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_EIS_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO
RESTORE DATABASE [BMS_EVS] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_EVS_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO
RESTORE DATABASE [BMS_HISTORY] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_HISTORY_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO
RESTORE DATABASE [BMS_InstanceStore] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_InstanceStore_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO
RESTORE DATABASE [BMS_VISTA] FROM  DISK = N'e:\BMS\Data\Bkups\BMS_VISTA_Backup.bak' WITH  FILE = 1,  NOUNLOAD,  REPLACE,  STATS = 10
GO


PRINT 'Complete'