﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mdws2ORM.RpcQueries.Commands.Util
{
    public struct Line
    {
        public Line(string file, string ien, string field, string value) { File = file; Ien = ien; Field = field; Value = value; }
        public readonly string File;
        public readonly string Ien;
        public readonly string Field;
        public readonly string Value;
    }

    public static class TextParser
    {
        public static IEnumerable<Line> GetLines(string text)
        {
            int startIndex = 0;
            while (startIndex < text.Length)
            {
                int index = text.IndexOf('\n', startIndex);
                int index1 = text.IndexOf('^', startIndex) + 1;
                int index2 = text.IndexOf('^', index1) + 1;
                int index3 = text.IndexOf('^', index2) + 1;
                int index4 = text.IndexOf('^', index3, index - index3 + 1);
                if (index4 == -1) index4 = index;
                string file = text.Substring(startIndex, index1 - startIndex - 1);
                string ien = text.Substring(index1, index2 - index1 - 1);
                string field = text.Substring(index2, index3 - index2 - 1);
                string value = text.Substring(index3, index4 - index3 );
                yield return new Line(file, ien, field, value);
                startIndex = index + 1;
            }
        }
    }
}
