﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.BaseFields;

namespace Mdws2ORM.Maps.Fields
{
    public class ComputedFieldMap<T> : FieldMap<T>
        where T : class
    {
        private readonly bool fetchGetOnly;

        public ComputedFieldMap(string field, Action<T, string> mapAction, bool fetchGetOnly = false)
            : base(field, mapAction)
        {
            this.fetchGetOnly = fetchGetOnly;
        }

        public override bool FetchGetOnly
        {
            get
            {
                return fetchGetOnly;
            }
        }
    }
}
