﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mdws2ORM
{
    public class ListParamBuilder
    {
        private static string defaultFlags;
        private static ListParam defaultParam;

        internal static string DefaultFlags
        {
            get
            {
                return defaultFlags;
            }
            set
            {
                defaultFlags = value;
                defaultParam = new ListParamBuilder().Build();
            }
        }

        
        public static ListParam DefaultParam { get { return defaultParam; } }

        private string from = "";
        private string flags = DefaultFlags;
        private string partial = "";
        private string index = "#";
        private string screen = "";
        private string identity = "";
        private string number = "";

        public ListParamBuilder()
        {
            if (DefaultFlags == null)
                throw new InvalidOperationException("DefaultFlags must be set");
        }

        public ListParamBuilder From(string value)
        {
            from = value;
            return this;
        }

        public ListParamBuilder Number(string value)
        {
            number = value;
            return this;
        }

        public ListParamBuilder Screen(string value)
        {
            screen = value;
            return this;
        }

        public ListParamBuilder Flags(string value)
        {
            flags = value;
            return this;
        }

        public ListParamBuilder AppendFlags(string value)
        {
            flags += value;
            return this;
        }

        public ListParamBuilder Partial(string value)
        {
            partial = value;
            return this;
        }

        public ListParamBuilder Identity(string value)
        {
            identity = value;
            return this;
        }

        public ListParamBuilder Index(string value)
        {
            index = value;
            return this;
        }

        public ListParam Build()
        {
            return new ListParam(from, number, screen, flags, partial, identity, index);
        }
    }
}
