﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;
using Mdws2ORM.Core;
using BMS.VistaIntegration.Data;

namespace Mdws2ORM.Impl
{
    public class Session : ISession
    {
        private readonly EntityQuery entityQuery;
        private InitMapMediator initMediator;
        private readonly ICache cache;
        private readonly VistASite vistaSite;

        public Session(ICache cache, IEntryQuery entryQuery, InitMapMediator initMediator, VistASite vistaSite)
        {
            this.cache = cache;
            this.entityQuery = new EntityQuery(cache, entryQuery, vistaSite);
            this.initMediator = initMediator;
            this.vistaSite = vistaSite;
            ThrowExceptionWhenReferenceEntityNotFound = true;
            initMediator.GetTypes().ForEach(t => cache.AddCacheForType(t));
        }

        private BaseEntityMap<T> GetEntityMap<T>() where T : class
        {
            BaseEntityMap<T> entityMap = initMediator.GetBaseEntityMap<T>();
            entityMap.Initialize(initMediator);
            return entityMap;
        }


        public IEnumerable<ListItem<T>> List<T>(ListParam listParam, string iens = "")
            where T : class
        {
            BaseEntityMap<T> entityMap = GetEntityMap<T>();
            return entityQuery.List(entityMap, listParam, iens);
        }

        public T Get<T>(GetParam getParam, string iens)
            where T : class
        {
            BaseEntityMap<T> entityMap = GetEntityMap<T>();
            return entityQuery.Get(entityMap, getParam, iens);
        }

        public IEnumerable<T> GetSubEntities<T, P>(ListParam param, P parent, string iens)
            where T : class
            where P : class
        {
            SubEntityMapWithParent<T, P> subEntityMap = GetEntityMap<T>() as SubEntityMapWithParent<T, P>;
            return entityQuery.GetSubEntities(subEntityMap, param, parent, iens);
        }

        public IEnumerable<ListItem<T>> ListAllSubEntities<T, P>(ListParam listParam, ListParam subListParam, string iens = "")
            where T : class
            where P : class
        {
            SubEntityMapWithParent<T, P> subEntityMap = GetEntityMap<T>() as SubEntityMapWithParent<T, P>;
            BaseEntityMap<P> entityMap = GetEntityMap<P>();
            return entityQuery.ListAllSubEntities(subEntityMap, entityMap, listParam, subListParam, iens);
        }



        public IEnumerable<ListItem<T>> List<T>(ListParam listParam, BaseEntityMap<T> entityMap, string iens = "") where T : class
        {
            entityMap.Initialize(initMediator);
            return entityQuery.List(entityMap, listParam, iens);
        }



        public T Get<T>(GetParam getParam, string iens, BaseEntityMap<T> entityMap) where T : class
        {
            entityMap.Initialize(initMediator);
            return entityQuery.Get(entityMap, getParam, iens);
        }

        public IEnumerable<T> GetSubEntities<T, P>(ListParam param, P parent, string iens, SubEntityMapWithParent<T, P> subEntityMap)
            where T : class
            where P : class
        {
            subEntityMap.Initialize(initMediator);
            return entityQuery.GetSubEntities(subEntityMap, param, parent, iens);
        }


        public IEnumerable<ListItem<T>> ListAllSubEntities<T, P>(ListParam listParam, ListParam subListParam, SubEntityMapWithParent<T, P> subEntityMap, string iens = "")
            where T : class
            where P : class
        {
            subEntityMap.Initialize(initMediator);
            BaseEntityMap<P> entityMap = GetEntityMap<P>();
            return entityQuery.ListAllSubEntities(subEntityMap, entityMap, listParam, subListParam, iens);
        }

        public IEnumerable<ListItem<T>> ListAllSubEntities<T, P>(ListParam listParam, ListParam subListParam, SubEntityMapWithParent<T, P> subEntityMap, BaseEntityMap<P> entityMap, string iens = "")
            where T : class
            where P : class
        {
            subEntityMap.Initialize(initMediator);
            entityMap.Initialize(initMediator);
            return entityQuery.ListAllSubEntities(subEntityMap, entityMap, listParam, subListParam, iens);
        }



        public bool ThrowExceptionWhenReferenceEntityNotFound
        {
            get
            {
                return entityQuery.ThrowExceptionWhenReferenceEntityNotFound;
            }
            set
            {
                entityQuery.ThrowExceptionWhenReferenceEntityNotFound = value;
            }
        }


        private Type GetType<T>()
        {
            Type type = typeof(T);
            if (!initMediator.GetTypes().Contains(type))
                throw new InvalidOperationException();

            return type;
        }
        public void ResetCacheForType<T>() where T : class
        {
            cache.ResetCacheForType<T>();
        }

        public void ResetCache()
        {
            cache.ResetCache();
        }

        public void SetCacheForType<T>(bool isEnabled) where T : class
        {
            Type type = GetType<T>();
            if (isEnabled)
                cache.AddCacheForType(type);
            else
                cache.RemoveCacheForType(type);
        }

    }
}
