﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mdws2ORM.Core
{
    public struct QueryParam
    {
        public QueryParam(string file, string fieldParam, string[] fields)
        {
            if (string.IsNullOrEmpty(file))
                throw new ArgumentNullException();

            if (string.IsNullOrEmpty(fieldParam))
                throw new ArgumentNullException();

            if (Utilities.IsNullOrEmtpy(fields))
                throw new ArgumentNullException();

            this.File = file;
            this.FieldParam = fieldParam;
            this.Fields = fields;
        }

        public readonly string File;
        public readonly string[] Fields;
        public readonly string FieldParam;

        public override string ToString()
        {
            string msj = string.Format("File={0};Fields={1}", File, FieldParam);
            return msj;
        }
    }
}
