USE [PERF_BMS_VISTA]

DECLARE @minSID int = 10
DECLARE @resetSID int = 10

DECLARE @maxHL int = 10 
DECLARE @maxWard int = 10 --per hosp location, 100
DECLARE @maxBed int = 20  --per ward, 2000

	
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpHL') AND type in (N'U'))
		DROP TABLE tmpHL
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpWards') AND type in (N'U'))
		DROP TABLE tmpWards
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'tmpBed') AND type in (N'U'))
		DROP TABLE tmpBed

	CREATE TABLE tmpHL(Fac_id int, Number int)
	CREATE TABLE tmpWards(Ward_id int, Number int)
	CREATE TABLE tmpBed(Bed_id int, Number int)

 -- Vocabularies

	INSERT INTO dbo.ORDER_STATUS(NAME) VALUES('test')
		
	INSERT INTO dbo.NEW_PERSON(NAME) VALUES('Vasile,Ion')	
	INSERT INTO dbo.NEW_PERSON(NAME) VALUES('George,Pana')	

	INSERT INTO [dbo].[ORDERABLE_ITEM]([NAME],[INACTIVATED],PACKAGE_NAME,DISPLAY_GROUP_ID) 
	VALUES('DISCHARGE',0, NULL, NULL)
	INSERT INTO [dbo].[ORDERABLE_ITEM]([NAME],[INACTIVATED],PACKAGE_NAME,DISPLAY_GROUP_ID) 
	VALUES('TRANSFER',0, NULL, NULL)
	INSERT INTO [dbo].[ORDERABLE_ITEM]([NAME],[INACTIVATED],PACKAGE_NAME,DISPLAY_GROUP_ID) 
	VALUES('ADMISSION',0, NULL, NULL)	
	
	--IF NOT EXISTS(SELECT 1 FROM dbo.TYPE_OF_MOVEMENT)
	INSERT INTO [dbo].[TYPE_OF_MOVEMENT] ([NAME]) VALUES('TYPE OF MOVEMENT 1')
	
	INSERT INTO dbo.FAC_TREAT_SPECIALTY(NAME)
	VALUES('TREATING SPECIALTY 1')
	
	--IF NOT EXISTS(SELECT 1 FROM dbo.SPECIALTY)
	INSERT INTO dbo.SPECIALTY(NAME) VALUES('OBSERVATION')
  
--SO       
--insert HL(10)
	WHILE @minSID < (@maxHL + @resetSID) -- 10 < 20
	BEGIN
	
		INSERT INTO [dbo].[HOSPITAL_LOCATION]([NAME],[ABBREVIATION],[TELEPHONE])
		SELECT 'HOSPITAL' + cast(@minSID as varchar),
		       'HOS' + cast(@minSID as varchar),
		       444555678
		       		
		INSERT INTO tmpHL 
		SELECT SCOPE_IDENTITY() as Fac_id, @minSID as Number
		
		SET @minSID += 1
	
	END
	
	--reset sid
	SET @minSID = @resetSID
	
--insert wards(10 per HL => 100)
	WHILE @minSID < (@maxHL * @maxWard + @resetSID) -- 10 < 110
	BEGIN
	
		INSERT INTO [dbo].[WARD_LOCATION]([NAME],[SPECIALTY_NAME],[CURRENTLY_OUT_OF_SERVICE],[HOSPITAL_LOCATION_ID],[SPECIALTY_ID]) --1-5
		SELECT 'WARD' + cast(@minSID as varchar), 'OBSERVATION', 0, F.Fac_id, 1
		FROM tmpHL F
		WHERE F.Number = ROUND((@minSID - @resetSID)/@maxWard, 0 , 1) + @resetSID 
	
		INSERT INTO tmpWards 
		SELECT SCOPE_IDENTITY() as Ward_id, @minSID as Number 
		
		SET @minSID += 1
	
	END
	
	--reset
	SET @minSID = @resetSID
	
--insert BEDS(20 per ward => 2000 beds)
declare @bed_id int
	WHILE @minSID < (@maxHL * @maxWard * @maxBed + @resetSID) -- 10 < 2010
	BEGIN
	
		INSERT INTO [dbo].[ROOM_BED] ([NAME],[CURRENTLY_OUT_OF_SERVICE])
		SELECT 'BED' + cast(@minSID as varchar), 0
		--FROM tmpWards W
		--WHERE W.Number = ROUND((@minSID - @resetSID)/@maxBed, 0 , 1) + @resetSID
		
		SELECT @bed_id = SCOPE_IDENTITY()
		
		INSERT INTO tmpBed 
		SELECT @bed_id as Bed_id, @minSID as Number  
		
		INSERT INTO dbo.RMDB_WARDS_WITH_CAN_ASSIGN(WARDS_WHICH_CAN_ASSIGN_ID, ROOM_BED_ID)
		SELECT  W.Ward_id, @bed_id
		FROM tmpWards W
		WHERE W.Number = ROUND((@minSID - @resetSID)/@maxBed, 0 , 1) + @resetSID
		
		SET @minSID += 1 
			
		--if @minSID%2000 = 0
		--	WAITFOR DELAY '00:01';
	END 

--insert Medical Center Division	
	INSERT INTO dbo.MEDICAL_CENTER_DIVISION(NAME)
	VALUES('MC_DIVISION_1')
	


GO	