USE BMS
update OPTIONS set PARAMETER_VALUE = 'N' WHERE PARAMETER = 'AUDIT'
update OPTIONS set PARAMETER_VALUE = 'N' WHERE PARAMETER = 'HISTORY'



BEGIN TRAN 

-- TEMPORARY TABLE FOR ACT IDs
DECLARE @ACT_TBL TABLE(ACT_ID int NOT NULL)

-- ADMISSION EVENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.ADMISSION_EVN
TRUNCATE TABLE dbo.ADMISSION_EVN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- ADMISSION REQUEST
TRUNCATE TABLE dbo.ADMISSION_REQ
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.ADMISSION_REQ
DELETE FROM dbo.ADMISSION_REQ
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- ADMISSION INTENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.ADMISSION_INT
TRUNCATE TABLE dbo.ADMISSION_INT
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- BED CLEAN
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.BED_CLEAN
TRUNCATE TABLE dbo.BED_CLEAN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- BED OUT OF SERVICE
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.BED_UNAVAILABLE
TRUNCATE TABLE dbo.BED_UNAVAILABLE
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- DISCHARGE EVENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.DISCHARGE_EVN
TRUNCATE TABLE dbo.DISCHARGE_EVN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- DISCHARGE REQUEST
TRUNCATE TABLE dbo.DISCHARGE_REQ
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.DISCHARGE_REQ
DELETE FROM dbo.DISCHARGE_REQ
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- DISCHARGE INTENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.DISCHARGE_INT
TRUNCATE TABLE dbo.DISCHARGE_INT
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- MOVEMENT EVENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.MOVEMENT_EVN
TRUNCATE TABLE dbo.MOVEMENT_EVN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- MOVEMENT REQUEST
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.MOVEMENT_REQ
TRUNCATE TABLE dbo.MOVEMENT_REQ
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- MOVEMENT INTENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.MOVEMENT_INT
TRUNCATE TABLE dbo.MOVEMENT_INT
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- TRANSFER EVENT
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.TRANSFER_EVN
TRUNCATE TABLE dbo.TRANSFER_EVN
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- TRANSFER REQUEST
INSERT INTO @ACT_TBL (ACT_ID) SELECT ACT_ID FROM dbo.MOVEMENT_REQ
TRUNCATE TABLE dbo.TRANSFER_REQ
DELETE FROM ACT WHERE ID IN (SELECT ACT_ID FROM @ACT_TBL)
DELETE FROM @ACT_TBL

-- ACT
DELETE FROM dbo.ACT
DBCC CHECKIDENT (ACT, reseed, 0)

-- DIVERSION
TRUNCATE TABLE dbo.DIVERSION

-- EIS
DELETE FROM dbo.EIS_PLACE
DELETE FROM dbo.EIS_PERSON
DELETE FROM dbo.EIS_ORGANIZATION
DELETE FROM dbo.EIS_ENTITY
DBCC CHECKIDENT (EIS_ENTITY, reseed, 0)
-- EVS
DELETE FROM dbo.CONCEPT
DBCC CHECKIDENT (CONCEPT, reseed, 0)

-- CONFIG
DELETE FROM dbo.CONFIG_EIS
DELETE FROM dbo.CONFIG_EVS
DELETE FROM dbo.CONFIG
DBCC CHECKIDENT (CONFIG_EIS, reseed, 0)
DBCC CHECKIDENT (CONFIG_EVS, reseed, 0)
DBCC CHECKIDENT (CONFIG, reseed, 0)



COMMIT TRAN
-- ROLLBACK TRAN
