USE [BMS_DW]
GO

/****** Object:  UserDefinedFunction [dbo].[ufn_GetPatientMovementTransferTransaction_TIME_ZONE_DT]    Script Date: 07/28/2015 14:58:40 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:		Silvica Pletea
-- Create date: 30/05/2012
-- Description:	Function for getting the patient movements data (transfer transaction)
-- 
-- Change History
-- Date		Author	Description
-- 6/23/15	AKR		Modified to use Movement Date instead of entered date for range comparison
-- =============================================
ALTER FUNCTION [dbo].[ufn_GetPatientMovementTransferTransaction_TIME_ZONE] 
(
	@FACILITY_ID INT,
	@DIVISION_ID INT, 
	@START_DATE DATETIME,
	@END_DATE DATETIME,
	@FACILITYTIMEZONE nvarchar(250)
)
RETURNS @PATIENT_MOVEMENT TABLE
(   
 	IEN INT,
	RECORD_DATE VARCHAR(30),
	ENTERED_DATE VARCHAR(30),
	DIFF VARCHAR(10),
	WARD_NAME NVARCHAR(250),
	BED_NAME NVARCHAR(250),
	PATIENT_NAME NVARCHAR(250),
	TYPE_OF_TRANSACTION NVARCHAR(50),
	TYPE_OF_MOVEMENT NVARCHAR(250),
	DIFF_MINUTE INT
)
AS
BEGIN
	
		DECLARE @WARD TABLE(ID INT PRIMARY KEY);
		
	    -- insert wards belonging to @FACILITY_ID or by	@division_id
		IF @DIVISION_ID = -1
			INSERT INTO @WARD(ID)
			SELECT WARD.ID FROM dbo.ufn_GetWardsByFacilityId(@FACILITY_ID) AS WARD
			INNER JOIN dbo.DIM_WARD AS ACTIVE_WARD ON ACTIVE_WARD.ID = WARD.ID
			WHERE ACTIVE_WARD.STATUS = 'active'
		ELSE
			INSERT INTO @WARD(ID)
			SELECT DIM_WARD_ID FROM dbo.GROUP_WARD_ORGANIZATION GWO
			WHERE DIM_ORGANIZATION_ID = @DIVISION_ID
		
		INSERT INTO @PATIENT_MOVEMENT(IEN, RECORD_DATE, ENTERED_DATE, DIFF, WARD_NAME, BED_NAME, PATIENT_NAME, TYPE_OF_TRANSACTION, TYPE_OF_MOVEMENT, DIFF_MINUTE)
			SELECT  MOVEMENT.IEN,
					CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](MOVEMENT.MOVEMENT_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion](MOVEMENT.MOVEMENT_DATE, 'UTC',@FACILITYTIMEZONE), 108),
					CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](MOVEMENT.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion](MOVEMENT.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 108),
					dbo.ufn_GetDateDiff(CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](MOVEMENT.MOVEMENT_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion](MOVEMENT.MOVEMENT_DATE, 'UTC',@FACILITYTIMEZONE), 108),
					CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](MOVEMENT.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion](MOVEMENT.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 108)),	
					WARD.NAME,
					BED.NAME,
					PATIENT.LAST_NAME + ' ' + RIGHT(PATIENT.SSN,4),
					'TRANSFER',
					MOVEMENT_TYPE.DISPLAY_NAME,
					DATEDIFF(MINUTE, [dbo].[ufn_TimezoneConversion](MOVEMENT.MOVEMENT_DATE, 'UTC',@FACILITYTIMEZONE), [dbo].[ufn_TimezoneConversion](MOVEMENT.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE)) AS DIFF_MINUTE
				FROM dbo.FACT_MOVEMENT_EVN AS MOVEMENT
				INNER JOIN @WARD AS W ON W.ID = MOVEMENT.DIM_WARD_ID
				INNER JOIN dbo.DIM_WARD AS WARD ON WARD.ID = W.ID
				LEFT JOIN dbo.DIM_BED AS BED ON BED.ID = MOVEMENT.DIM_BED_ID
				LEFT JOIN dbo.DIM_MOVEMENT_TYPE AS MOVEMENT_TYPE ON MOVEMENT_TYPE.ID = MOVEMENT.DIM_MOVEMENT_TYPE_ID
				LEFT JOIN dbo.DIM_PATIENT AS PATIENT ON PATIENT.ID = MOVEMENT.DIM_PATIENT_ID
				
/*
				WHERE (@END_DATE IS NULL AND MOVEMENT.MOVEMENT_DATE >= @START_DATE AND MOVEMENT.ENTERED_DATE >=@START_DATE) OR 
					   (MOVEMENT.MOVEMENT_DATE BETWEEN @START_DATE AND  @END_DATE AND MOVEMENT.ENTERED_DATE BETWEEN @START_DATE AND  @END_DATE)
*/
				WHERE (@END_DATE IS NULL AND MOVEMENT.MOVEMENT_DATE >= @START_DATE ) OR 
					   (MOVEMENT.MOVEMENT_DATE BETWEEN @START_DATE AND  @END_DATE )
	RETURN 
END





GO


