CREATE TABLE [dbo].[DISPLAY_GROUP]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[MIXED_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SHORT_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[DISPLAY_GROUP_tgg_delete]
   ON  dbo.DISPLAY_GROUP
   AFTER delete
AS 
BEGIN	
	INSERT INTO [dbo].[DISPLAY_GROUP_LOG]
           ([ACTION]
           ,[IEN]
           ,[NAME]
           ,[MIXED_NAME]
           ,[SHORT_NAME])
        SELECT 'D'
		   ,[IEN]
           ,[NAME]
           ,[MIXED_NAME]
           ,[SHORT_NAME]
          FROM deleted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[DISPLAY_GROUP_tgg_insert]
   ON  dbo.DISPLAY_GROUP
   AFTER insert
AS 
BEGIN	
	INSERT INTO [dbo].[DISPLAY_GROUP_LOG]
           ([ACTION]
           ,[IEN]
           ,[NAME]
           ,[MIXED_NAME]
           ,[SHORT_NAME])
        SELECT 'I'
		   ,[IEN]
           ,[NAME]
           ,[MIXED_NAME]
           ,[SHORT_NAME]
          FROM inserted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[DISPLAY_GROUP_tgg_update]
   ON  dbo.DISPLAY_GROUP
   AFTER update
AS 
BEGIN	
	INSERT INTO [dbo].[DISPLAY_GROUP_LOG]
           ([ACTION]
           ,[IEN]
           ,[NAME]
           ,[MIXED_NAME]
           ,[SHORT_NAME])
        SELECT 'U'
		   ,[IEN]
           ,[NAME]
           ,[MIXED_NAME]
           ,[SHORT_NAME]
          FROM inserted;
END
GO
ALTER TABLE [dbo].[DISPLAY_GROUP] ADD CONSTRAINT [PK_DISPLAY_GROUP] PRIMARY KEY CLUSTERED  ([IEN]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'The display group table.', 'SCHEMA', N'dbo', 'TABLE', N'DISPLAY_GROUP', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the table. ', 'SCHEMA', N'dbo', 'TABLE', N'DISPLAY_GROUP', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The mixed name of the display group.', 'SCHEMA', N'dbo', 'TABLE', N'DISPLAY_GROUP', 'COLUMN', N'MIXED_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the display group.', 'SCHEMA', N'dbo', 'TABLE', N'DISPLAY_GROUP', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The short name of the group.', 'SCHEMA', N'dbo', 'TABLE', N'DISPLAY_GROUP', 'COLUMN', N'SHORT_NAME'
GO
