CREATE TABLE [System.Activities.DurableInstancing].[InstancesTable]
(
[Id] [uniqueidentifier] NOT NULL,
[SurrogateInstanceId] [bigint] NOT NULL IDENTITY(1, 1),
[SurrogateLockOwnerId] [bigint] NULL,
[PrimitiveDataProperties] [varbinary] (max) NULL CONSTRAINT [DF__Instances__Primi__060DEAE8] DEFAULT (NULL),
[ComplexDataProperties] [varbinary] (max) NULL CONSTRAINT [DF__Instances__Compl__07020F21] DEFAULT (NULL),
[WriteOnlyPrimitiveDataProperties] [varbinary] (max) NULL CONSTRAINT [DF__Instances__Write__07F6335A] DEFAULT (NULL),
[WriteOnlyComplexDataProperties] [varbinary] (max) NULL CONSTRAINT [DF__Instances__Write__08EA5793] DEFAULT (NULL),
[MetadataProperties] [varbinary] (max) NULL CONSTRAINT [DF__Instances__Metad__09DE7BCC] DEFAULT (NULL),
[DataEncodingOption] [tinyint] NULL CONSTRAINT [DF__Instances__DataE__0AD2A005] DEFAULT ((0)),
[MetadataEncodingOption] [tinyint] NULL CONSTRAINT [DF__Instances__Metad__0BC6C43E] DEFAULT ((0)),
[Version] [bigint] NOT NULL,
[PendingTimer] [datetime] NULL,
[CreationTime] [datetime] NOT NULL,
[LastUpdated] [datetime] NULL CONSTRAINT [DF__Instances__LastU__0CBAE877] DEFAULT (NULL),
[WorkflowHostType] [uniqueidentifier] NULL,
[ServiceDeploymentId] [bigint] NULL,
[SuspensionExceptionName] [nvarchar] (450) COLLATE SQL_Latin1_General_CP1_CI_AS NULL CONSTRAINT [DF__Instances__Suspe__0DAF0CB0] DEFAULT (NULL),
[SuspensionReason] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL CONSTRAINT [DF__Instances__Suspe__0EA330E9] DEFAULT (NULL),
[BlockingBookmarks] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL CONSTRAINT [DF__Instances__Block__0F975522] DEFAULT (NULL),
[LastMachineRunOn] [nvarchar] (450) COLLATE SQL_Latin1_General_CP1_CI_AS NULL CONSTRAINT [DF__Instances__LastM__108B795B] DEFAULT (NULL),
[ExecutionStatus] [nvarchar] (450) COLLATE SQL_Latin1_General_CP1_CI_AS NULL CONSTRAINT [DF__Instances__Execu__117F9D94] DEFAULT (NULL),
[IsInitialized] [bit] NULL CONSTRAINT [DF__Instances__IsIni__1273C1CD] DEFAULT ((0)),
[IsSuspended] [bit] NULL CONSTRAINT [DF__Instances__IsSus__1367E606] DEFAULT ((0)),
[IsReadyToRun] [bit] NULL CONSTRAINT [DF__Instances__IsRea__145C0A3F] DEFAULT ((0)),
[IsCompleted] [bit] NULL CONSTRAINT [DF__Instances__IsCom__15502E78] DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_InstancesTable_CreationTime] ON [System.Activities.DurableInstancing].[InstancesTable] ([CreationTime]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [NCIX_InstancesTable_Id] ON [System.Activities.DurableInstancing].[InstancesTable] ([Id]) INCLUDE ([IsCompleted], [SurrogateLockOwnerId], [Version]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_InstancesTable_LastUpdated] ON [System.Activities.DurableInstancing].[InstancesTable] ([LastUpdated]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_InstancesTable_ServiceDeploymentId] ON [System.Activities.DurableInstancing].[InstancesTable] ([ServiceDeploymentId]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE UNIQUE CLUSTERED INDEX [CIX_InstancesTable] ON [System.Activities.DurableInstancing].[InstancesTable] ([SurrogateInstanceId]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_InstancesTable_SurrogateLockOwnerId] ON [System.Activities.DurableInstancing].[InstancesTable] ([SurrogateLockOwnerId]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_InstancesTable_SuspensionExceptionName] ON [System.Activities.DurableInstancing].[InstancesTable] ([SuspensionExceptionName]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [NCIX_InstancesTable_WorkflowHostType] ON [System.Activities.DurableInstancing].[InstancesTable] ([WorkflowHostType]) WITH (ALLOW_PAGE_LOCKS=OFF) ON [PRIMARY]
GO
