CREATE TABLE [dbo].[TRANSFER_REQ_H](
	[PK] [int] IDENTITY(1,1) NOT NULL,
	[ACT_ID] [int] NOT NULL,
	[ERA_ID] [int] NOT NULL,
	[FACILITY_UID] [uniqueidentifier] NOT NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NULL,
	[DIAGNOSIS] [nvarchar](250) NULL,
	[CURRENT_LOCATION] [nvarchar](150) NULL,
	[COMMENTS] [nvarchar](250) NULL,
	[CONTRACT_ID] [int] NOT NULL,
	[SPECIALITY_ID] [int] NOT NULL,
	[FACILITY_REGION] [nvarchar](100) NULL,
	[FACILITY_VISN] [nvarchar](100) NULL,
	[LOCATION_ADMISSION_DATE] [datetime] NULL,
	[REQUESTED_DATE] [datetime] NULL,
	[ENTERED_BY] [nvarchar](100) NULL,
	[LAST_EDIT_BY] [nvarchar](100) NULL,
	[EDITED] [datetime] NULL,
	[TRANSACTION_TYPE_CODE] [varchar](50) NOT NULL,
	[DATE] [datetime] NOT NULL,
	[CREATED_BY] [nvarchar](50) NULL,
	[IS_NATIONAL_WAIT_LIST] [bit] NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[TRANSFER_REQ_H] ADD CONSTRAINT [PK_TRANSFER_REQ_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'PK'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ID of the transfer request act and reference key to the ACT table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'ACT_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to war era concept.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'ERA_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to the facility where the patient resides.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient''s diagnosis.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'DIAGNOSIS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Destination of the transfer.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'CURRENT_LOCATION'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Transfer request comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to the contract concept associated with the patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'CONTRACT_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to the Specialty concept.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'SPECIALITY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The region code for the facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'FACILITY_REGION'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'VISN code for the facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'FACILITY_VISN'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Admission date in the current location.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'LOCATION_ADMISSION_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Code of transaction(I = Inserted, U = Updated, D = Deleted).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'TRANSACTION_TYPE_CODE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Datetime when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of user when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'CREATED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'IS NATIONAL WAITING LIST.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H', @level2type=N'COLUMN',@level2name=N'IS_NATIONAL_WAIT_LIST'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Transfer request table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ_H'
GO


