CREATE TABLE [dbo].[CONFIG_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[USER_NAME] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[SECTION] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CONFIG_KEY] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CONFIG_VALUE] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CONFIG_TYPE] [nvarchar] (10) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VALUE_TYPE] [varchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[FRIENDLY_NAME] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE [dbo].[CONFIG_H] ADD CONSTRAINT [PK_CONFIG_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Configuration table.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Configuration key column.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'CONFIG_KEY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Type of the configuration.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'CONFIG_TYPE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The value associated to the configuration key.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'CONFIG_VALUE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Domain''s id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A friendly name for the configuration.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'FRIENDLY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Configuration''s id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Section name.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'SECTION'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User name.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'USER_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The value type.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_H', 'COLUMN', N'VALUE_TYPE'
GO
