CREATE TABLE [dbo].[ACTION_ALL_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [uniqueidentifier] NOT NULL,
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PARENT] [uniqueidentifier] NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ACTION_ALL_H] ADD CONSTRAINT [PK_ACTION_ALL_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that associates an action with its parent action.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Transaction table''s identifier.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the action.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL_H', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the parent action.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL_H', 'COLUMN', N'PARENT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'ACTION_ALL_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
