
CREATE TABLE [dbo].[FACT_SCHEDULED_ADMISSION](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[DIM_PATIENT_ID] [int] NULL,
	[IEN] [varchar](50) NULL,
	[DIM_DOMAIN_ID] [int] NOT NULL,
	[CANCELED_DATE] [datetime] NULL,
	[RESERVATION_DATE] [datetime] NULL,
	[SCHEDULER_DIM_PHYSICIAN_ID] [int] NULL,
	[PROVIDER_DIM_PHYSICIAN_ID] [int] NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [int] NULL,
	[DIM_WARD_ID] [int] NULL,
	[DIM_TREATING_SPECIALTY_ID] [int] NULL,
	[DIAGNOSIS] [nvarchar](max) NULL,
	[SURGERY] [bit] NULL,
	[LENGTH_OF_STAY_EXPECTED] [int] NULL,
	[DIM_MEDICAL_DIVISION_VISTA_DIVISION_ID] [int] NULL,
	[SOURCE_ID] INT NOT NULL,
	[_ssis_timestamp] [datetime] NULL,
 CONSTRAINT [PK_FACT_SCHEDULED_ADMISSION] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_MEDICAL_DIVISION] FOREIGN KEY([DIM_MEDICAL_DIVISION_VISTA_DIVISION_ID])
REFERENCES [dbo].[DIM_MEDICAL_DIVISION] ([ID])
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_MEDICAL_DIVISION]
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_ORGANIZATION] FOREIGN KEY([VISTA_SITE_DIM_ORGANIZATION_ID])
REFERENCES [dbo].[DIM_ORGANIZATION] ([ID])
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_ORGANIZATION]
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_PATIENT] FOREIGN KEY([DIM_PATIENT_ID])
REFERENCES [dbo].[DIM_PATIENT] ([ID])
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_PATIENT]
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_PHYSICIAN] FOREIGN KEY([PROVIDER_DIM_PHYSICIAN_ID])
REFERENCES [dbo].[DIM_PHYSICIAN] ([ID])
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_PHYSICIAN]
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_PHYSICIAN1] FOREIGN KEY([SCHEDULER_DIM_PHYSICIAN_ID])
REFERENCES [dbo].[DIM_PHYSICIAN] ([ID])
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_PHYSICIAN1]
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_TREATING_SPECIALTY] FOREIGN KEY([DIM_TREATING_SPECIALTY_ID])
REFERENCES [dbo].[DIM_TREATING_SPECIALTY] ([ID])
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_TREATING_SPECIALTY]
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_WARD] FOREIGN KEY([DIM_WARD_ID])
REFERENCES [dbo].[DIM_WARD] ([ID])
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_DIM_WARD]
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_FACT_SCHEDULED_ADMISSION] FOREIGN KEY([DIM_DOMAIN_ID])
REFERENCES [dbo].[DIM_DOMAIN] ([ID])
GO

ALTER TABLE [dbo].[FACT_SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_FACT_SCHEDULED_ADMISSION_FACT_SCHEDULED_ADMISSION]
GO

CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON FACT_SCHEDULED_ADMISSION(SOURCE_ID ASC)
GO
