
CREATE TABLE [dbo].[DIM_ICON_FLAG_FACILITY](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[DIM_ICON_FLAG_ID] [int] NOT NULL,
	[DIM_ORGANIZATION_FACILITY_ID] [int] NOT NULL,
	[ORDER_INDEX] [int] NOT NULL,
	[ACTIVE] [bit] NOT NULL,
	[PATIENT_OR_ROOMBED] [char](1) NOT NULL,
	[ICON_NAME] [nvarchar](150) NULL,
	[DESCRIPTION] [nvarchar](max) NULL,
	[COMMENT] [nvarchar](150) NULL,
	[MOUSE_OVER_TEXT] [nvarchar](150) NULL,
	[ENTERED_BY] [nvarchar](50) NULL,
	[ENTERED_DATE] [datetime] NULL,
	[LAST_EDIT_BY] [nvarchar](50) NULL,
	[LAST_EDIT_DATE] [datetime] NULL,
	[SOURCE_ID] [nvarchar](250) NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
 CONSTRAINT [PK_DIM_ICON_FLAG_FACILITY] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[DIM_ICON_FLAG_FACILITY]  WITH NOCHECK ADD  CONSTRAINT [FK_DIM_ICON_FLAG_FACILITY_DIM_ICON_FLAG] FOREIGN KEY([DIM_ICON_FLAG_ID])
REFERENCES [dbo].[DIM_ICON_FLAG] ([ID])
GO

ALTER TABLE [dbo].[DIM_ICON_FLAG_FACILITY] CHECK CONSTRAINT [FK_DIM_ICON_FLAG_FACILITY_DIM_ICON_FLAG]
GO

ALTER TABLE [dbo].[DIM_ICON_FLAG_FACILITY]  WITH NOCHECK ADD  CONSTRAINT [FK_DIM_ICON_FLAG_FACILITY_DIM_ORGANIZATION] FOREIGN KEY([DIM_ORGANIZATION_FACILITY_ID])
REFERENCES [dbo].[DIM_ORGANIZATION] ([ID])
GO

ALTER TABLE [dbo].[DIM_ICON_FLAG_FACILITY] CHECK CONSTRAINT [FK_DIM_ICON_FLAG_FACILITY_DIM_ORGANIZATION]
GO

ALTER TABLE [dbo].[DIM_ICON_FLAG_FACILITY] ADD  CONSTRAINT [DF_DIM_ICON_FLAG_FACILITY_ENTERED_DATE]  DEFAULT (getutcdate()) FOR [ENTERED_DATE]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the icon from the icon definitions table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'DIM_ICON_FLAG_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'DIM_ORGANIZATION_FACILITY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Order of the icons on the screen per subgroup.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ORDER_INDEX'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'True/False flag for an active/inactive icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ACTIVE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'PATIENT_OR_ROOMBED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The icon name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ICON_NAME'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The description of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'DESCRIPTION'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A free text comment appropriate for the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'COMMENT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A free text to show on the top of the icon (hover text).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'MOUSE_OVER_TEXT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who inserted the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ENTERED_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The icon inserted datetime.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'ENTERED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who last edited the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the icon was last edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the record from the BMS database, source table ICON_FLAG_FACILITY.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'SOURCE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY', @level2type=N'COLUMN',@level2name=N'_SSIS_TIMESTAMP'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores icon attributes specific to a facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY'
GO

CREATE NONCLUSTERED INDEX [idx_DIM_ICON_FLAG_ID] ON DIM_ICON_FLAG_FACILITY(DIM_ICON_FLAG_ID ASC)
GO
CREATE NONCLUSTERED INDEX [idx_ICON_NAME] ON DIM_ICON_FLAG_FACILITY(ICON_NAME ASC)
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON DIM_ICON_FLAG_FACILITY(SOURCE_ID ASC)
GO