CREATE TABLE [dbo].[FACT_MOVEMENT_EVN_ETL](
	[DOMAIN_ID] [nvarchar](50) NOT NULL,
	[IEN] [varchar](50) NULL,
	[PATIENT_UID] [nvarchar](250) NULL,
	[ENTERED_DATE] [datetime] NOT NULL,
	[WARD_UID] [nvarchar](250) NULL,
	[BED_UID] [nvarchar](250) NULL,
	[OLD_WARD_UID] [nvarchar](250) NULL,
	[OLD_BED_UID] [nvarchar](250) NULL,
	[VISTA_SITE_UID] [nvarchar](250) NULL,
	[TYPE_OF_MOVEMENT_CODE] [varchar](100) NULL,
	[MOVEMENT_DATE] [datetime] NULL,
	[ENTERED_BY_UID] [nvarchar](250) NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[SOURCE_ID] [int] NOT NULL,
	[CREATION_UTC_DATE] [datetime] NOT NULL,
	[ADM_SOURCE_ID] [int] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains temporary movement information from bms database(Movement_req). Used by reports full job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_MOVEMENT_EVN_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_ADM_SOURCE_ID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[ADM_SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_BED_UID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[BED_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_MOVEMENT_TYPE_CODE] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[TYPE_OF_MOVEMENT_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DOMAIN_ID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_ENTERED_BY_UID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[ENTERED_BY_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_OLD_BED_UID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[OLD_BED_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_OLD_WARD_UID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[OLD_WARD_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_PATIENT_UID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[PATIENT_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_UID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[VISTA_SITE_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_WARD_UID] ON [dbo].[FACT_MOVEMENT_EVN_ETL] 
(
	[WARD_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO