CREATE TABLE [dbo].[FACT_ADMISSION_EVN_ETL](
	[DIM_DOMAIN_ID] [nvarchar](50) NOT NULL,
	[IEN] [varchar](50) NULL,
	[DIM_PATIENT_ID] [uniqueidentifier] NOT NULL,
	[ENTERED_DATE] [datetime] NOT NULL,
	[DIM_BED_ID] [nvarchar](250) NULL,
	[DIM_WARD_ID] [nvarchar](250) NULL,
	[INITIAL_DIM_BED_ID] [nvarchar](250) NULL,
	[INITIAL_DIM_WARD_ID] [nvarchar](250) NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[ATND_DIM_NURSE_ID] [nvarchar](250) NULL,
	[ADMISSION_DATE] [datetime] NULL,
	[DIM_MOVEMENT_TYPE_ID] [varchar](100) NULL,
	[HAS_DISCHARGE] [bit] NOT NULL,
	[ENTERED_BY_DIM_PHYSICIAN_ID] [nvarchar](250) NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Update admission table used by reports incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_ADMISSION_EVN_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_ATND_DIM_NURSE_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[ATND_DIM_NURSE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_BED_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[DIM_BED_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_DOMAIN_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[DIM_DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_MOVEMENT_TYPE_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[DIM_MOVEMENT_TYPE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_PATIENT_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[DIM_PATIENT_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_WARD_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[DIM_WARD_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_ENTERED_BY_DIM_PHYSICIAN_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[ENTERED_BY_DIM_PHYSICIAN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_INITIAL_DIM_BED_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[INITIAL_DIM_BED_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_INITIAL_DIM_WARD_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[INITIAL_DIM_WARD_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_DIM_ORGANIZATION_ID] ON [dbo].[FACT_ADMISSION_EVN_ETL] 
(
	[VISTA_SITE_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO



