
CREATE TABLE [dbo].[GROUP_BED_WARD_STATUS](
	[DIM_GROUP_BED_WARD_ID] [int] NOT NULL,
	[DIM_BED_STATUS_ID] [nvarchar](50) NOT NULL,
	[BED_STATUS_DATE] [datetime] NULL,
 CONSTRAINT [PK_GROUP_BED_WARD_STATUS] PRIMARY KEY CLUSTERED 
(
	[DIM_GROUP_BED_WARD_ID] ASC,
	[DIM_BED_STATUS_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[GROUP_BED_WARD_STATUS]  WITH CHECK ADD  CONSTRAINT [FK_GROUP_BED_WARD_STATUS_GROUP_BED_WARD] FOREIGN KEY([DIM_GROUP_BED_WARD_ID])
REFERENCES [dbo].GROUP_BED_WARD ([ID])
GO

ALTER TABLE [dbo].[GROUP_BED_WARD_STATUS] CHECK CONSTRAINT [FK_GROUP_BED_WARD_STATUS_GROUP_BED_WARD]
GO

ALTER TABLE [dbo].[GROUP_BED_WARD_STATUS]  WITH CHECK ADD  CONSTRAINT [FK_GROUP_BED_WARD_STATUS_DIM_BED_STATUS] FOREIGN KEY([DIM_BED_STATUS_ID])
REFERENCES [dbo].[DIM_BED_STATUS] ([ID])
GO

ALTER TABLE [dbo].[GROUP_BED_WARD_STATUS] CHECK CONSTRAINT [FK_GROUP_BED_WARD_STATUS_DIM_BED_STATUS]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the group bed ward from the current database.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_WARD_STATUS', @level2type=N'COLUMN',@level2name=N'DIM_GROUP_BED_WARD_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the bed status.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_WARD_STATUS', @level2type=N'COLUMN',@level2name=N'DIM_BED_STATUS_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date when the bed received the status.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_WARD_STATUS', @level2type=N'COLUMN',@level2name=N'BED_STATUS_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that contains bed statuses.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_WARD_STATUS'
GO