
CREATE TABLE [dbo].[GROUP_BED_STATUS](
	[DIM_BED_ID] [int] NOT NULL,
	[DIM_BED_STATUS_ID] [nvarchar](50) NOT NULL,
	[BED_STATUS_DATE] [datetime] NULL,
 CONSTRAINT [PK_GROUP_BED_STATUS] PRIMARY KEY CLUSTERED 
(
	[DIM_BED_ID] ASC,
	[DIM_BED_STATUS_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[GROUP_BED_STATUS]  WITH CHECK ADD  CONSTRAINT [FK_GROUP_BED_STATUS_DIM_BED] FOREIGN KEY([DIM_BED_ID])
REFERENCES [dbo].[DIM_BED] ([ID])
GO

ALTER TABLE [dbo].[GROUP_BED_STATUS] CHECK CONSTRAINT [FK_GROUP_BED_STATUS_DIM_BED]
GO

ALTER TABLE [dbo].[GROUP_BED_STATUS]  WITH CHECK ADD  CONSTRAINT [FK_GROUP_BED_STATUS_DIM_BED_STATUS] FOREIGN KEY([DIM_BED_STATUS_ID])
REFERENCES [dbo].[DIM_BED_STATUS] ([ID])
GO

ALTER TABLE [dbo].[GROUP_BED_STATUS] CHECK CONSTRAINT [FK_GROUP_BED_STATUS_DIM_BED_STATUS]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the bed from the current database.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_STATUS', @level2type=N'COLUMN',@level2name=N'DIM_BED_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the bed status.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_STATUS', @level2type=N'COLUMN',@level2name=N'DIM_BED_STATUS_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date when the bed received the status.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_STATUS', @level2type=N'COLUMN',@level2name=N'BED_STATUS_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that contains bed statuses.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_STATUS'
GO