CREATE TABLE [dbo].[DIM_DOMAIN_ETL](
	[NAME] [nvarchar](100) NOT NULL,
	[IDENTIFIER] [nvarchar](50) NOT NULL,
	[STATUS_CODE] [nvarchar](100) NULL,
	[STATUS_CODE_SYSTEM] [nvarchar](250) NULL,
	[STATUS_CODE_SYSTEM_NAME] [nvarchar](250) NULL,
	[STATUS_DISPLAY_NAME] [nvarchar](250) NULL,
	[SOURCE_ID] [nvarchar](50) NULL,
	[SOURCE_PK] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL
) ON [PRIMARY]

GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Update domain dimension table useb by reports incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_DOMAIN_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_PK] ON [dbo].[DIM_DOMAIN_ETL] 
(
	[SOURCE_PK] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[DIM_DOMAIN_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO



