CREATE TABLE [dbo].[EMS_STAFF]
(
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[USER_NAME] [nvarchar](250) NOT NULL,
	[PIN] [nvarchar](20) NOT NULL,
	[FACILITY_UID] [uniqueidentifier] NOT NULL,
	[CREATEDBY] [nvarchar](50) NULL,
	[CREATED] [datetime] NULL,
	[UPDATEDBY] [nvarchar](50) NULL,
	[UPDATED] [datetime] NULL
)
GO

CREATE TRIGGER [dbo].[utg_EMS_STAFF_AfterDelete] 
   ON  [dbo].[EMS_STAFF] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[EMS_STAFF_H]
			   (ID, [USER_NAME], PIN, FACILITY_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, [USER_NAME], PIN, FACILITY_UID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()				
		FROM deleted;

END
GO

CREATE TRIGGER [dbo].[utg_EMS_STAFF_AfterInsert] 
   ON  [dbo].[EMS_STAFF] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[EMS_STAFF_H]
			   (ID, [USER_NAME], PIN, FACILITY_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, [USER_NAME], PIN, FACILITY_UID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted; 
END
GO

CREATE TRIGGER [dbo].[utg_EMS_STAFF_AfterUpdate] 
   ON  [dbo].[EMS_STAFF] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[EMS_STAFF_H]
			   (ID, [USER_NAME], PIN, FACILITY_UID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	ID, [USER_NAME], PIN, FACILITY_UID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;	


END
GO

CREATE TRIGGER [dbo].[utg_EMS_STAFF_InsteadOfInsert] 
   ON  [dbo].[EMS_STAFF]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[EMS_STAFF]
			([USER_NAME], PIN, FACILITY_UID, CREATED, CREATEDBY)
		SELECT	[USER_NAME], PIN, FACILITY_UID, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;

	ELSE
		INSERT INTO [dbo].[EMS_STAFF]
			([USER_NAME], PIN, FACILITY_UID)
		SELECT	[USER_NAME], PIN, FACILITY_UID
		FROM inserted;

END
GO

CREATE TRIGGER [dbo].[utg_EMS_STAFF_InsteadOfUpdate] 
   ON  [dbo].[EMS_STAFF] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[EMS_STAFF]
		SET [USER_NAME] = inserted.[USER_NAME], 
			PIN = inserted.PIN, 
			FACILITY_UID = inserted.FACILITY_UID,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[EMS_STAFF]
			INNER JOIN inserted ON inserted.ID = [dbo].[EMS_STAFF].ID;
	 ELSE
	    UPDATE [dbo].[EMS_STAFF]
		SET [USER_NAME] = inserted.[USER_NAME], 
			PIN = inserted.PIN, 
			FACILITY_UID = inserted.FACILITY_UID
		FROM [dbo].[EMS_STAFF]
			INNER JOIN inserted ON inserted.ID = [dbo].[EMS_STAFF].ID;

END
GO

--Constraints
ALTER TABLE [dbo].[EMS_STAFF]  ADD CONSTRAINT [PK_EMS_STAFF] PRIMARY KEY CLUSTERED  ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_FACILITY_UID] ON [dbo].[EMS_STAFF] 
(
	[FACILITY_UID] ASC
)
INCLUDE ( [ID],
[USER_NAME],
[PIN]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user name of the EMS Mobile.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF', @level2type=N'COLUMN',@level2name=N'USER_NAME'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The pin of the EMS Mobile user.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF', @level2type=N'COLUMN',@level2name=N'PIN'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF', @level2type=N'COLUMN',@level2name=N'CREATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user when the record was updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores user names and pins per facility in order to access EMS Mobile module.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EMS_STAFF'
GO