CREATE TABLE [dbo].[USER_ROLE]
(
[USER_ID] [varchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ROLE_ID] [uniqueidentifier] NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_User_Role_AfterDelete] 
   ON  [dbo].[USER_ROLE] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[User_Role_H]
			   (USER_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT USER_ID, ROLE_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
			
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_User_Role_AfterInsert] 
   ON  [dbo].[USER_ROLE] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[User_Role_H]
			   (USER_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT USER_ID, ROLE_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
     
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_User_Role_AfterUpdate] 
   ON  [dbo].[USER_ROLE] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
	    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[User_Role_H]
			   (USER_ID, ROLE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT USER_ID, ROLE_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_User_Role_InsteadOfInsert] 
   ON  [dbo].[USER_ROLE]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     INSERT INTO [dbo].[User_Role]
			   (USER_ID, ROLE_ID, CREATED, CREATEDBY)
			SELECT USER_ID, ROLE_ID, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	 
	ELSE
		INSERT INTO [dbo].[User_Role]
			   (USER_ID, ROLE_ID)
			SELECT USER_ID, ROLE_ID
			  FROM inserted;
	
END
GO
ALTER TABLE [dbo].[USER_ROLE] ADD CONSTRAINT [PK_USER_ROLE] PRIMARY KEY CLUSTERED  ([ROLE_ID], [USER_ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[USER_ROLE] WITH NOCHECK ADD CONSTRAINT [FK_USER_ROLE_ROLE] FOREIGN KEY ([ROLE_ID]) REFERENCES [dbo].[ROLE] ([ID]) NOT FOR REPLICATION
GO
ALTER TABLE [dbo].[USER_ROLE] NOCHECK CONSTRAINT [FK_USER_ROLE_ROLE]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that associates user and their roles.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the role that is given to the user.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE', 'COLUMN', N'ROLE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the user.', 'SCHEMA', N'dbo', 'TABLE', N'USER_ROLE', 'COLUMN', N'USER_ID'
GO
