CREATE TABLE [dbo].[PERMISSION]
(
[ID] [uniqueidentifier] NOT NULL,
[RESOURCE_ID] [uniqueidentifier] NOT NULL,
[ACTION_ID] [uniqueidentifier] NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Permission_AfterDelete] 
   ON  [dbo].[PERMISSION] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Permission_H]
			   (ID, RESOURCE_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, RESOURCE_ID, ACTION_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Permission_AfterInsert] 
   ON  [dbo].[PERMISSION] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Permission_H]
			   (ID, RESOURCE_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, RESOURCE_ID, ACTION_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
   
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Permission_AfterUpdate] 
   ON  [dbo].[PERMISSION] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[Permission_H]
			   (ID, RESOURCE_ID, ACTION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, RESOURCE_ID, ACTION_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Permission_InsteadOfInsert] 
   ON  [dbo].[PERMISSION]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Permission]
			   (ID, RESOURCE_ID, ACTION_ID, CREATED, CREATEDBY)
			SELECT ID, RESOURCE_ID, ACTION_ID, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	    
	  
	ELSE
		INSERT INTO [dbo].[Permission]
			   (ID, RESOURCE_ID, ACTION_ID)
			SELECT ID, RESOURCE_ID, ACTION_ID
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Permission_InsteadOfUpdate] 
   ON  [dbo].[PERMISSION] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Permission]
		SET RESOURCE_ID = inserted.RESOURCE_ID,
			ACTION_ID = inserted.ACTION_ID,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Permission]
		INNER JOIN inserted ON inserted.id = [dbo].[Permission].id;
	 
	 ELSE
	    UPDATE [dbo].[Permission]
		SET RESOURCE_ID = inserted.RESOURCE_ID,
			ACTION_ID = inserted.ACTION_ID
		FROM [dbo].[Permission]
		INNER JOIN inserted ON inserted.id = [dbo].[Permission].id;

END
GO

--Constraints
ALTER TABLE [dbo].[PERMISSION] ADD CONSTRAINT [PK_PERMISSION] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[PERMISSION] WITH NOCHECK ADD CONSTRAINT [FK_PERMISSION_ACTION] FOREIGN KEY ([ACTION_ID]) REFERENCES [dbo].[ACTION] ([ID]) NOT FOR REPLICATION
GO
ALTER TABLE [dbo].[PERMISSION] WITH NOCHECK ADD CONSTRAINT [FK_PERMISSION_RESOURCE] FOREIGN KEY ([RESOURCE_ID]) REFERENCES [dbo].[RESOURCE] ([ID]) NOT FOR REPLICATION
GO
ALTER TABLE [dbo].[PERMISSION] NOCHECK CONSTRAINT [FK_PERMISSION_ACTION]
GO
ALTER TABLE [dbo].[PERMISSION] NOCHECK CONSTRAINT [FK_PERMISSION_RESOURCE]
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_RESOURCE_ACTION] ON [dbo].[PERMISSION] 
(
	[RESOURCE_ID] ASC,
	[ACTION_ID] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Table that associates resources with actions that can be performed upon them.', 'SCHEMA', N'dbo', 'TABLE', N'PERMISSION', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The action or operation that is permitted upon the resource.', 'SCHEMA', N'dbo', 'TABLE', N'PERMISSION', 'COLUMN', N'ACTION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'PERMISSION', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'PERMISSION', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the permission.', 'SCHEMA', N'dbo', 'TABLE', N'PERMISSION', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the resource.', 'SCHEMA', N'dbo', 'TABLE', N'PERMISSION', 'COLUMN', N'RESOURCE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'PERMISSION', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'PERMISSION', 'COLUMN', N'UPDATEDBY'
GO
