CREATE TABLE [dbo].[ACTION]
(
[ID] [uniqueidentifier] NOT NULL,
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IS_GROUP] [bit] NOT NULL,
[CREATED] [datetime] NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATEDBY] [datetime] NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_AfterDelete] 
   ON  [dbo].[ACTION] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
      INSERT INTO $(varBMS_HISTORY).[dbo].[Action_H]
			   (ID, NAME, IS_GROUP, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, IS_GROUP, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_AfterInsert] 
   ON  [dbo].[ACTION] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
      INSERT INTO $(varBMS_HISTORY).[dbo].[ACTION_H]
			   (ID, NAME, IS_GROUP, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, IS_GROUP, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Action_AfterUpdate] 
   ON  [dbo].[ACTION] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';    

	IF (UPPER(@HISTORY_VALUE) = 'Y')
      INSERT INTO $(varBMS_HISTORY).[dbo].[Action_H]
			   (ID, NAME, IS_GROUP, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, NAME, IS_GROUP, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	 
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Action_InsteadOfInsert] 
   ON  [dbo].[ACTION]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
      INSERT INTO [dbo].[Action]
			   (ID, NAME, IS_GROUP, CREATED, CREATEDBY)
			SELECT ID, NAME, IS_GROUP, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	
	ELSE
		INSERT INTO [dbo].[Action]
			   (ID, NAME, IS_GROUP)
			SELECT ID, NAME, IS_GROUP
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Action_InsteadOfUpdate] 
   ON  [dbo].[ACTION] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[Action]
		SET NAME = inserted.NAME,
			IS_GROUP = inserted.IS_GROUP,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Action]
		INNER JOIN inserted ON inserted.id = [dbo].[Action].id; 
	 ELSE
	    UPDATE [dbo].[Action]
		SET NAME = inserted.NAME,
			IS_GROUP = inserted.IS_GROUP
		FROM [dbo].[Action]
		INNER JOIN inserted ON inserted.id = [dbo].[Action].id;

END
GO
ALTER TABLE [dbo].[ACTION] ADD CONSTRAINT [PK_ACTION] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains operations that users can perform upon resources.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Action''s identifier.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Illustrates if the current action is a group of operations.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION', 'COLUMN', N'IS_GROUP'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Action''s name.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'ACTION', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'ACTION', 'COLUMN', N'UPDATEDBY'
GO
