CREATE TABLE [dbo].[TRANSFER_EVN]
(
[ACT_ID] [int] NOT NULL,
[DISPOSITION_ID] [int] NOT NULL,
[ADMISSION_FACILITY_UID] [uniqueidentifier] NULL,
[DISPOSITION_DATE] [datetime] NULL,
[COMMENT] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__TRANSFER____ssis__6E414E4F] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]

GO

create trigger [dbo].[TRANSFER_EVN_tgg_ssis_delete] on dbo.TRANSFER_EVN after delete as begin  delete [dbo].[TRANSFER_EVN_ssisdel] from [deleted] _xyz where [dbo].[TRANSFER_EVN_ssisdel].[ACT_ID]=[_xyz].[ACT_ID];  insert into [dbo].[TRANSFER_EVN_ssisdel]([ACT_ID], _ssis_timestamp)  select [ACT_ID], current_timestamp from [deleted];  end
GO

create trigger [dbo].[TRANSFER_EVN_tgg_ssis_insert] on dbo.TRANSFER_EVN after insert as begin delete [dbo].[TRANSFER_EVN_ssisdel]  from [inserted] _xyz where [dbo].[TRANSFER_EVN_ssisdel].[ACT_ID]=[_xyz].[ACT_ID] end
GO

SET QUOTED_IDENTIFIER OFF

GO
CREATE TRIGGER [dbo].[utg_Transfer_Evn_AfterDelete] 
   ON  [dbo].[TRANSFER_EVN] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Transfer_Evn_H]
			   (ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID, DISPOSITION_DATE, COMMENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID, DISPOSITION_DATE, COMMENT, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	
END
GO
CREATE TRIGGER [dbo].[utg_Transfer_Evn_AfterInsert] 
   ON  [dbo].[TRANSFER_EVN] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Transfer_Evn_H]
			    (ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID, DISPOSITION_DATE,COMMENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID, DISPOSITION_DATE, COMMENT, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
	
END
GO
CREATE TRIGGER [dbo].[utg_Transfer_Evn_AfterUpdate] 
   ON  [dbo].[TRANSFER_EVN] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 INSERT INTO $(varBMS_HISTORY).[dbo].[Transfer_Evn_H]
			    (ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID,DISPOSITION_DATE, COMMENT, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID, DISPOSITION_DATE, COMMENT, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	 
END
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER [dbo].[utg_Transfer_Evn_InsteadOfInsert] 
   ON  [dbo].[TRANSFER_EVN]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[Transfer_Evn]
			   (ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID, DISPOSITION_DATE, COMMENT, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID, DISPOSITION_DATE, COMMENT, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	    
	
	ELSE
		INSERT INTO [dbo].[Transfer_Evn]
			    (ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID, DISPOSITION_DATE, COMMENT, _ssis_timestamp)
			SELECT ACT_ID, DISPOSITION_ID, ADMISSION_FACILITY_UID,DISPOSITION_DATE, COMMENT, _ssis_timestamp
			  FROM inserted;
	
END
GO
CREATE TRIGGER [dbo].[utg_Transfer_Evn_InsteadOfUpdate] 
   ON  [dbo].[TRANSFER_EVN] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Transfer_Evn]
		SET DISPOSITION_ID = inserted.DISPOSITION_ID,
			ADMISSION_FACILITY_UID = inserted.ADMISSION_FACILITY_UID,
			DISPOSITION_DATE = inserted.DISPOSITION_DATE,
			COMMENT = inserted.COMMENT,
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Transfer_Evn]
		INNER JOIN inserted ON inserted.act_id = [dbo].[Transfer_Evn].act_id;  
	
	 ELSE
	    UPDATE [dbo].[Transfer_Evn]
		SET DISPOSITION_ID = inserted.DISPOSITION_ID,
			ADMISSION_FACILITY_UID = inserted.ADMISSION_FACILITY_UID,
			DISPOSITION_DATE = inserted.DISPOSITION_DATE,
			COMMENT = inserted.COMMENT,
			_ssis_timestamp = current_timestamp
		FROM [dbo].[Transfer_Evn]
		INNER JOIN inserted ON inserted.act_id = [dbo].[Transfer_Evn].act_id;

END
GO
ALTER TABLE [dbo].[TRANSFER_EVN] ADD CONSTRAINT [PK_TRANSFER_EVN] PRIMARY KEY CLUSTERED  ([ACT_ID]) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[TRANSFER_EVN] ([_ssis_timestamp]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[TRANSFER_EVN] ADD CONSTRAINT [FK_TRANSFER_EVN_ACT] FOREIGN KEY ([ACT_ID]) REFERENCES [dbo].[ACT] ([ID])
GO
ALTER TABLE [dbo].[TRANSFER_EVN] ADD CONSTRAINT [FK_TRANSFER_EVN_CONCEPT] FOREIGN KEY ([DISPOSITION_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
EXEC sp_addextendedproperty N'MS_Description', N'Transfer event table.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the transfer event act and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'ACT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'FK to the disposition''s admission facility', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'ADMISSION_FACILITY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Disposition comment.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'COMMENT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date of the disposition.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'DISPOSITION_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'FK to the disposition concept.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'DISPOSITION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'TRANSFER_EVN', 'COLUMN', N'UPDATEDBY'
GO