CREATE TABLE [dbo].[DISCHARGE_INT]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[DOMAIN_ID] [NVARCHAR] (50) NOT NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[DATE_ENTERED] [DATETIME] NOT NULL,
[IS_ACTIVE] [BIT] NOT NULL CONSTRAINT [DF_DISCHARGE_INT_IS_ACTIVE] DEFAULT ((1)),
[APPOINTMENT_DATE] [datetime] NULL,
[VISTA_SITE_UID] [UNIQUEIDENTIFIER] NULL,
[HOSPITAL_LOCATION_UID] [UNIQUEIDENTIFIER] NULL,
[WARD_UID] [UNIQUEIDENTIFIER] NULL,
[STATUS] [nvarchar] (200) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__DISCHARGE___ssis__3AC1AA49] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[CREATION_UTC_DATE] [datetime] NOT NULL 
)
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[DISCHARGE_INT_tgg_ssis_delete] on dbo.DISCHARGE_INT after delete as begin  delete [dbo].[DISCHARGE_INT_ssisdel] from [deleted] _xyz where [dbo].[DISCHARGE_INT_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[DISCHARGE_INT_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[DISCHARGE_INT_tgg_ssis_insert] on dbo.DISCHARGE_INT after insert as begin delete [dbo].[DISCHARGE_INT_ssisdel]  from [inserted] _xyz where [dbo].[DISCHARGE_INT_ssisdel].[ID]=[_xyz].[ID] end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Discharge_Int_AfterDelete] 
   ON  [dbo].[DISCHARGE_INT] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
    	INSERT INTO $(varBMS_HISTORY).[dbo].[Discharge_Int_H]
			   (ID, DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Discharge_Int_AfterInsert] 
   ON  [dbo].[DISCHARGE_INT] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Discharge_Int_H]
			   (ID, DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Discharge_Int_AfterUpdate] 
   ON  [dbo].[DISCHARGE_INT] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[Discharge_Int_H]
			    (ID, DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT   ID, DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
     
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Discharge_Int_InsteadOfInsert] 
   ON  [dbo].[DISCHARGE_INT]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     INSERT INTO [dbo].[Discharge_Int]
				(DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, _ssis_timestamp, CREATED, CREATEDBY)
		SELECT   DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;	    
	ELSE
		INSERT INTO [dbo].[Discharge_Int]
				(DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, _ssis_timestamp)
		SELECT   DOMAIN_ID, PATIENT_UID, DATE_ENTERED, IS_ACTIVE, APPOINTMENT_DATE, VISTA_SITE_UID, HOSPITAL_LOCATION_UID, WARD_UID, STATUS, CREATION_UTC_DATE, _ssis_timestamp
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Discharge_Int_InsteadOfUpdate] 
   ON  [dbo].[DISCHARGE_INT] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[DISCHARGE_INT] 
			SET DOMAIN_ID = inserted.DOMAIN_ID, 
				PATIENT_UID= inserted.PATIENT_UID, 
				DATE_ENTERED = inserted.DATE_ENTERED, 
				IS_ACTIVE = inserted.IS_ACTIVE, 
				APPOINTMENT_DATE = inserted.APPOINTMENT_DATE,
				VISTA_SITE_UID = inserted.VISTA_SITE_UID,
				HOSPITAL_LOCATION_UID = inserted.HOSPITAL_LOCATION_UID,
				WARD_UID = inserted.WARD_UID, 
				STATUS = inserted.STATUS,
				CREATION_UTC_DATE = inserted.CREATION_UTC_DATE,
				_ssis_timestamp = current_timestamp,
				UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
				UPDATED = GETUTCDATE()
		FROM [dbo].[DISCHARGE_INT] 
			INNER JOIN inserted ON inserted.ID = [dbo].[DISCHARGE_INT].ID;	 
	 ELSE
	    UPDATE [dbo].[DISCHARGE_INT] 
			SET DOMAIN_ID = inserted.DOMAIN_ID, 
				PATIENT_UID= inserted.PATIENT_UID, 
				DATE_ENTERED = inserted.DATE_ENTERED, 
				IS_ACTIVE = inserted.IS_ACTIVE, 
				APPOINTMENT_DATE = inserted.APPOINTMENT_DATE,
				VISTA_SITE_UID = inserted.VISTA_SITE_UID,
				HOSPITAL_LOCATION_UID = inserted.HOSPITAL_LOCATION_UID,
				WARD_UID = inserted.WARD_UID, 
				STATUS = inserted.STATUS,
				CREATION_UTC_DATE = inserted.CREATION_UTC_DATE,
				_ssis_timestamp = current_timestamp
		FROM [dbo].[DISCHARGE_INT] 
			INNER JOIN inserted ON inserted.ID = [dbo].[DISCHARGE_INT].ID;	 

END
GO

--Constraints
ALTER TABLE [dbo].[DISCHARGE_INT] ADD CONSTRAINT [PK_DISCHARGE_INT] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[DISCHARGE_INT] ADD CONSTRAINT [DF_DISCHARGE_INT_CREATION_UTC_DATE]  DEFAULT (getutcdate()) FOR [CREATION_UTC_DATE]
GO

--Indexes
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[DISCHARGE_INT] ([_ssis_timestamp]) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_APP_DATE_HL_ID] ON [dbo].[DISCHARGE_INT] 
(
	[APPOINTMENT_DATE] ASC,
	[HOSPITAL_LOCATION_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_APPOINTMENT_DATE_PATIENT_UID_VISTA_SITE_UID] ON [dbo].[DISCHARGE_INT] 
(
	[APPOINTMENT_DATE] ASC,
	[PATIENT_UID] ASC,
	[VISTA_SITE_UID] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_APPOINTMENT_DATE_STATUS_IS_ACTIVE_PATIENT_UID_WARD_UID_VISTA_SITE_UID] ON [dbo].[DISCHARGE_INT] 
(
	[APPOINTMENT_DATE] ASC,
	[STATUS] ASC,
	[IS_ACTIVE] ASC,
	[PATIENT_UID] ASC,
	[WARD_UID] ASC,
	[VISTA_SITE_UID] ASC
)
INCLUDE ([HOSPITAL_LOCATION_UID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_DATE_ENTERED_APPOINTMENT_DATE_CREATION_UTC_DATE_IS_ACTIVE] ON [dbo].[DISCHARGE_INT] 
(
	[DATE_ENTERED] ASC,
	[APPOINTMENT_DATE] ASC,
	[CREATION_UTC_DATE] ASC,
	[IS_ACTIVE] ASC
)
INCLUDE ([ID], [HOSPITAL_LOCATION_UID], [WARD_UID], [PATIENT_UID] ) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO


CREATE NONCLUSTERED INDEX [IDX_IS_ACTIVE_HLOC] ON [dbo].[DISCHARGE_INT] 
(
	[IS_ACTIVE] ASC, 
	[HOSPITAL_LOCATION_UID] ASC,
	[APPOINTMENT_DATE] ASC
)
INCLUDE ([PATIENT_UID], [VISTA_SITE_UID], [WARD_UID], [STATUS] ) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Discharge intent act.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date planned for the discharge.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'APPOINTMENT_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the discharge status.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'STATUS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the facility from where the patient will be discharged.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'VISTA_SITE_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The hospital location id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT', @level2type=N'COLUMN',@level2name=N'HOSPITAL_LOCATION_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Entered date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT', @level2type=N'COLUMN',@level2name=N'DATE_ENTERED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If order is active.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT', @level2type=N'COLUMN',@level2name=N'IS_ACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Id of the ward from where the patient will be discharged.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT', @level2type=N'COLUMN',@level2name=N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'UID of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_INT', 'COLUMN', N'PATIENT_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The UTC date and time when the intent was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DISCHARGE_INT', @level2type=N'COLUMN',@level2name=N'CREATION_UTC_DATE'
GO