USE [BMS_HISTORY]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_PPBPUsageAuditLog_Facility]    Script Date: 6/14/2016 9:12:43 AM ******/
DROP PROCEDURE [dbo].[usp_Rpt_PPBPUsageAuditLog_Facility]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_PPBPUsageAuditLog_Facility]    Script Date: 6/14/2016 9:12:43 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [dbo].[usp_Rpt_PPBPUsageAuditLog_Facility]
	@DATE_FROM DATETIME,
	@DATE_TO DATETIME,
	@TIME_ZONE_MINUTES_OFFSET INT,
	@UserID NVARCHAR(500),
	@FACILITIES_IDS NVARCHAR(MAX) = '',
	@REPORT_TYPE NVARCHAR(50)
AS
/**********************************************************************************************
Object:   [usp_Rpt_PPBPUsageAuditLog_Facility]

Purpose:   PPBP Usage Audit Log Report

History: 
   5/2/2016 1130PM - Greg Milner: Added this header. Added OPTION (MAXDOP 1) on the big queries to 
     reduce parallelism. 
   4/??/2016 - created: David Horn

Note: 
    Need Entered D/T, Requested D/T, Removed D/T, Edit Event D/t, User, Transaction ("Patient" + record history)

EXAMPLE USAGE: 

    EXEC usp_Rpt_PPBPUsageAuditLog_Facility 
        @DATE_FROM = '4/24/2011', 
        @DATE_TO = '4/29/2016', 
        @TIME_ZONE_MINUTES_OFFSET = 0, 
        @UserID = 'domain\user', 
        @FACILITIES_IDS = '69378E0F-B210-493B-B2A1-2130C9F7F394', 
        @REPORT_TYPE = 'PPBPUsageAuditLog_Facility'

Issues:
IS IN HOUSE FROM NO TO NO
IS BED IN ISOLATION FROM NO TO NO
IS COMMUNITY LIVING CENTER FROM NO TO NO

**********************************************************************************************/
BEGIN
SET NOCOUNT ON;

IF (@REPORT_TYPE = 'PPBPUsageAuditLog_Facility')
BEGIN

	CREATE TABLE #TBL_FACILITY (
		SOURCE_ID NVARCHAR(250) PRIMARY KEY, 
		FACILITY_NAME NVARCHAR(250), 
		TIMEZONE_OFFSET INT)
	
	INSERT INTO #TBL_FACILITY(SOURCE_ID, FACILITY_NAME, TIMEZONE_OFFSET) 
    SELECT DISTINCT CONVERT(NVARCHAR(250), FACILITY.VALUE), 
                    ORG.NAME, 
                    [dbo].[Ufn_getoffsetbyfacilityuid](VALUE) 
    FROM   dbo.Ufn_split(@FACILITIES_IDS, ',') AS FACILITY 
           INNER JOIN bms_eis.dbo.ENTITY AS ENTITY 
                   ON ENTITY.IDENTIFIER = FACILITY.VALUE 
           INNER JOIN bms_eis.dbo.EHL7_ORGANIZATION AS ORG 
                   ON ORG.PFK_ORGANIZATION = ENTITY.PK_ENTITY  

	CREATE TABLE #TRANHISTORY (
			PK int,
			ACT_ID int,
			FACILITY_UID uniqueidentifier,
			VISTA_SITE_UID uniqueidentifier,
			WAITING_AREA_ID int,
			PROBLEM nvarchar(max),
			FEE_DISPOSITION_ID int,
			CONTRACT_FEE_ID int,
			AUTHORIZED_FEE_ID int,
			SERVICE_RECEIVING_FEE_ID int,
			REASON_USING_FEE_ID int,
			FEE_COMMENTS nvarchar(150),
			REMOVED_DATE datetime,
			TYPE_OF_BED_WARD nvarchar(250),
			EDIT_EVENT datetime,
			REQUESTED_BED_UID uniqueidentifier,
			REQUESTED_BED_DATE datetime,
			REQUESTED_DATE datetime,
			IS_IN_HOUSE bit,
			IS_BED_IN_ISOLATION bit,
			LAST_EDIT_BY nvarchar(100),
			TRANSACTION_TYPE_CODE varchar(50), 
			COMMENTS nvarchar(250),
			WAIT_TIME_ALERT_DATE datetime,
			IS_COMMUNITY_LIVING_CENTER bit,
			IS_EVACUATION_PATIENT bit,
			EVACUATION_DISPOSITION_STATUS_ID int,
			EVACUATION_EXPECTED_DATE datetime,
			EVACUATION_ACTUAL_DATE datetime,
			EVACUATION_REASON_FOR_DELAY nvarchar(250),
			EVACUATION_TRANSFER_EVACUATE_TO nvarchar(250),
			EVACUATION_EQUIP_SUPPLY_REQUIREMENTS nvarchar(250),
			EVACUATION_TRANSPORTATION_CARE_LEVEL nvarchar(250),
			EVACUATION_ENROUTE_MEDICAL_ATTENDANT nvarchar(250),
			EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT nvarchar(250),
			EVACUATION_TRANSPORTATION_TYPE_ID int,
			EVACUATION_TRANSPORTATION_PROVIDER_ID int,
			EVACUATION_TRANSPORTATION_COMMENTS nvarchar(250),
			EVACUATION_DESTINATION_ADDRESS nvarchar(250),
			EVACUATION_DESTINATION_CITY_STATE nvarchar(250),
			EVACUATION_DESTINATION_POC_TELEPHONE nvarchar(100),
			EVACAUTION_ORIGINATOR_POC_TELEPHONE nvarchar(100),
			EVACUATION_COMMENTS nvarchar(500),
			EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER int,
			EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER int,
			EVACUATION_VEHICLE_ID nvarchar(250),
			EVACUATION_VEHICLE_SEAT_POSITION nvarchar(250),
			EVACUATION_MA_TELEPHONE nvarchar(100),
			EVACUATION_NMA_TELEPHONE nvarchar(100),
			EVACUATION_ORIGINATING_FACILITY_NAME nvarchar(250),
			EVACUATION_ORIGINATING_ADDRESS nvarchar(250),
			EVACUATION_ORIGINATING_CITY_STATE nvarchar(250),
			EVACUATION_VEHICLE_OPERATOR_NAME nvarchar(250),
			EVACUATION_VEHICLE_OPERATOR_TELEPHONE nvarchar(100),
			ENTERED_DATE datetime,
			PATIENT_NAME nvarchar(50),
			ACTION_HISTORY varchar(max)
	)
	INSERT #TRANHISTORY
	SELECT	TRANHISTORY.PK,
			TRANHISTORY.ACT_ID,
			TRANHISTORY.FACILITY_UID,
			TRANHISTORY.VISTA_SITE_UID,
			TRANHISTORY.WAITING_AREA_ID,
			TRANHISTORY.PROBLEM,
			TRANHISTORY.FEE_DISPOSITION_ID,
			TRANHISTORY.CONTRACT_FEE_ID,
			TRANHISTORY.AUTHORIZED_FEE_ID,
			TRANHISTORY.SERVICE_RECEIVING_FEE_ID,
			TRANHISTORY.REASON_USING_FEE_ID,
			TRANHISTORY.FEE_COMMENTS,
			TRANHISTORY.REMOVED_DATE,
			TRANHISTORY.TYPE_OF_BED_WARD,
			TRANHISTORY.DATE as EDIT_EVENT,
			TRANHISTORY.REQUESTED_BED_UID,
			TRANHISTORY.REQUESTED_BED_DATE,
			TRANHISTORY.REQUESTED_DATE, 
			TRANHISTORY.IS_IN_HOUSE,
			TRANHISTORY.IS_BED_IN_ISOLATION,
			TRANHISTORY.LAST_EDIT_BY,
			TRANHISTORY.TRANSACTION_TYPE_CODE,
			TRANHISTORY.COMMENTS,
			TRANHISTORY.WAIT_TIME_ALERT_DATE,
			TRANHISTORY.IS_COMMUNITY_LIVING_CENTER,
			TRANHISTORY.IS_EVACUATION_PATIENT,
			TRANHISTORY.EVACUATION_DISPOSITION_STATUS_ID,
			TRANHISTORY.EVACUATION_EXPECTED_DATE,
			TRANHISTORY.EVACUATION_ACTUAL_DATE,
			TRANHISTORY.EVACUATION_REASON_FOR_DELAY,
			TRANHISTORY.EVACUATION_TRANSFER_EVACUATE_TO,
			TRANHISTORY.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS,
			TRANHISTORY.EVACUATION_TRANSPORTATION_CARE_LEVEL,
			TRANHISTORY.EVACUATION_ENROUTE_MEDICAL_ATTENDANT,
			TRANHISTORY.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT,
			TRANHISTORY.EVACUATION_TRANSPORTATION_TYPE_ID,
			TRANHISTORY.EVACUATION_TRANSPORTATION_PROVIDER_ID,
			TRANHISTORY.EVACUATION_TRANSPORTATION_COMMENTS,
			TRANHISTORY.EVACUATION_DESTINATION_ADDRESS,
			TRANHISTORY.EVACUATION_DESTINATION_CITY_STATE,
			TRANHISTORY.EVACUATION_DESTINATION_POC_TELEPHONE,
			TRANHISTORY.EVACUATION_ORIGINATOR_POC_TELEPHONE,
			TRANHISTORY.EVACUATION_COMMENTS,
			TRANHISTORY.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER,
			TRANHISTORY.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER,
			TRANHISTORY.EVACUATION_VEHICLE_ID,
			TRANHISTORY.EVACUATION_VEHICLE_SEAT_POSITION,
			TRANHISTORY.EVACUATION_MA_TELEPHONE,
			TRANHISTORY.EVACUATION_NMA_TELEPHONE,
			TRANHISTORY.EVACUATION_ORIGINATING_FACILITY_NAME,
			TRANHISTORY.EVACUATION_ORIGINATING_ADDRESS,
			TRANHISTORY.EVACUATION_ORIGINATING_CITY_STATE,
			TRANHISTORY.EVACUATION_VEHICLE_OPERATOR_NAME,
			TRANHISTORY.EVACUATION_VEHICLE_OPERATOR_TELEPHONE,
			ACTHISTORY.CREATION_DATE as ENTERED_DATE, 
			
			SUBSTRING(PERSON.[NAME_FIRST_GIVEN], 1, 1) + PERSON.[NAME_FAMILY] + ' ' + SUBSTRING(s.[IDENTIFIER_EXTENSION], 8, 4) AS PATIENTNAME,
			CASE WHEN TRANHISTORY.TRANSACTION_TYPE_CODE = 'I' THEN 'NEW RECORD' 
				 WHEN TRANHISTORY.TRANSACTION_TYPE_CODE = 'U' THEN 'UPDATED'
				 WHEN TRANHISTORY.TRANSACTION_TYPE_CODE = 'D' THEN 'DELETED'
			END as ACTIONTYPE 
	FROM WAITING_LIST_H TRANHISTORY
	INNER JOIN #TBL_FACILITY FAC
		ON TRANHISTORY.FACILITY_UID = FAC.SOURCE_ID
	INNER JOIN ACT_H ACTHISTORY
		ON TRANHISTORY.ACT_ID = ACTHISTORY.ID
	INNER JOIN BMS_EIS.dbo.ENTITY AS ENTITY 
		ON ENTITY.IDENTIFIER = ACTHISTORY.PATIENT_UID
	INNER JOIN BMS_EIS.dbo.EHL7_PERSON AS PERSON 
		ON PERSON.PFK_PERSON = ENTITY.PK_ENTITY
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS S 
		ON S.FK_ENTITY = PERSON.PFK_PERSON AND S.IDENTIFIER_ROOT = 'SSN'
	LEFT JOIN ACT_H ACTLAST
		ON TRANHISTORY.ACT_ID = ACTLAST.PARENT_ACT_ID
	LEFT JOIN TRANSFER_EVN_H TRANEVNH
		ON ACTLAST.ID = TRANEVNH.ACT_ID
	WHERE TRANHISTORY.DATE BETWEEN @DATE_FROM AND @DATE_TO
	ORDER BY TRANHISTORY.DATE ASC
	OPTION (MAXDOP 1) 
	--SELECT * FROM #TRANHISTORY

	CREATE TABLE #MY_CONCEPT_H(
		PK int,
		ID int,
		CODE varchar(100),
		CODE_SYSTEM varchar(100),
		CODE_SYSTEM_NAME varchar(250),
		DISPLAY_NAME nvarchar(250),
		TRANSACTION_TYPE_CODE varchar(50),
		DATE datetime,
		CREATED_BY nvarchar(50)
	)

	create index mcth__CODE_SYSTEM_NAME on #MY_CONCEPT_H
    ( CODE_SYSTEM_NAME ) 

    create index mcth__DISPLAY_NAME on  #MY_CONCEPT_H
    ( DISPLAY_NAME ) 
	
	INSERT #MY_CONCEPT_H
	SELECT PK, ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY 
	FROM CONCEPT_H

	SELECT DISTINCT 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.ENTERED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.ENTERED_DATE), 108) as ENTERED_DATE, 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_DATE), 108) as REQUESTED_DATE,
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.REQUESTED_DATE), 108) as PREV_REQUESTED_DATE,
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.REMOVED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REMOVED_DATE), 108) as REMOVED_DATE,
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.EDIT_EVENT), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.EDIT_EVENT), 108) as EDITED,
		   H_WAITING_LIST.LAST_EDIT_BY,
		   H_WAITING_LIST.PATIENT_NAME,
		   H_WAITING_LIST.ACT_ID,
		   H_WAITING_LIST.ACTION_HISTORY,
		   --H_WAITING_LIST.ACTION_HISTORY,
	CASE WHEN H_WAITING_LIST.TRANSACTION_TYPE_CODE = 'U' THEN 
		CASE WHEN ORG1.NAME <> ORG2.NAME OR (ORG1.NAME IS NULL AND ORG2.NAME IS NOT NULL) OR (ORG1.NAME IS NOT NULL AND ORG2.NAME IS NULL) 
			THEN 'FACILITY FROM ' + ISNULL(ORG1.NAME,'<Empty>') + ' TO ' + ISNULL(ORG2.NAME,'<Empty>') + char(13)+char(10) + '' ELSE '' END +
--		CASE WHEN H_WAITING_LIST.FACILITY_UID <> PREVIOUS_H_WAITING_LIST.FACILITY_UID THEN 'VA ADMISSION FACILITY FROM ' + ORG1.NAME + ' TO ' + ORG2.NAME + ' ' END +
		CASE WHEN VISTANAME1.NAME <> VISTANAME2.NAME THEN 'VISTA SITE NAME ' + ISNULL(VISTANAME1.NAME,'<Empty>') + ' TO ' + ISNULL(VISTANAME2.NAME, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.PROBLEM <> PREVIOUS_H_WAITING_LIST.PROBLEM OR (H_WAITING_LIST.PROBLEM IS NULL AND PREVIOUS_H_WAITING_LIST.PROBLEM IS NOT NULL) OR (H_WAITING_LIST.PROBLEM IS NOT NULL AND PREVIOUS_H_WAITING_LIST.PROBLEM IS NULL)
			THEN 'PROBLEM FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.PROBLEM,'<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.PROBLEM,'<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN FD1.DISPLAY_NAME <> FD2.DISPLAY_NAME OR (FD1.DISPLAY_NAME IS NULL AND Fd2.DISPLAY_NAME IS NOT NULL) OR (FD1.DISPLAY_NAME IS NOT NULL AND FD2.DISPLAY_NAME IS NULL)
			THEN 'FEE DISPOSITION FROM ' + ISNULL(FD1.DISPLAY_NAME,'<Empty>') + ' TO ' + ISNULL(FD2.DISPLAY_NAME,'<Empty>') + +char(13)+char(10) ELSE '' END +
			 /* Skipping SERVICE_RECEIVING_FEE_ID*/ 
		CASE WHEN CF1.DISPLAY_NAME <> CF2.DISPLAY_NAME OR (CF1.DISPLAY_NAME IS NULL AND CF2.DISPLAY_NAME IS NOT NULL) OR (CF1.DISPLAY_NAME IS NOT NULL AND CF2.DISPLAY_NAME IS NULL)
			THEN 'CONTRACT FEE FROM ' + ISNULL(CF1.DISPLAY_NAME,'<Empty>') + ' TO ' + ISNULL(CF2.DISPLAY_NAME,'<Empty>') + +char(13)+char(10) ELSE '' END +
		CASE WHEN AF1.DISPLAY_NAME <> AF2.DISPLAY_NAME OR (AF1.DISPLAY_NAME IS NULL AND AF2.DISPLAY_NAME IS NOT NULL) OR (AF1.DISPLAY_NAME IS NOT NULL AND AF2.DISPLAY_NAME IS NULL)
			THEN 'AUTHORIZED FEE FROM ' + ISNULL(AF1.DISPLAY_NAME,'<Empty>') + ' TO ' + ISNULL(AF2.DISPLAY_NAME,'<Empty>') + +char(13)+char(10) ELSE '' END +
		CASE WHEN FR1.DISPLAY_NAME <> FR2.DISPLAY_NAME OR (FR1.DISPLAY_NAME IS NULL AND FR2.DISPLAY_NAME IS NOT NULL) OR (FR1.DISPLAY_NAME IS NOT NULL AND FR2.DISPLAY_NAME IS NULL)
			THEN 'REASON USING FEE FROM ' + ISNULL(FR1.DISPLAY_NAME,'<Empty>') + ' TO ' + ISNULL(FR2.DISPLAY_NAME,'<Empty>') + +char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.FEE_COMMENTS <> PREVIOUS_H_WAITING_LIST.FEE_COMMENTS OR (H_WAITING_LIST.FEE_COMMENTS IS NULL AND PREVIOUS_H_WAITING_LIST.FEE_COMMENTS IS NOT NULL) OR (H_WAITING_LIST.FEE_COMMENTS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.FEE_COMMENTS IS NULL)
			THEN 'FEE COMMENTS FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.FEE_COMMENTS,'<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.FEE_COMMENTS,'<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.REMOVED_DATE <> PREVIOUS_H_WAITING_LIST.REMOVED_DATE OR (H_WAITING_LIST.REMOVED_DATE IS NULL AND PREVIOUS_H_WAITING_LIST.REMOVED_DATE IS NOT NULL) OR (H_WAITING_LIST.REMOVED_DATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.REMOVED_DATE IS NULL) 
			THEN 'REMOVED DATE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.REMOVED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.REMOVED_DATE), 101), '') + ' ' + ISNULL(CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.REMOVED_DATE), 108), '') END + 
				' TO ' + CASE WHEN H_WAITING_LIST.REMOVED_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REMOVED_DATE), 101) + ' ' + ISNULL(CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REMOVED_DATE), 108),'') END + ' ' ELSE '' END +
		CASE WHEN H_WAITING_LIST.TYPE_OF_BED_WARD <> PREVIOUS_H_WAITING_LIST.TYPE_OF_BED_WARD OR (H_WAITING_LIST.TYPE_OF_BED_WARD IS NULL AND PREVIOUS_H_WAITING_LIST.TYPE_OF_BED_WARD IS NOT NULL) OR (H_WAITING_LIST.TYPE_OF_BED_WARD IS NOT NULL AND PREVIOUS_H_WAITING_LIST.TYPE_OF_BED_WARD IS NULL) 
			THEN 'TYPE OF BED WARD FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.TYPE_OF_BED_WARD,'<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.TYPE_OF_BED_WARD,'<Empty>') +char(13)+char(10) ELSE '' END +
			 --skipped REQUESTED_BED_UID
		CASE WHEN H_WAITING_LIST.REQUESTED_BED_DATE <> PREVIOUS_H_WAITING_LIST.REQUESTED_BED_DATE OR (H_WAITING_LIST.REQUESTED_BED_DATE IS NULL AND PREVIOUS_H_WAITING_LIST.REQUESTED_BED_DATE IS NOT NULL) OR (H_WAITING_LIST.REQUESTED_BED_DATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.REQUESTED_BED_DATE IS NULL)
			THEN 'REQUESTED BED DATE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.REQUESTED_BED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.REQUESTED_BED_DATE), 101),'') + ' ' + ISNULL(CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.REQUESTED_BED_DATE), 108),'') END + 
				' TO ' + CASE WHEN H_WAITING_LIST.REQUESTED_BED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_BED_DATE), 101),'') + ' ' + ISNULL(CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_BED_DATE), 108),'') END +char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.REQUESTED_DATE <> PREVIOUS_H_WAITING_LIST.REQUESTED_DATE OR (H_WAITING_LIST.REQUESTED_DATE IS NULL AND PREVIOUS_H_WAITING_LIST.REQUESTED_DATE IS NOT NULL) OR (H_WAITING_LIST.REQUESTED_DATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.REQUESTED_DATE IS NULL)
			THEN 'REQUESTED ADMISSION DATE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.REQUESTED_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.REQUESTED_DATE), 101) + ' ' + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.REQUESTED_DATE), 108) END + 
				' TO ' + CASE WHEN H_WAITING_LIST.REQUESTED_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_DATE), 101) + ' ' + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_DATE), 108) END + char(13)+char(10) ELSE '' END +
				--issue above: REQUESTED ADMISSION DATE DIDN'T ACTUALLY CHANGE?!?		
		CASE WHEN H_WAITING_LIST.IS_IN_HOUSE <> PREVIOUS_H_WAITING_LIST.IS_IN_HOUSE --OR (H_WAITING_LIST.IS_IN_HOUSE IS NULL AND PREVIOUS_H_WAITING_LIST.IS_IN_HOUSE IS NOT NULL) OR (H_WAITING_LIST.IS_IN_HOUSE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.IS_IN_HOUSE IS NULL)
			THEN 'IS IN HOUSE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.IS_IN_HOUSE = 1 THEN 'YES' ELSE 'NO' END + ' TO ' + CASE WHEN H_WAITING_LIST.IS_IN_HOUSE = 1 THEN 'YES' ELSE 'NO' END + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.IS_BED_IN_ISOLATION <> PREVIOUS_H_WAITING_LIST.IS_BED_IN_ISOLATION --OR (H_WAITING_LIST.IS_BED_IN_ISOLATION IS NULL AND PREVIOUS_H_WAITING_LIST.IS_BED_IN_ISOLATION IS NOT NULL) OR (H_WAITING_LIST.IS_BED_IN_ISOLATION IS NOT NULL AND PREVIOUS_H_WAITING_LIST.IS_BED_IN_ISOLATION IS NULL)
			THEN 'IS BED IN ISOLATION FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.IS_BED_IN_ISOLATION = 1 THEN 'YES' ELSE 'NO' END + ' TO ' + CASE WHEN H_WAITING_LIST.IS_BED_IN_ISOLATION = 1 THEN 'YES' ELSE 'NO' END + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.WAIT_TIME_ALERT_DATE <> PREVIOUS_H_WAITING_LIST.WAIT_TIME_ALERT_DATE OR (H_WAITING_LIST.WAIT_TIME_ALERT_DATE IS NULL AND PREVIOUS_H_WAITING_LIST.WAIT_TIME_ALERT_DATE IS NOT NULL) OR (H_WAITING_LIST.WAIT_TIME_ALERT_DATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.WAIT_TIME_ALERT_DATE IS NULL) 
			THEN 'WAIT TIME ALERT DATE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.WAIT_TIME_ALERT_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.WAIT_TIME_ALERT_DATE), 101) + ' ' + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.WAIT_TIME_ALERT_DATE), 108) END + 
				' TO ' + CASE WHEN H_WAITING_LIST.WAIT_TIME_ALERT_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.WAIT_TIME_ALERT_DATE), 101) + ' ' + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.WAIT_TIME_ALERT_DATE), 108) END + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.IS_COMMUNITY_LIVING_CENTER <> PREVIOUS_H_WAITING_LIST.IS_COMMUNITY_LIVING_CENTER --OR (H_WAITING_LIST.IS_COMMUNITY_LIVING_CENTER IS NULL AND PREVIOUS_H_WAITING_LIST.IS_COMMUNITY_LIVING_CENTER IS NOT NULL) OR (H_WAITING_LIST.IS_COMMUNITY_LIVING_CENTER IS NOT NULL AND PREVIOUS_H_WAITING_LIST.IS_COMMUNITY_LIVING_CENTER IS NULL)
			THEN 'IS COMMUNITY LIVING CENTER FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.IS_COMMUNITY_LIVING_CENTER = 1 THEN 'YES' ELSE 'NO' END + ' TO ' + CASE WHEN H_WAITING_LIST.IS_COMMUNITY_LIVING_CENTER = 1 THEN 'YES' ELSE 'NO' END + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.IS_EVACUATION_PATIENT <> PREVIOUS_H_WAITING_LIST.IS_EVACUATION_PATIENT THEN 'IS EVACUATION PATIENT FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.IS_EVACUATION_PATIENT = 1 THEN 'YES' ELSE 'NO' END + ' TO ' + CASE WHEN H_WAITING_LIST.IS_EVACUATION_PATIENT = 1 THEN 'YES' ELSE 'NO' END + char(13)+char(10) ELSE '' END +
		CASE WHEN ED1.ID <> ED2.ID OR (ED1.DISPLAY_NAME IS NULL AND ED2.DISPLAY_NAME IS NOT NULL) OR (ED1.DISPLAY_NAME IS NOT NULL AND ED2.DISPLAY_NAME IS NULL)
			THEN 'EVACUATION DISPOSITION STATUS FROM ' + ISNULL(ED1.DISPLAY_NAME, '<Empty>') + ' TO ' + ISNULL(ED2.DISPLAY_NAME, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_EXPECTED_DATE <> PREVIOUS_H_WAITING_LIST.EVACUATION_EXPECTED_DATE OR (H_WAITING_LIST.EVACUATION_EXPECTED_DATE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_EXPECTED_DATE IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_EXPECTED_DATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_EXPECTED_DATE IS NULL)
			THEN 'EVACUATION EXPECTED DATE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.EVACUATION_EXPECTED_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.EVACUATION_EXPECTED_DATE), 101) + ' ' + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.EVACUATION_EXPECTED_DATE), 108) END + 
				' TO ' + CASE WHEN PREVIOUS_H_WAITING_LIST.EVACUATION_EXPECTED_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.EVACUATION_EXPECTED_DATE), 101) + ' ' + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.EVACUATION_EXPECTED_DATE), 108) END + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_ACTUAL_DATE <> PREVIOUS_H_WAITING_LIST.EVACUATION_ACTUAL_DATE OR (H_WAITING_LIST.EVACUATION_ACTUAL_DATE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ACTUAL_DATE IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_ACTUAL_DATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ACTUAL_DATE IS NULL)
			THEN 'EVACUATION ACTUAL DATE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.EVACUATION_ACTUAL_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.EVACUATION_ACTUAL_DATE), 101) + ' ' + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, PREVIOUS_H_WAITING_LIST.EVACUATION_ACTUAL_DATE), 108) END + 
				' TO ' + CASE WHEN H_WAITING_LIST.EVACUATION_ACTUAL_DATE IS NULL THEN '<Empty>' ELSE CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.EVACUATION_ACTUAL_DATE), 101) + ' ' + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.EVACUATION_ACTUAL_DATE), 108) END + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_REASON_FOR_DELAY <> PREVIOUS_H_WAITING_LIST.EVACUATION_REASON_FOR_DELAY OR (H_WAITING_LIST.EVACUATION_REASON_FOR_DELAY IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_REASON_FOR_DELAY IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_REASON_FOR_DELAY IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_REASON_FOR_DELAY IS NULL) 
			THEN 'EVACUATION REASON FOR DELAY FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_REASON_FOR_DELAY, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_REASON_FOR_DELAY, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_TRANSFER_EVACUATE_TO <> PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSFER_EVACUATE_TO OR (H_WAITING_LIST.EVACUATION_TRANSFER_EVACUATE_TO IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSFER_EVACUATE_TO IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_TRANSFER_EVACUATE_TO IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSFER_EVACUATE_TO IS NULL)
			THEN 'EVACUATION TRANSFER EVACUATE TO ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSFER_EVACUATE_TO, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_TRANSFER_EVACUATE_TO, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS <> PREVIOUS_H_WAITING_LIST.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS OR (H_WAITING_LIST.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS IS NULL)
			THEN 'EVACUATION EQUIPMENT SUPPLY REQUIREMENTS ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_TRANSPORTATION_CARE_LEVEL <> PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_CARE_LEVEL OR (H_WAITING_LIST.EVACUATION_TRANSPORTATION_CARE_LEVEL IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_CARE_LEVEL IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_TRANSPORTATION_CARE_LEVEL IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_CARE_LEVEL IS NULL)
			THEN 'EVACUATION TRANSPORTATION CARE LEVEL ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_CARE_LEVEL, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_TRANSPORTATION_CARE_LEVEL, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT <> PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT OR (H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT IS NULL)
			THEN 'EVACUATION ENROUTE MEDICAL ATTENDANT ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT <> PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT OR (H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT IS NULL)
			THEN 'EVACUATION ENROUTE NON-MEDICAL ATTENDANT ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN TT1.ID <> TT2.ID OR (TT1.DISPLAY_NAME IS NULL AND TT2.DISPLAY_NAME IS NOT NULL) OR (TT1.DISPLAY_NAME IS NOT NULL AND TT2.DISPLAY_NAME IS NULL)
			THEN 'EVACUATION TRANSPORTATION TYPE FROM ' + ISNULL(TT1.DISPLAY_NAME, '<Empty>') + ' TO ' + ISNULL(TT2.DISPLAY_NAME, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN TP1.ID <> TP2.ID OR (TP1.DISPLAY_NAME IS NULL AND TP2.DISPLAY_NAME IS NOT NULL) OR (TP1.DISPLAY_NAME IS NOT NULL AND TP2.DISPLAY_NAME IS NULL)
			THEN 'EVACUATION TRANSPORTATION PROVIDER FROM ' + ISNULL(TP1.DISPLAY_NAME, '<Empty>') + ' TO ' + ISNULL(TP2.DISPLAY_NAME, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN WA1.ID <> WA2.ID OR (WA1.DISPLAY_NAME IS NULL AND WA2.DISPLAY_NAME IS NOT NULL) OR (WA1.DISPLAY_NAME IS NOT NULL AND WA2.DISPLAY_NAME IS NULL)
			THEN 'WAITING AREA FROM ' + ISNULL(WA1.DISPLAY_NAME, '<Empty>') + ' TO ' + ISNULL(WA2.DISPLAY_NAME, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_TRANSPORTATION_COMMENTS <> PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_COMMENTS OR (H_WAITING_LIST.EVACUATION_TRANSPORTATION_COMMENTS IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_COMMENTS IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_TRANSPORTATION_COMMENTS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_COMMENTS IS NULL)
			THEN 'EVACUATION TRANSPORTATION COMMENTS ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_COMMENTS, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_TRANSPORTATION_COMMENTS, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_DESTINATION_ADDRESS <> PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_ADDRESS OR (H_WAITING_LIST.EVACUATION_DESTINATION_ADDRESS IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_ADDRESS IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_DESTINATION_ADDRESS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_ADDRESS IS NULL)
			THEN 'EVACUATION DESTINATION ADDRESS ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_ADDRESS, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_DESTINATION_ADDRESS, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_DESTINATION_CITY_STATE <> PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_CITY_STATE OR (H_WAITING_LIST.EVACUATION_DESTINATION_CITY_STATE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_CITY_STATE IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_DESTINATION_CITY_STATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_CITY_STATE IS NULL) 
			THEN 'EVACUATION DESTINATION CITY STATE ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_CITY_STATE, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_DESTINATION_CITY_STATE, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_DESTINATION_POC_TELEPHONE != PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_POC_TELEPHONE OR (H_WAITING_LIST.EVACUATION_DESTINATION_POC_TELEPHONE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_POC_TELEPHONE IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_DESTINATION_POC_TELEPHONE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_POC_TELEPHONE IS NULL)
			THEN 'EVACUATION DESTINATION POC TELEPHONE ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_DESTINATION_POC_TELEPHONE, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_DESTINATION_POC_TELEPHONE, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACAUTION_ORIGINATOR_POC_TELEPHONE != PREVIOUS_H_WAITING_LIST.EVACAUTION_ORIGINATOR_POC_TELEPHONE OR (H_WAITING_LIST.EVACAUTION_ORIGINATOR_POC_TELEPHONE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACAUTION_ORIGINATOR_POC_TELEPHONE IS NOT NULL) OR (H_WAITING_LIST.EVACAUTION_ORIGINATOR_POC_TELEPHONE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACAUTION_ORIGINATOR_POC_TELEPHONE IS NULL)
			THEN 'EVACUATION ORIGINATOR POC TELEPHONE ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACAUTION_ORIGINATOR_POC_TELEPHONE, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACAUTION_ORIGINATOR_POC_TELEPHONE, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_COMMENTS != PREVIOUS_H_WAITING_LIST.EVACUATION_COMMENTS OR (H_WAITING_LIST.EVACUATION_COMMENTS IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_COMMENTS IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_COMMENTS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_COMMENTS IS NULL) 
			THEN 'EVACUATION COMMENTS FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_COMMENTS, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_COMMENTS, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER != PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER OR (H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER IS NULL) 
			THEN 'EVACUATION ENROUTE MEDICAL ATTENDANT NUMBER ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER), '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_VEHICLE_ID <> PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_ID OR (H_WAITING_LIST.EVACUATION_VEHICLE_ID IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_ID IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_VEHICLE_ID IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_ID IS NULL) 
			THEN 'EVACUATION VEHICLE ID FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_ID, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_VEHICLE_ID, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_VEHICLE_SEAT_POSITION != PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_SEAT_POSITION OR (H_WAITING_LIST.EVACUATION_VEHICLE_SEAT_POSITION IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_SEAT_POSITION IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_VEHICLE_SEAT_POSITION IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_SEAT_POSITION IS NULL)  
			THEN 'EVACUATION VEHICLE SEAT POSITION FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_SEAT_POSITION, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.EVACUATION_VEHICLE_SEAT_POSITION, '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_MA_TELEPHONE != PREVIOUS_H_WAITING_LIST.EVACUATION_MA_TELEPHONE OR (H_WAITING_LIST.EVACUATION_MA_TELEPHONE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_MA_TELEPHONE IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_MA_TELEPHONE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_MA_TELEPHONE IS NULL) 
			THEN 'EVACUATION MA TELEPHONE ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_MA_TELEPHONE), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_MA_TELEPHONE), '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_NMA_TELEPHONE != PREVIOUS_H_WAITING_LIST.EVACUATION_NMA_TELEPHONE OR (H_WAITING_LIST.EVACUATION_NMA_TELEPHONE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_NMA_TELEPHONE IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_NMA_TELEPHONE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_NMA_TELEPHONE IS NULL) 
			THEN 'EVACUATION NMA TELEPHONE ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_NMA_TELEPHONE), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_NMA_TELEPHONE), '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_ORIGINATING_FACILITY_NAME != PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_FACILITY_NAME OR (H_WAITING_LIST.EVACUATION_ORIGINATING_FACILITY_NAME IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_FACILITY_NAME IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_ORIGINATING_FACILITY_NAME IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_FACILITY_NAME IS NULL) 
			THEN 'EVACUATION ORIGINATING FACILITY NAME ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_FACILITY_NAME), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_ORIGINATING_FACILITY_NAME), '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_ORIGINATING_ADDRESS != PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_ADDRESS OR (H_WAITING_LIST.EVACUATION_ORIGINATING_ADDRESS IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_ADDRESS IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_ORIGINATING_ADDRESS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_ADDRESS IS NULL) 
			THEN 'EVACUATION ORIGINATING ADDRESS ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_ADDRESS), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_ORIGINATING_ADDRESS), '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_ORIGINATING_CITY_STATE != PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_CITY_STATE OR (H_WAITING_LIST.EVACUATION_ORIGINATING_CITY_STATE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_CITY_STATE IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_ORIGINATING_CITY_STATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_CITY_STATE IS NULL) 
			THEN 'EVACUATION ORIGINATING CITY STATE ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_ORIGINATING_CITY_STATE), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_ORIGINATING_CITY_STATE), '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_NAME != PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_NAME OR (H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_NAME IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_NAME IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_NAME IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_NAME IS NULL) 
			THEN 'EVACUATION VEHICLE OPERATOR NAME ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_NAME), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_NAME), '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_TELEPHONE != PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_TELEPHONE OR (H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_TELEPHONE IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_TELEPHONE IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_TELEPHONE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_TELEPHONE IS NULL) 
			THEN 'EVACUATION VEHICLE OPERATOR TELEPHONE ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_TELEPHONE), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_VEHICLE_OPERATOR_TELEPHONE), '<Empty>') + char(13)+char(10) ELSE '' END +
		CASE WHEN H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER != PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER OR (H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER IS NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER IS NOT NULL) OR (H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER IS NOT NULL AND PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER IS NULL) 
			THEN 'EVACUATION ENROUTE NON-MEDICAL ATTENDANT NUMBER ' + ISNULL(CONVERT(VARCHAR(30), PREVIOUS_H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER), '<Empty>') + ' TO ' + ISNULL(CONVERT(VARCHAR(30), H_WAITING_LIST.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER), '<Empty>') + char(13)+char(10) ELSE '' END

		
	ELSE ''--H_WAITING_LIST.ACTION_HISTORY 
	END as TRAN_UPDS,
	CASE WHEN (H_WAITING_LIST.COMMENTS != PREVIOUS_H_WAITING_LIST.COMMENTS) OR (H_WAITING_LIST.COMMENTS IS NULL AND PREVIOUS_H_WAITING_LIST.COMMENTS IS NOT NULL) OR (H_WAITING_LIST.COMMENTS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.COMMENTS IS NULL) 
		THEN  'COMMENTS FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.COMMENTS, '<Empty>') + ' TO ' + ISNULL(H_WAITING_LIST.COMMENTS, '<Empty>') ELSE '' END as TRAN_COMMENTS
	
	FROM #TRANHISTORY H_WAITING_LIST
	LEFT JOIN #TRANHISTORY AS PREVIOUS_H_WAITING_LIST ON
	PREVIOUS_H_WAITING_LIST.ACT_ID = H_WAITING_LIST.ACT_ID AND
	PREVIOUS_H_WAITING_LIST.PK < H_WAITING_LIST.PK
	LEFT JOIN BMS_EIS.dbo.ENTITY AS ENTITY1 ON ENTITY1.IDENTIFIER = PREVIOUS_H_WAITING_LIST.FACILITY_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS ORG1 ON ORG1.PFK_ORGANIZATION = ENTITY1.PK_ENTITY
	LEFT JOIN BMS_EIS.dbo.ENTITY AS ENTITY2 ON ENTITY2.IDENTIFIER = H_WAITING_LIST.FACILITY_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS ORG2 ON ORG2.PFK_ORGANIZATION = ENTITY2.PK_ENTITY
	LEFT JOIN BMS_EIS.dbo.ENTITY AS VISTASITE1 ON VISTASITE1.IDENTIFIER = PREVIOUS_H_WAITING_LIST.VISTA_SITE_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS VISTANAME1 ON VISTANAME1.PFK_ORGANIZATION = VISTASITE1.PK_ENTITY
	LEFT JOIN BMS_EIS.dbo.ENTITY AS VISTASITE2 ON VISTASITE2.IDENTIFIER = H_WAITING_LIST.VISTA_SITE_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS VISTANAME2 ON VISTANAME2.PFK_ORGANIZATION = VISTASITE2.PK_ENTITY
	LEFT JOIN #MY_CONCEPT_H AS WA1 ON WA1.Id = PREVIOUS_H_WAITING_LIST.WAITING_AREA_ID AND WA1.CODE_SYSTEM_NAME = 'WaitingArea'
	LEFT JOIN #MY_CONCEPT_H AS WA2 ON WA2.Id = H_WAITING_LIST.WAITING_AREA_ID AND WA2.CODE_SYSTEM_NAME = 'WaitingArea'
	LEFT JOIN #MY_CONCEPT_H AS FD1 ON FD1.ID = PREVIOUS_H_WAITING_LIST.FEE_DISPOSITION_ID AND FD1.CODE_SYSTEM_NAME = 'FeeDisposition'
	LEFT JOIN #MY_CONCEPT_H AS FD2 ON FD2.ID = H_WAITING_LIST.FEE_DISPOSITION_ID AND FD2.CODE_SYSTEM_NAME = 'FeeDisposition'
	LEFT JOIN #MY_CONCEPT_H AS ED1 ON ED1.ID = PREVIOUS_H_WAITING_LIST.EVACUATION_DISPOSITION_STATUS_ID AND ED1.CODE_SYSTEM_NAME = 'EvacDispositionStatus'	
	LEFT JOIN #MY_CONCEPT_H AS ED2 ON ED2.ID = H_WAITING_LIST.EVACUATION_DISPOSITION_STATUS_ID AND ED2.CODE_SYSTEM_NAME = 'EvacDispositionStatus'	
	LEFT JOIN #MY_CONCEPT_H AS TP1 ON TP1.ID = PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_PROVIDER_ID AND TP1.CODE_SYSTEM_NAME = 'TransportationProvider'
	LEFT JOIN #MY_CONCEPT_H AS TP2 ON TP2.ID = H_WAITING_LIST.EVACUATION_TRANSPORTATION_PROVIDER_ID AND TP2.CODE_SYSTEM_NAME = 'TransportationProvider'
	LEFT JOIN #MY_CONCEPT_H AS TT1 ON TT1.ID = PREVIOUS_H_WAITING_LIST.EVACUATION_TRANSPORTATION_TYPE_ID AND TT1.CODE_SYSTEM_NAME = 'TransportationType'
	LEFT JOIN #MY_CONCEPT_H AS TT2 ON TT2.ID = H_WAITING_LIST.EVACUATION_TRANSPORTATION_TYPE_ID AND TT2.CODE_SYSTEM_NAME = 'TransportationType'
	LEFT JOIN #MY_CONCEPT_H AS FR1 ON FR1.ID = PREVIOUS_H_WAITING_LIST.REASON_USING_FEE_ID AND FR1.CODE_SYSTEM_NAME = 'FeeReason'
	LEFT JOIN #MY_CONCEPT_H AS FR2 ON FR2.ID = H_WAITING_LIST.REASON_USING_FEE_ID AND FR2.CODE_SYSTEM_NAME = 'FeeReason'
	LEFT JOIN #MY_CONCEPT_H AS CF1 ON CF1.ID = PREVIOUS_H_WAITING_LIST.CONTRACT_FEE_ID AND CF1.CODE_SYSTEM_NAME = 'StrictDecision'
	LEFT JOIN #MY_CONCEPT_H AS CF2 ON CF2.ID = H_WAITING_LIST.CONTRACT_FEE_ID AND CF2.CODE_SYSTEM_NAME = 'StrictDecision'
	LEFT JOIN #MY_CONCEPT_H AS AF1 ON AF1.ID = PREVIOUS_H_WAITING_LIST.AUTHORIZED_FEE_ID AND AF1.CODE_SYSTEM_NAME = 'StrictDecision'
	LEFT JOIN #MY_CONCEPT_H AS AF2 ON AF2.ID = H_WAITING_LIST.AUTHORIZED_FEE_ID AND AF2.CODE_SYSTEM_NAME = 'StrictDecision'
	--WHERE H_WAITING_LIST.ACT_ID = 408
    OPTION (MAXDOP 1) 

	DROP TABLE #TRANHISTORY
	DROP TABLE #MY_CONCEPT_H
END
END


GO


