USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_GetAuditReportTypes]    Script Date: 6/14/2016 9:11:19 AM ******/
DROP PROCEDURE [dbo].[usp_Rpt_GetAuditReportTypes]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_GetAuditReportTypes]    Script Date: 6/14/2016 9:11:19 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

--exec usp_Rpt_GetAuditReportTypes 0
CREATE PROCEDURE [dbo].[usp_Rpt_GetAuditReportTypes] 
   @IsFacility int
	
AS
BEGIN
	CREATE TABLE #ReportOptions (
		Label varchar(100),
		Value varchar(100)
	)

IF @IsFacility =1
	BEGIN
		INSERT INTO #ReportOptions SELECT 'Site Configurable Icons', 'FACILITY'
		INSERT INTO #ReportOptions SELECT 'Facility Patients Pending Bed Placement List ', 'WAIT_LIST'
		INSERT INTO #ReportOptions SELECT 'VISN Patients Pending Bed Placement List', 'VISN_WAIT_LIST'
		INSERT INTO #ReportOptions SELECT 'Staff Assignment', 'STAFF'
		INSERT INTO #ReportOptions SELECT 'Whiteboard Usage', 'WhiteBoardUsageAuditLog'
		INSERT INTO #ReportOptions SELECT 'PPBP Usage (VISN)', 'PPBPUsageAuditLog'
		INSERT INTO #ReportOptions SELECT 'PPBP Usage (Facility)', 'PPBPUsageAuditLog_Facility'
		INSERT INTO #ReportOptions SELECT 'Icon Usage', 'IconUsage'
	END

ELSE
	BEGIN
		INSERT INTO #ReportOptions SELECT 'Standard Icons', 'FLAG'
		INSERT INTO #ReportOptions SELECT 'Site Configurable Icons', 'FACILITY'
		INSERT INTO #ReportOptions SELECT 'Facility Patients Pending Bed Placement List ', 'WAIT_LIST'
		INSERT INTO #ReportOptions SELECT 'VISN Patients Pending Bed Placement List', 'VISN_WAIT_LIST'
		INSERT INTO #ReportOptions SELECT 'Staff Assignment', 'STAFF'
		INSERT INTO #ReportOptions SELECT 'Whiteboard Usage', 'WhiteBoardUsageAuditLog'
		INSERT INTO #ReportOptions SELECT 'PPBP Usage (VISN)', 'PPBPUsageAuditLog'
		INSERT INTO #ReportOptions SELECT 'PPBP Usage (Facility)', 'PPBPUsageAuditLog_Facility'
		INSERT INTO #ReportOptions SELECT 'Icon Usage', 'IconUsage'
	END


SELECT * FROM #ReportOptions

DROP TABLE #ReportOptions
END
GO


