USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_DischargeInProgress]    Script Date: 6/14/2016 9:19:46 AM ******/
DROP PROCEDURE [dbo].[usp_Rpt_DischargeInProgress]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_DischargeInProgress]    Script Date: 6/14/2016 9:19:46 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


--exec usp_Rpt_DischargeInProgress @WARDGROUP_ID=-1,@START_DATE='2012-01-21 00:00:00',@END_DATE='2016-03-29 00:00:00',@USER_NAME=N'aac.dva.DNS   \bms_svc_sqa',@FACILITY_EXTENSION=N'69378E0F-B210-493B-B2A1-2130C9F7F394',@TIME_ZONE_MINUTES_OFFSET=0
CREATE PROCEDURE [dbo].[usp_Rpt_DischargeInProgress] 
	@WARDGROUP_ID INT,
	@START_DATE DATETIME,
	@END_DATE DATETIME,
	@USER_NAME NVARCHAR(100)=NULL,
	@FACILITY_EXTENSION NVARCHAR(250),
	@TIME_ZONE_MINUTES_OFFSET INT	
AS
BEGIN

	IF @START_DATE > @END_DATE
		RAISERROR ('The start date is greater than the end date. Please correct.', 18, 13)
	ELSE
	BEGIN
	
	set @START_DATE = DATEADD (minute , -@TIME_ZONE_MINUTES_OFFSET , @START_DATE );
	set @END_DATE = DATEADD (minute , -@TIME_ZONE_MINUTES_OFFSET , @END_DATE );
	-- create permission table
	CREATE TABLE #PERMISSION
        (
         DIM_ORGANIZATION_ID INT,
         DIM_WARD_ID INT
        )
    --insert permission for the user
    INSERT INTO #PERMISSION 
		SELECT * FROM dbo.ufn_GetPermissionByUserName(@USER_NAME)
			CREATE NONCLUSTERED INDEX [DIM_ORGANIZATION_ID] ON #PERMISSION ([DIM_ORGANIZATION_ID] ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON)
			CREATE NONCLUSTERED INDEX DIM_WARD_ID ON #PERMISSION (DIM_WARD_ID ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON) ;
	
	
	
	DECLARE @FACILITY_ID INT
	--get facility id
	SET @FACILITY_ID = dbo.ufn_GetFacilityIdByIdentifier(@FACILITY_EXTENSION);
	
	--check if the user has permission for the facility		
	IF EXISTS(SELECT 1 
			  FROM #PERMISSION
			  WHERE DIM_ORGANIZATION_ID = @FACILITY_ID)
		BEGIN
						
				DECLARE @WARD TABLE(ID INT PRIMARY KEY);
		
			   -- insert wards belonging to @FACILITY_ID 
				IF @WARDGROUP_ID = -1
					INSERT INTO @WARD(ID)
					SELECT WARD.ID FROM dbo.ufn_GetWardsByFacilityId(@FACILITY_ID) as WARD
					INNER JOIN dbo.DIM_WARD AS ACTIVE_WARD ON ACTIVE_WARD.ID = WARD.ID
					WHERE ACTIVE_WARD.STATUS = 'active'
				ELSE
					INSERT INTO @WARD(ID) -- VALUES (@WARD_ID)
					SELECT DIM_WARD_ID FROM dbo.GROUP_WARD_ORGANIZATION GWO
					WHERE DIM_ORGANIZATION_ID = @WARDGROUP_ID

				SELECT WARD.NAME AS WARD_NAME,
					   PATIENT.LAST_NAME + ' ' + RIGHT(PATIENT.SSN,4) as PATIENT_NAME,
					   PHYSICIAN.FULL_NAME AS PHYSICIAN,
					   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, DISCH_REQ.ORDERED_DATE), 101) + ' ' 
					   + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, DISCH_REQ.ORDERED_DATE), 108) AS ORDERED_DATE,
					   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, DISCHARGE.DISCHARGED_DATE), 101) + ' ' 
					   + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, DISCHARGE.DISCHARGED_DATE), 108) AS DISCHARGED_DATE,
					   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, DISCHARGE.ENTERED_DATE), 101) + ' ' 
					   + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, DISCHARGE.ENTERED_DATE), 108) AS ENTERED_DATE,
					   dbo.ufn_GetDateDiff(DISCHARGE.ENTERED_DATE, DISCHARGE.DISCHARGED_DATE) AS DIFF,
					   DATEDIFF(MINUTE,DISCHARGE.ENTERED_DATE, DISCHARGE.DISCHARGED_DATE) AS DIFF_MINUTE,
					   MOVEMENT_TYPE.DISPLAY_NAME AS MOVEMENT_TYPE,
					   --ORDERED_DATE,
					   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, DISCH_REQ.SIGNED_DATE), 101) + ' ' 
					   + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, DISCH_REQ.SIGNED_DATE), 108) AS SIGNED_DATE,
					   dbo.ufn_GetDateDiff(DISCHARGE.ENTERED_DATE, DISCH_REQ.SIGNED_DATE) AS SIGNED_DIFF,
					   DISCH_REQ.ID
				FROM dbo.FACT_DISCHARGE_EVN AS DISCHARGE
					INNER JOIN dbo.DIM_WARD AS WARD ON WARD.ID = DISCHARGE.DIM_WARD_ID
					INNER JOIN dbo.DIM_PATIENT AS PATIENT ON PATIENT.ID = DISCHARGE.DIM_PATIENT_ID					
					LEFT JOIN dbo.DIM_MOVEMENT_TYPE AS MOVEMENT_TYPE ON MOVEMENT_TYPE.ID = DISCHARGE.DIM_MOVEMENT_TYPE_ID
					LEFT JOIN DBO.FACT_DISCHARGE_REQ AS DISCH_REQ ON DISCH_REQ.ID = 
							  (SELECT MAX(ID) AS ID
							   FROM DBO.FACT_DISCHARGE_REQ AS DISCH_REQ 
							   WHERE DISCH_REQ.DIM_PATIENT_ID = DISCHARGE.DIM_PATIENT_ID
							   AND DISCH_REQ.VISTA_SITE_DIM_ORGANIZATION_ID = DISCHARGE.VISTA_SITE_DIM_ORGANIZATION_ID
							   AND ORDERED_DATE BETWEEN @START_DATE AND DATEADD(ms, -3, @END_DATE + 1))  
					LEFT JOIN dbo.DIM_PHYSICIAN AS PHYSICIAN On PHYSICIAN.ID = DISCH_REQ.SIGNED_BY_DIM_PHYSICIAN_ID
						
				WHERE DISCHARGE.ENTERED_DATE BETWEEN @START_DATE AND DATEADD(ms, -3, @END_DATE + 1)
					--AND DISCHARGE.REQ_CANCELED_DATE IS NULL
					AND DISCHARGE.DISCHARGED_DATE IS NOT NULL
					AND DISCHARGE.DIM_WARD_ID IN (SELECT ID FROM @WARD)
		END


	DROP TABLE #PERMISSION		
	
	END
END


GO


