﻿using System.Collections.Generic;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;

namespace BMS.Web.Models
{
    /// <summary>
    /// The Model class for the Home page.
    /// </summary>
    public class ReportsViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the ward group id selected.
        /// </summary>
        /// <value>
        /// The ward group id.
        /// </value>
        public string WardGroup { get; set; }
        /// <summary>
        /// Gets or sets the ward group object selected.
        /// </summary>
        /// <value>
        /// The ward group object selected.
        /// </value>
        public Division WardGroupSelected { get; set; }
        /// <summary>
        /// Gets or sets the ward group list.
        /// </summary>
        /// <value>
        /// The ward group list.
        /// </value>
        public IList<Division> WardGroupList { get; set; }
        /// <summary>
        /// Gets or sets the bed status.
        /// </summary>
        /// <value>
        /// The bed status.
        /// </value>
        public string BedStatus { get; set; }
        /// <summary>
        /// Gets or sets the bed status list.
        /// </summary>
        /// <value>
        /// The bed status list.
        /// </value>
        public CDList BedStatusList { get; set; }
        /// <summary>
        /// Gets or sets the type group.
        /// </summary>
        /// <value>
        /// The type group.
        /// </value>
        public string TypeGroup { get; set; }
        /// <summary>
        /// Gets or sets the type group list.
        /// </summary>
        /// <value>
        /// The type group list.
        /// </value>
        public IList<string> TypeGroupList { get; set; }
        /// <summary>
        /// Gets or sets the view.
        /// </summary>
        /// <value>
        /// The view.
        /// </value>
        public string View { get; set; }
        /// <summary>
        /// Gets or sets the view list.
        /// </summary>
        /// <value>
        /// The view list.
        /// </value>
        public CDList ViewList { get; set; }

        /// <summary>
        /// Gets or sets the days.
        /// </summary>
        /// <value>
        /// The days.
        /// </value>
        public string Days { get; set; }
        /// <summary>
        /// Gets or sets the days list.
        /// </summary>
        /// <value>
        /// The days list.
        /// </value>
        public CDList DaysList { get; set; }
        /// <summary>
        /// Gets or sets the quick date.
        /// </summary>
        /// <value>
        /// The quick date.
        /// </value>
        public string QuickDate { get; set; }
        /// <summary>
        /// Gets or sets the quick date list.
        /// </summary>
        /// <value>
        /// The quick date list.
        /// </value>
        public CDList QuickDateList { get; set; }
        /// <summary>
        /// Gets or sets the transaction bed.
        /// </summary>
        /// <value>
        /// The transaction bed.
        /// </value>
        public string TransactionBed { get; set; }
        /// <summary>
        /// Gets or sets the transaction bed list.
        /// </summary>
        /// <value>
        /// The transaction bed list.
        /// </value>
        public List<CD> TransactionBedList { get; set; }
        /// <summary>
        /// Gets or sets the selected report name.
        /// </summary>
        /// <value>
        /// The name of the selected report.
        /// </value>
        public string SelectedReportName { get; set; }
        /// <summary>
        /// Gets or sets the reports list from the reports drop down.
        /// </summary>
        /// <value>
        /// The reports list.
        /// </value>
        public IList<IReportInfo> ReportsList { get; set; }

        /// <summary>
        /// Gets or sets the BP last ran date time.
        /// </summary>
        /// <value>
        /// The BP last ran date time.
        /// </value>
        public string BPLastRanDateTime { get; set; }

        public bool IsValidDateBPLastRan { get; set; }

        /// <summary>
        /// Gets or sets the reports list.
        /// </summary>
        /// <value>
        /// The reports list.
        /// </value>
        public IList<IReportInfo> ReportsListSecond { get; set; }

        public string WardOperation { get; set; }
        public string BedGroupOperation { get; set; }
        public string AdmissionOperation { get; set; }
        public string MovementOperation { get; set; }
        public string OtherReportsOperation { get; set; }
    }

}
