﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Web.Controllers;
using BMS.Utils;
using System.ComponentModel.DataAnnotations;

namespace BMS.Web.Models
{
    /// <summary>
    /// Add/Edit User Model class.
    /// </summary>
    public class AdminUserAddEditViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the regions.
        /// </summary>
        /// <value>
        /// The regions.
        /// </value>
        public IList<Region> Regions { get; set; }

        /// <summary>
        /// Gets or sets the region id.
        /// </summary>
        /// <value>
        /// The region id.
        /// </value>
        [Required(ErrorMessage = "The DefaultRegion field is required.")]
        public string RegionId { get; set; }

        /// <summary>
        /// Gets or sets the visns.
        /// </summary>
        /// <value>
        /// The visns.
        /// </value>
        public IList<Visn> Visns { get; set; }

        /// <summary>
        /// Gets or sets the visn id.
        /// </summary>
        /// <value>
        /// The visn id.
        /// </value>
        [Required(ErrorMessage = "The DefaultVisn field is required.")]
        public string VisnId { get; set; }

        /// <summary>
        /// Gets or sets the facilities.
        /// </summary>
        /// <value>
        /// The facilities.
        /// </value>
        public IList<Site> Facilities { get; set; }

        /// <summary>
        /// Gets or sets the facility id.
        /// </summary>
        /// <value>
        /// The facility id.
        /// </value>
        [Required(ErrorMessage = "The DefaultSite field is required.")]
        public string FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the yes/no values.
        /// </summary>
        /// <value>
        /// A list of codes.
        /// </value>
        public IList<CD> StrictDecisions { get; set; }


        /// <summary>
        /// The data model. 
        /// </summary>
        /// <value>An user.</value>
        public User Data { get; set; }

        public bool IsDefaultUser
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return Data.UserName.Equals(Constants.DEFAULT_USER_PROFILE, StringComparison.InvariantCultureIgnoreCase);
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets a value indicating whether [display only selected facilities].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [display only selected facilities]; otherwise, <c>false</c>.
        /// </value>
        public bool DisplayOnlySelectedFacilities { get; set; }

        /// <summary>
        /// Gets or sets the permissions facilities.
        /// </summary>
        /// <value>
        /// The permissions facilities.
        /// </value>
        public List<PermissionFacility> PermissionsFacilities { get; set; }

        /// <summary>
        /// Gets or sets the fill controls.
        /// </summary>
        /// <value>
        /// The fill controls.
        /// </value>
        public string FillControls { get; set; }

        /// <summary>
        /// Gets or sets the button read access.
        /// </summary>
        /// <value>
        /// The button read access.
        /// </value>
        public string ButtonReadAccess { get; set; }

        /// <summary>
        /// Gets or sets the button write access.
        /// </summary>
        /// <value>
        /// The button write access.
        /// </value>
        public string ButtonWriteAccess { get; set; }

        /// <summary>
        /// Gets or sets the button cancel.
        /// </summary>
        /// <value>
        /// The button cancel.
        /// </value>
        public string ButtonCancel { get; set; }

        /// <summary>
        /// Gets or sets the button return to menu.
        /// </summary>
        /// <value>
        /// The button return to menu.
        /// </value>
        public string ButtonReturnToMenu { get; set; }

        /// <summary>
        /// Gets or sets the button logout.
        /// </summary>
        /// <value>
        /// The button logout.
        /// </value>
        public string ButtonLogout { get; set; }

        /// <summary>
        /// Gets or sets the button return to regional.
        /// </summary>
        /// <value>
        /// The button return to regional.
        /// </value>
        public string ButtonReturnToRegional { get; set; }
    }

    public class Site
    {
        public II Id { get; set; }
        public string Name { get; set; }
    }
}