﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using InfoWorld.EVS.CTSMAPI;
using BMS.Utils;
using System.ComponentModel.DataAnnotations;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    public class AdminSpecialtyAssociationViewModel : BaseViewModel
    {
        public List<CD> NUMAList { get; set; }

        public List<CD> HAvBEDList { get; set; }

        public List<CDWithProperties> SpecialtyList 
        {
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    SpecialtyListExtended = new List<SpecialtyItemViewModel>();
                    string _numa = string.Empty;
                    string _havBed = string.Empty;
                    // generate the extended specialty list(with numa and havBed properties).
                    if (value != null)
                    {
                        ConceptProperty numaProp = null;
                        ConceptProperty havBedProp = null;
                        foreach (CDWithProperties item in value)
                        {
                            _numa = string.Empty;
                            _havBed = string.Empty;
                            if (item.Properties != null)
                            {
                                numaProp = item.Properties.SingleOrDefault(a => a.PropertyName.text == Constants.NUMA);
                                if (numaProp != null)
                                    _numa = NUMAList.SingleOrDefault(cp => cp.code == item.Properties.SingleOrDefault(a => a.PropertyName.text == Constants.NUMA).PropertyValue.text).displayName;                                
                                havBedProp = item.Properties.SingleOrDefault(a => a.PropertyName.text == Constants.HAvBED);
                                if (havBedProp != null)
                                    _havBed = HAvBEDList.SingleOrDefault(cp => cp.code == item.Properties.SingleOrDefault(a => a.PropertyName.text == Constants.HAvBED).PropertyValue.text).displayName;                                
                            }
                            SpecialtyListExtended.Add(new SpecialtyItemViewModel() { Specialty = item, NUMA = _numa, HAvBED = _havBed });
                        }
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        public List<SpecialtyItemViewModel> SpecialtyListExtended { get; set; }

        [Required(ErrorMessage = "NUMA field is required!")]
        [ValidateXss]
        public string NUMAName { get; set; }

        public string NUMACode { get; set; }

        [Required(ErrorMessage = "HAvBED field is required!")]
        [ValidateXss]
        public string HAvBEDName { get; set; }

        public string HAvBEDCode { get; set; }

        [Required(ErrorMessage = "Vista Specialty field is required!")]        
        public string SpecialtyName { get; set; }

        public string SpecialtyCode { get; set; }

        public string NUMASelected { get; set; }

        public string HAvBEDSelected { get; set; }

        public string ButtonSaveNUMA { get; set; }

        public string ButtonSaveHAvBED { get; set; }

        public string ButtonSaveSpecialty { get; set; }

        public string CodeToDelete { get; set; }

        public string DisplayNameToDelete { get; set; }

        public string VocabularyDomainToDelete { get; set; }
    }

    public class SpecialtyItemViewModel
    {
        public CDWithProperties Specialty { get; set; }

        public string NUMA { get; set; }

        public string HAvBED { get; set; }
    }
}