﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.Security.Application;
using System.ComponentModel;
using System.Web.Util;

namespace BMS.Web.Controllers.Shared
{
    public class XssModelBinder : DefaultModelBinder
    {
        AntiXssEncoder xss = new AntiXssEncoder();

        public override object BindModel(ControllerContext controllerContext, ModelBindingContext bindingContext)
        {
            ValueProviderResult valueResult = bindingContext.ValueProvider.GetValue(bindingContext.ModelName);

            if (valueResult != null && !string.IsNullOrEmpty(valueResult.AttemptedValue))
            {
                if (bindingContext.ModelMetadata.AdditionalValues.ContainsKey("AddXssKey"))
                    return Encoder.HtmlEncode(valueResult.AttemptedValue);
            }
            return base.BindModel(controllerContext, bindingContext);
        }        
    }
}