﻿(function ($) {
    $.getAntiForgeryToken = function () {
        // HtmlHelper.AntiForgeryToken() must be invoked to print the token.
        //tokenWindow = tokenWindow && typeof tokenWindow === typeof window ? tokenWindow : window;

        var tokenName = "__RequestVerificationToken";
        var token = $('[name=__RequestVerificationToken]').val();

        return token;

        // Finds the <input type="hidden" name={tokenName} value="..." /> from the specified window.        
        //var inputElements = tokenWindow.document.getElementsByTagName("input");
        //for (var i = 0; i < inputElements.length; i++) {
        //    var inputElement = inputElements[i];
        //    if (inputElement.type === "hidden" && inputElement.name === tokenName) {
        //        return {
        //            name: tokenName,
        //            value: inputElement.value
        //        };
        //    }
        //}
    };

    $.appendAntiForgeryToken = function (data, token) {
        // Converts data if not already a string.
        if (data && typeof data !== "string") {
            data = $.param(data);
        }

        // Gets token from current window by default.
        token = token ? token : $.getAntiForgeryToken(); // $.getAntiForgeryToken(window).

        data = data ? data + "&" : "";
        // If token exists, appends {token.name}={token.value} to data.
        return token ? data + encodeURIComponent(token.name) + "=" + encodeURIComponent(token.value) : data;
    };

    // Wraps $.post(url, data, callback, type) for most common scenarios.
    $.postAntiForgery = function (url, data, callback, type) {
        return $.ajaxAntiForgery({
            url: url,
            type: 'POST',
            data: data,
            complete: callback,
            dataType: type
        });
    };

    // Wraps $.ajax(settings).
    $.ajaxAntiForgery = function (settings) {
        // Supports more options than $.ajax(): 
        // settings.token, settings.tokenWindow, settings.appPath.        
        var token = settings.token ? settings.token : $.getAntiForgeryToken();        
        settings.headers = { "__RequestVerificationToken": token };
        //settings.data = $.appendAntiForgeryToken(settings.data, token);
        
        return $.ajax(settings);
    };
})(jQuery);