﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using BMS.Web.Models;
using BMS.Utils;
using BMS.Web.App_GlobalResource;
using BMS.Facade;
using BMS.Facade.Data;
using System.Configuration;
using InfoWorld.HL7.ITS;
using System.Text;
using System.Reflection;
using System.IO;
using BMS.Web.Controllers;
using System.Security;
using System.Security.Permissions;
using InfoWorld.EVS.CTSMAPI;

namespace BMS.Web.Reporting
{
    public partial class LocalReportViewer : System.Web.UI.Page
    {
        User loggedUser;
        Dictionary<string, string> QueryStrings;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (this.IsPostBack)
            {
                ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "key", "ResizeForm();", true);

            }
            
            PermissionSet permissions = new PermissionSet(PermissionState.Unrestricted); 
            rvLocal.LocalReport.SetBasePermissionsForSandboxAppDomain(permissions);

            facilityHomeLink.Text = Strings.BMS_Home;
            iconsHomeLink.Text = Strings.IconLegend;
            informationHomeLink.Text = Strings.Information;

            if (Request == null || Request.QueryString == null || Request.QueryString.Count == 0)
                return;

            loggedUser = FacadeManager.UserInterface.GetProfile();

            string previousPage = Request.QueryString[0].Substring(Request.QueryString[0].LastIndexOf('*'));
            string token = Request.QueryString[0].Substring(0, Request.QueryString[0].LastIndexOf('*'));
            if (previousPage.Equals("*ww"))
            {
                GetUrlParameters(token);
                divWhiteboardTitle.Style.Add("display", "block");
                divWardOccupancyTitle.Style.Add("display", "none");
                reportName.Style.Add("display", "none");
                reportName.InnerText = "Ward Whiteboard Report";
                homeLink.Text = BMS.Web.App_GlobalResource.Strings.ReturnToWardWhiteboard;
                ReportDataSource reportDataSource = new ReportDataSource("DataSet1", FillDataSourceForWhiteboard());
                rvLocal.LocalReport.DataSources.Add(reportDataSource);
                string theDirectory = Path.GetDirectoryName(new Uri(Assembly.GetExecutingAssembly().CodeBase).LocalPath);
                rvLocal.LocalReport.ReportPath = theDirectory + @"\LocalReportWhiteboard\WardWhiteboard.rdlc";
            }
            else if (previousPage.Equals("*bs"))
            {
                GetBedStatusReportUrlParameters(token);
                divWhiteboardTitle.Style.Add("display", "none");
                divWardOccupancyTitle.Style.Add("display", "none");
                reportName.Style.Add("display", "block");
                reportName.InnerText = Strings.BedStatusReportTitle; //"Wait Bed Status Report";
                homeLink.Text = BMS.Web.App_GlobalResource.Strings.ReturnToBedStatusPage;
                ReportDataSource reportDataSource = new ReportDataSource("DataSet1", FillDataSourceForBedStatus(loggedUser));
                rvLocal.LocalReport.DataSources.Add(reportDataSource);
                rvLocal.LocalReport.ReportPath = Server.MapPath("~/ReportsLocal/BedStatusReport.rdlc");
            }
            else if (previousPage.Equals("*wo"))
            {
                GetUrlParameters(token);
                divWhiteboardTitle.Style.Add("display", "none");
                divWardOccupancyTitle.Style.Add("display", "block");
                reportName.Style.Add("display", "none");
                reportName.InnerText = "Ward Occupancy Report";
                homeLink.Text = BMS.Web.App_GlobalResource.Strings.ReturnToWardOccupancy;
                ReportDataSource reportDataSource = new ReportDataSource("DataSet1", FillDataSourceForWardOccupancy(loggedUser));
                rvLocal.LocalReport.DataSources.Add(reportDataSource);
                rvLocal.LocalReport.ReportPath = Server.MapPath("~/ReportsLocal/WardOccupancy.rdlc");
            }
            else if (previousPage.Equals("*fd"))
            {
                GetUrlParameters(token);
                divWhiteboardTitle.Style.Add("display", "none");
                divWardOccupancyTitle.Style.Add("display", "none");
                reportName.Style.Add("display", "block");
                string currentButton = QueryStrings["currentButton"];
                reportName.InnerText = (currentButton == Strings.AllDiversions) ? Strings.AllDiversions : Strings.CurrentDiversions;
                homeLink.Text = BMS.Web.App_GlobalResource.Strings.ReturntoDiversionPage;
                ReportDataSource reportDataSource = new ReportDataSource("DataSet1", FillDataSourceForFacilityDiversions());
                rvLocal.LocalReport.DataSources.Add(reportDataSource);
                rvLocal.LocalReport.ReportPath = Server.MapPath("~/ReportsLocal/FacilityDiversions.rdlc");
                ReportParameter[] parameters = new ReportParameter[1];
                parameters[0] = new ReportParameter("IsCurrentDiversions", (currentButton == Strings.AllDiversions) ? "false" : "true", false);
                rvLocal.LocalReport.SetParameters(parameters);
                rvLocal.LocalReport.Refresh();

            }
        }

        #region Facility Diversion  Report

        public List<DiversionViewModel> FillDataSourceForFacilityDiversions()
        {
            if (QueryStrings["currentButton"] == Strings.AllDiversions)
                return FacadeManager.DiversionInterface.GetDiversions(this.loggedUser.Facility.Id).Select(d => DiversionViewModel.GetViewModel(d, BaseController.DateTimeNowOnCurrentFacility)).OrderByDescending(fdvm => fdvm.Status)
                                                                            .ThenByDescending(fdvm => fdvm.StartDateTime)
                                                                            .ToList();
            else
                return FacadeManager.DiversionInterface.GetDiversions(this.loggedUser.Facility.Id).Select(d => DiversionViewModel.GetViewModel(d, BaseController.DateTimeNowOnCurrentFacility)).Where(fdvm => fdvm.Status == Constants.Yes && fdvm.StartDateTime != null)
                                                                               .OrderBy(fdvm => fdvm.StartDateTime)
                                                                               .ToList();
        }

        #endregion

        #region WardWhiteboard Report Private Methods

        private List<WhiteboardBedInfo> FillDataSourceForWhiteboard()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WardWhiteboardViewModel wardWhiteboardVM = new WardWhiteboardViewModel();
                FillViewModel(wardWhiteboardVM);

                string genderColorCode = QueryStrings["genderColorCode"];
                string displayPTCode = QueryStrings["displayPTCode"];
                string sortBy = QueryStrings["sortBy"];
                string displayStaffAttending = QueryStrings["displayStaffAttending"];
                lblFacilityCode.Text = QueryStrings["facilityCode"];

                if (!string.IsNullOrEmpty(QueryStrings["divisionId"]))
                    wardWhiteboardVM.DivisionExtension = QueryStrings["divisionId"];

                wardWhiteboardVM.GenderColorCode = genderColorCode ?? wardWhiteboardVM.GenderColorList.First().code;
                wardWhiteboardVM.DisplayPTCode = displayPTCode ?? wardWhiteboardVM.DisplayPTList.First().code;

                wardWhiteboardVM.DisplayPT = wardWhiteboardVM.DisplayPTList.First(cd => wardWhiteboardVM.DisplayPTCode == cd.code).displayName;
                wardWhiteboardVM.GenderColor = wardWhiteboardVM.GenderColorList.First(cd => wardWhiteboardVM.GenderColorCode == cd.code).displayName;
                wardWhiteboardVM.DisplayStaffAttendingSelected = displayStaffAttending;
                SetSortBySelected(wardWhiteboardVM, sortBy);

                SetWardSelected(wardWhiteboardVM);
                wardWhiteboardVM.IconFlagsList = FacadeManager.IconInterface.GetAllIconsByFacility(Guid.Parse(this.loggedUser.Facility.Id.extension)).Where(a => a.Active == true).ToList();

                if (wardWhiteboardVM.SelectedDivision == null)
                {
                    wardWhiteboardVM.SelectedDivision = wardWhiteboardVM.DivisionList[0];
                    wardWhiteboardVM.DivisionExtension = wardWhiteboardVM.SelectedDivision.Id.extension;
                    wardWhiteboardVM.DivisionName = wardWhiteboardVM.SelectedDivision.Name;
                }

                lblSelectedDivisionName.Text = wardWhiteboardVM.SelectedDivision.Name;
                lblFacilitySiteCodeTimeZone.Text = wardWhiteboardVM.FacilitySiteCodeTimeZone;
                lblLastUpdatedDate.Text = wardWhiteboardVM.LastUpdatedDate;

                List<Ward> wards = FacadeManager.EntityInterface.GetWardsByFacility(this.loggedUser.Facility.Id).ToList();

                //if we don't have a WardId we select the 1st one in the list
                if (string.IsNullOrEmpty(wardWhiteboardVM.DivisionExtension) && wardWhiteboardVM.DivisionList != null && wardWhiteboardVM.DivisionList.Count > 0)
                    wardWhiteboardVM.DivisionExtension = wardWhiteboardVM.DivisionList[0].Id.extension;

                bool allDivisionsSelected = true;
                II selectedDivision = new II("", (default(Guid)).ToString());
                if (wardWhiteboardVM.SelectedDivision != null && wardWhiteboardVM.SelectedDivision.Id != null && !wardWhiteboardVM.SelectedDivision.Id.extension.Equals((default(Guid)).ToString()))
                {
                    selectedDivision = wardWhiteboardVM.SelectedDivision.Id;
                    allDivisionsSelected = false;
                }

                var beds = FacadeManager.BedInterface.GetBedOccupancy(wards, new II("", (default(Guid)).ToString()), this.loggedUser.Facility, null, true, wardWhiteboardVM.SortBySelected);
                var divisionBeds = allDivisionsSelected ? beds : (from bed in beds
                                                                  where (bed.DivisionList.Where(a => a.Id.extension.Equals(selectedDivision.extension, StringComparison.InvariantCultureIgnoreCase) && a.Id.root.Equals(selectedDivision.root, StringComparison.InvariantCultureIgnoreCase)).Count() > 0)
                                                                  select bed).ToList();

                Dictionary<string, SpecialtiesHidden> specialtiesHidden = FacadeManager.VocabularyInterface.GetHiddenVistaSpecialties(wards);

                return WhiteboardBedInfo.GetWhiteboardData(wardWhiteboardVM.IconFlagsList, wardWhiteboardVM.GenderColorCode, wardWhiteboardVM.DisplayPTCode, wardWhiteboardVM.DisplayStaffAttendingSelected, divisionBeds, true, wards, specialtiesHidden, false);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Fills the WardWhiteboardViewModel with data from Facade.
        /// </summary>
        /// <param name="wm">The ward whiteboard model.</param>
        private void FillViewModel(WardWhiteboardViewModel wm)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                wm.DivisionList = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id).OrderBy(a => a.Name).ToList();
                wm.StrictDecisionList = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.StrictDecision);
                wm.DisplayPTList = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.PTDisplay);
                wm.GenderColorList = FacadeManager.VocabularyInterface.GetVocabulary(Facade.Data.Util.Vocabulary.GenderColor);
                wm.WhiteboardList = new List<WhiteboardBedInfo>();

                //Insert default value for drop down list (Ward )
                wm.DivisionList.Insert(0, new Division() { Id = new II() { root = this.loggedUser.Domain, extension = (default(Guid)).ToString() }, Name = Strings.All });
                FacilitySettings facilitySettings = FacadeManager.ConfigurationInterface.GetFacilitySettings(this.loggedUser.Facility.Id);

                DateTime lastDate = TimeZoneInfo.ConvertTime(DateTime.UtcNow, FacadeUtil.GetFacilityTimeZoneInfo(this.loggedUser.Facility.Id));
                wm.LastUpdatedDate = string.Format("{0} {1} {2}", lastDate.ToString(Strings.USDate), Strings.At, lastDate.ToString("HH:mm"));
                if (facilitySettings != null && facilitySettings.FacilitySiteTimeZone != null)
                    wm.FacilitySiteCodeTimeZone = string.Format("({0})", facilitySettings.FacilitySiteTimeZone.code);
                else
                    wm.FacilitySiteCodeTimeZone = string.Empty;                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Sets the sort by selected.
        /// </summary>
        /// <param name="wardWhiteboardVM">The ward whiteboard VM.</param>
        private void SetSortBySelected(WardWhiteboardViewModel wardWhiteboardVM, string sortBy)
        {
            if (string.IsNullOrEmpty(sortBy))
            {
                wardWhiteboardVM.SortBySelected = null;
                return;
            }
            if (sortBy.Equals(Constants.SORT_BY_STAFF_OR_ATTENDING_ASCENDING))
            {
                switch (wardWhiteboardVM.DisplayStaffAttendingSelected)
                {
                    case Constants.STAFF:
                    case Constants.STAFF_ATTENDING:
                        wardWhiteboardVM.SortBySelected = Constants.SORT_BY_STAFF_ASCENDING;
                        break;
                    case Constants.ATTENDING:
                        wardWhiteboardVM.SortBySelected = Constants.SORT_BY_ATTENDING_ASCENDING;
                        break;
                }
            }
            else if (sortBy.Equals(Constants.SORT_BY_STAFF_OR_ATTENDING_DESCENDING))
            {
                switch (wardWhiteboardVM.DisplayStaffAttendingSelected)
                {
                    case Constants.STAFF:
                    case Constants.STAFF_ATTENDING:
                        wardWhiteboardVM.SortBySelected = Constants.SORT_BY_STAFF_DESCENDING;
                        break;
                    case Constants.ATTENDING:
                        wardWhiteboardVM.SortBySelected = Constants.SORT_BY_ATTENDING_DESCENDING;
                        break;
                }
            }
            else
                wardWhiteboardVM.SortBySelected = sortBy;
        }

        private void SetWardSelected(WardWhiteboardViewModel viewModel)
        {
            if (viewModel.DivisionList == null)
            {
                if (viewModel.LoggedUser == null)
                    viewModel.LoggedUser = FacadeManager.UserInterface.GetProfile();
                viewModel.DivisionList = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id);
            }
            foreach (Division division in viewModel.DivisionList)
            {
                if (division.Id.extension.Equals(viewModel.DivisionExtension, StringComparison.InvariantCultureIgnoreCase) || division.Name == viewModel.DivisionName)
                {
                    viewModel.SelectedDivision = division;
                    viewModel.DivisionExtension = division.Id.extension;
                    break;
                }
            }
        }

        #endregion

        #region Bed Status Report Private Methods

        private List<BedStatusReport> FillDataSourceForBedStatus(User loggedUser)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string[] displayFields = QueryStrings["displayFields"].Split('*');
                string[] filterFields = null;
                if (!string.IsNullOrEmpty(QueryStrings["filterFields"]))
                    filterFields = QueryStrings["filterFields"].Split('*');
                string filterParam = GetBedStatusFilterParam(filterFields);
                string filterPatientName = string.Empty;
                if (!string.IsNullOrEmpty(QueryStrings["filterPatientName"]))
                    filterPatientName = QueryStrings["filterPatientName"];
                string filterGender = string.Empty;
                if (!string.IsNullOrEmpty(QueryStrings["filterGender"]))
                    filterGender = QueryStrings["filterGender"];
                return BedStatusReport.GetViewModel(loggedUser.Facility.Id, filterParam, displayFields, filterPatientName, filterGender);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private string GetBedStatusFilterParam(string[] filterFields)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                StringBuilder filterParam = new StringBuilder();
                if (filterFields != null && filterFields.Length > 0)
                {
                    filterParam.Append(" WHERE ");
                    for (int i = 0; i < filterFields.Length - 1; i = i + 2)
                    {
                        switch (filterFields[i])
                        {
                            case Constants.EVENT_TIME_FIELD:
                                filterParam.Append(Constants.EVENT_TIME_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.BETWEEN);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                filterParam.Append(" AND ");
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 2]);
                                filterParam.Append("' ");
                                i = i + 2;
                                break;
                            case Constants.REQUEST_DT_FIELD:
                                filterParam.Append(Constants.REQUEST_DT_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.BETWEEN);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                filterParam.Append(" AND ");
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 2]);
                                filterParam.Append("' ");
                                i = i + 2;
                                break;
                            case Constants.REMOVE_FROM_LIST_FIELD:
                                if (filterFields[i + 3] == Constants.ACTIVE)
                                {
                                    filterParam.Append(Constants.REMOVE_FROM_LIST_FIELD_SQL);
                                    filterParam.Append(" IS NULL ");
                                }
                                else if (filterFields[i + 3] == Constants.Removed)
                                {
                                    if (!string.IsNullOrEmpty(filterFields[i + 1]) && !string.IsNullOrEmpty(filterFields[i + 2]))
                                    {
                                        filterParam.Append(Constants.REMOVE_FROM_LIST_FIELD_SQL);
                                        filterParam.Append(" ");
                                        filterParam.Append(Constants.BETWEEN);
                                        filterParam.Append(" '");
                                        filterParam.Append(filterFields[i + 1]);
                                        filterParam.Append("' ");
                                        filterParam.Append(" AND ");
                                        filterParam.Append(" '");
                                        filterParam.Append(filterFields[i + 2]);
                                        filterParam.Append("' ");
                                    }
                                    else
                                    {
                                        filterParam.Append(Constants.REMOVE_FROM_LIST_FIELD_SQL);
                                        filterParam.Append(" IS NOT NULL ");
                                    }
                                }
                                else
                                {
                                    if (!string.IsNullOrEmpty(filterFields[i + 1]) && !string.IsNullOrEmpty(filterFields[i + 2]))
                                    {
                                        filterParam.Append(" (");
                                        filterParam.Append(Constants.REMOVE_FROM_LIST_FIELD_SQL);
                                        filterParam.Append(" IS NULL OR ");
                                        filterParam.Append(Constants.REMOVE_FROM_LIST_FIELD_SQL);
                                        filterParam.Append(" ");
                                        filterParam.Append(Constants.BETWEEN);
                                        filterParam.Append(" '");
                                        filterParam.Append(filterFields[i + 1]);
                                        filterParam.Append("' ");
                                        filterParam.Append(" AND ");
                                        filterParam.Append(" '");
                                        filterParam.Append(filterFields[i + 2]);
                                        filterParam.Append("' ");
                                        filterParam.Append(") ");
                                    }
                                    else
                                    {
                                        if (filterParam.Length > 0)
                                            filterParam.Remove(filterParam.Length - 5, 5);
                                    }
                                }
                                i = i + 2;
                                break;
                            case Constants.CURRENT_WAIT_AREA_FIELD:
                                filterParam.Append(Constants.CURRENT_WAIT_AREA_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                break;                            
                            case Constants.COMMUNITY_SERVICES_FIELD:
                                filterParam.Append(Constants.COMMUNITY_SERVICES_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                break;
                            case Constants.CONTRACTED_FIELD:
                                filterParam.Append(Constants.CONTRACTED_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                break;
                            case Constants.REASON_USING_FEE_FIELD:
                                filterParam.Append(Constants.REASON_USING_FEE_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                break;
                            case Constants.ACUTE_FIELD:
                                filterParam.Append(Constants.ACUTE_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                break;
                            case Constants.AUTHORIZED_FEE_FIELD:
                                filterParam.Append(Constants.AUTHORIZED_FEE_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                break;
                            case Constants.IN_HOUSE_TRANSFER_FIELD:
                                filterParam.Append(Constants.IN_HOUSE_TRANSFER_FIELD_SQL);
                                filterParam.Append(" = ");
                                if (filterFields[i + 1] == Constants.Yes)
                                    filterParam.Append("1 ");
                                else
                                    filterParam.Append("0 ");
                                break;
                            case Constants.DATE_TIME_BED_REQUEST_FIELD:
                                filterParam.Append(Constants.DATE_TIME_BED_REQUEST_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.BETWEEN);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                filterParam.Append(" AND ");
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 2]);
                                filterParam.Append("' ");
                                i = i + 2;
                                break;
                            case Constants.DATE_TIME_BED_ASSIGNED_FIELD:
                                filterParam.Append(Constants.DATE_TIME_BED_ASSIGNED_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.BETWEEN);
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                filterParam.Append(" AND ");
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 2]);
                                filterParam.Append("' ");
                                i = i + 2;
                                break;
                            case Constants.FEE_COMMENTS_FIELD:
                                filterParam.Append(Constants.FEE_COMMENTS_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '%");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("%' ");
                                break;
                            case Constants.ROOM_BED_ASSIGNED_FIELD:
                                filterParam.Append(Constants.ROOM_BED_ASSIGNED_FIELD_SQL);
                                filterParam.Append(" = ");
                                filterParam.Append(" '");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("' ");
                                break;
                            case Constants.TYPE_OF_BED_WARD_REQUIRED_FIELD:
                                filterParam.Append(Constants.TYPE_OF_BED_WARD_REQUIRED_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '%");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("%' ");
                                break;
                            case Constants.PRESENTING_PROBLEM_FIELD:
                                filterParam.Append(Constants.PRESENTING_PROBLEM_FIELD_SQL);
                                filterParam.Append(" ");
                                filterParam.Append(Constants.LIKE);
                                filterParam.Append(" '%");
                                filterParam.Append(filterFields[i + 1]);
                                filterParam.Append("%' ");
                                break;
                        }
                        filterParam.Append(" AND ");
                    }
                    if (filterParam.Length > 0)
                        filterParam.Remove(filterParam.Length - 5, 5);
                }
                return filterParam.ToString();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        #region WardOccupancy Report Private Methods

        private List<WardOccupancyBedViewModel> FillDataSourceForWardOccupancy(User loggedUser)
        {
            WardOccupancyViewModel wardOccupancyModel = new WardOccupancyViewModel();
            Division division = null;
            if (string.IsNullOrEmpty(QueryStrings["divisionId"]) || QueryStrings["divisionId"].Equals(Guid.Empty.ToString()))
                division = new Division() { Name = Strings.All, Id = new II(loggedUser.Domain, Guid.Empty.ToString()) };
            else
                division = FacadeManager.EntityInterface.GetDivisionById(new II(loggedUser.Domain, QueryStrings["divisionId"]));
            wardOccupancyModel.Division = division.Name;
            wardOccupancyModel.ExtensionDivisionId = division.Id.extension;
            wardOccupancyModel.RootDivisionId = loggedUser.Domain;
            wardOccupancyModel.BedStatusCode = QueryStrings["bedStatusCode"];
            lblOccupancySelectedDivision.Text = wardOccupancyModel.Division;

            Division selectedDivision = new Division() { Name = wardOccupancyModel.Division, Id = new II() { extension = wardOccupancyModel.ExtensionDivisionId, root = wardOccupancyModel.RootDivisionId } };
            wardOccupancyModel.IsFromSummaryReport = false;
            FacilitySettings facilitySettings = FacadeManager.ConfigurationInterface.GetFacilitySettings(loggedUser.Facility.Id);

            DateTime lastDate = TimeZoneInfo.ConvertTime(DateTime.UtcNow, FacadeUtil.GetFacilityTimeZoneInfo(loggedUser.Facility.Id));
            wardOccupancyModel.LastUpdatedDate = string.Format("{0} {1} {2}", lastDate.ToString(Strings.USDate), Strings.At, lastDate.ToString("HH:mm"));
            if (facilitySettings != null && facilitySettings.FacilitySiteTimeZone != null)
                wardOccupancyModel.FacilitySiteCodeTimeZone = string.Format("({0})", facilitySettings.FacilitySiteTimeZone.code);
            else
                wardOccupancyModel.FacilitySiteCodeTimeZone = string.Empty;            
            
            lblOccupancyLastUpdate.Text = wardOccupancyModel.LastUpdatedDate;
            lblOccupancyTimeZone.Text = wardOccupancyModel.FacilitySiteCodeTimeZone;

            string wardIdList = string.Empty;
            List<Ward> wards = new List<Ward>();
            if (selectedDivision != null && selectedDivision.Id != null && !selectedDivision.Id.extension.Equals((default(Guid)).ToString()))
                wards = FacadeManager.EntityInterface.GetWardsByDivisionId(selectedDivision.Id).ToList();
            else
                wards = FacadeManager.EntityInterface.GetWardsByFacility(this.loggedUser.Facility.Id).ToList();

            var beds = FacadeManager.BedInterface.GetBedOccupancy(wards, selectedDivision.Id, this.loggedUser.Facility, new CD { code = wardOccupancyModel.BedStatusCode }, false, null);
            wardOccupancyModel.IconFlagsList = FacadeManager.IconInterface.GetAllIconsByFacility(Guid.Parse(this.loggedUser.Facility.Id.extension)).Where(a => a.Active == true).ToList();
            wardOccupancyModel.BedInfoList = WardOccupancyBedViewModel.GetViewModel(wardOccupancyModel, beds);
            return wardOccupancyModel.BedInfoList.ToList();
        }

        #endregion

        private void GetUrlParameters(string token)
        {
            QueryStrings = new Dictionary<string, string>();            
            token = CustomEncryption.Decrypt(token, loggedUser.Salt);
            string[] parameters = token.Split('&');
            foreach (string p in parameters)
                QueryStrings.Add(p.Substring(0, p.IndexOf('=')), p.Substring(p.IndexOf('=') + 1));            
        }

        private void GetBedStatusReportUrlParameters(string token)
        {
            QueryStrings = new Dictionary<string, string>();            
            token = CustomEncryption.Decrypt(token, loggedUser.Salt);
            QueryStrings.Add("displayFields", token.Substring(14, token.IndexOf("&filterFields") - 14));
            string part = token.Substring(token.IndexOf("&filterFields=") + 14);
            QueryStrings.Add("filterFields", part.Substring(0, part.IndexOf("&filterPatientName")));
            part = part.Substring(part.IndexOf("&filterPatientName=") + 19);
            QueryStrings.Add("filterPatientName", part.Substring(0, part.IndexOf("&filterGender")));
            QueryStrings.Add("filterGender", part.Substring(part.IndexOf("&filterGender=") + 14));
        }

        protected void OnError(String message)
        {
            Session[Constants.REPORTS_ERROR_MESSAGE_SESSION_KEY] = message;
            Response.Redirect("ReportError.aspx");
        }

        protected void ReportViewerControl_ReportError(object sender, ReportErrorEventArgs e)
        {
            if (e.Exception != null &&
                e.Exception.InnerException != null &&
                e.Exception.InnerException.InnerException != null)
            {
                e.Handled = true;
                OnError(e.Exception.InnerException.InnerException.Message);
            }

        }
    }
}
