﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using BMS.Utils;
using InfoWorld.HL7.ITS;

namespace BMS.Web.Models
{
    public class UserConfigurationViewModel : BaseViewModel
    {
        /// <summary>
        /// The data model. 
        /// </summary>
        /// <value>An user.</value>
        public User Data { get; set; }

        /// <summary>
        /// Gets or sets the region no.
        /// </summary>
        /// <value>
        /// The region no.
        /// </value>
        public string RegionNo { get; set; }

        /// <summary>
        /// Gets or sets the VISN no.
        /// </summary>
        /// <value>
        /// The VISN no.
        /// </value>
        public string VISNNo { get; set; }

        /// <summary>
        /// Gets or sets the name of the site.
        /// </summary>
        /// <value>
        /// The name of the site.
        /// </value>
        public string SiteName { get; set; }

        /// <summary>
        /// Gets a value indicating whether this instance is default user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is default user; otherwise, <c>false</c>.
        /// </value>
        public bool IsDefaultUser
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return Data.UserName.Equals(Constants.DEFAULT_USER_PROFILE, StringComparison.InvariantCultureIgnoreCase);
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the yes/no values.
        /// </summary>
        /// <value>
        /// A list of codes.
        /// </value>
        public IList<CD> StrictDecisions { get; set; }

        public string UserAccessReportLink { get; set; }

        public string BulkUserIds { get; set; }
        public List<string> BulkRevokeUsers { get; set; }
    }
}