﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using BMS.Facade;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    public class SelectUserModel : BaseViewModel
    {
        IList<User> _users = null;

        public IList<string> Domains { get; set; }
        public string SelectedDomain { get; set; }
        [ValidateXss]
        public string SearchText { get; set; }
        public String SelectedUserId { get; set; }

        public List<SearchUser> AddedUsers { get; set; }
        public List<string> AddedUserIdsSelected { get; set; }
        

        public IList<User> Users
        {
            get { return _users; }
            set
            {
                _users = value;
                if (_users != null)
                {
                    SearchedUsers = new List<SearchUser>();
                    foreach (User u in _users)
                        SearchedUsers.Add(new SearchUser() { User = u, HasRole = FacadeManager.UserInterface.CheckUserHasRole(u) });
                }
                else
                    SearchedUsers = null;
            }
        }

        public List<SearchUser> SearchedUsers { get; set; }

        public List<string> SearchedUserIdsSelected { get; set; }

        public string Add { get; set; }
        public string Remove { get; set; }

        public string BulkMode { get; set; }

        public string AddRevokeMessage { get; set; }
    }

    public class SearchUser
    {
        public User User { get; set; }

        public bool HasRole { get; set; }
    }
}