﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.Security.Application;
using System.ComponentModel;
using System.Web.Util;

namespace BMS.Web.Controllers.Shared
{
    public class XssModelBinder : DefaultModelBinder
    {
        AntiXssEncoder xss = new AntiXssEncoder();

        public override object BindModel(ControllerContext controllerContext, ModelBindingContext bindingContext)
        {
            bool shouldPerformRequestValidation = controllerContext.Controller.ValidateRequest && bindingContext.ModelMetadata.RequestValidationEnabled;
            ValueProviderResult valueResult = bindingContext.GetValueFromValueProvider(shouldPerformRequestValidation);

            if (valueResult != null && !string.IsNullOrEmpty(valueResult.AttemptedValue))
            {
                if (bindingContext.ModelMetadata.AdditionalValues.ContainsKey("AddXssKey"))
                    return Encoder.HtmlEncode(valueResult.AttemptedValue);
            }
            return base.BindModel(controllerContext, bindingContext);
        }        
    }

    public static class BinderExtensions
    {
        public static ValueProviderResult GetValueFromValueProvider(this ModelBindingContext bindingContext, bool performRequestValidation)
        {
            var unvalidatedValueProvider = bindingContext.ValueProvider as IUnvalidatedValueProvider;
            return (unvalidatedValueProvider != null)
                       ? unvalidatedValueProvider.GetValue(bindingContext.ModelName, !performRequestValidation)
                       : bindingContext.ValueProvider.GetValue(bindingContext.ModelName);
        }
    }

}