﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Web.App_GlobalResource;
using BMS.Facade.Data;
using BMS.Facade;
using System.Text;
using BMS.Utils;


namespace BMS.Web.Controllers
{
    /// <summary>
    /// Controllers for NewEvents page.
    /// </summary>
    public class NewEventsController : BaseController
    {
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                NewEventViewModel model = new NewEventViewModel();
                Fill(model);
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        public static void AddDefaultParameters([Bind(Exclude = "RememberMe")] IReportInfo report, string returnPath, string returnText, [Bind(Exclude = "RememberMe")] User loggedUser)
        {
            if (report == null)
                return;

            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (report.Parameters == null)
                    report.Parameters = new Dictionary<string, string>();
                report.Parameters.Add(Constants.REP_GENERAL_RETURN_PATH, returnPath);
                report.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, returnText);
                report.Parameters.Add(Constants.REP_GENERAL_FACILITY_EXTENSION, loggedUser.Facility.Id.extension);
                report.Parameters.Add(Constants.REP_NEW_EVENT_START_DATE, DateTimeNowOnCurrentFacility.AddHours(-8).ToString());
                report.Parameters.Add(Constants.REP_NEW_EVENT_END_DATE, DateTimeNowOnCurrentFacility.ToString());
                report.Parameters.Add(Constants.REP_TIME_ZONE_MINUTES_OFFSET, RepTimeZoneMinutesOffset);                
                string reportTitle = string.Empty;
                switch (report.Name)
                {
                    case Constants.SignedAdmission:
                        reportTitle = Strings.ActiveAdmissionOrdersReportTitle + " - " + loggedUser.Facility.Name + " (" + loggedUser.Facility.Code + ")";
                        report.Parameters.Add(Constants.REPORT_TITLE, reportTitle);
                        break;
                    case Constants.PatientMovementByDate:
                        reportTitle = Strings.PatientMovementsReportByDateTitle + " - " + loggedUser.Facility.Name + " (" + loggedUser.Facility.Code + ")";
                        report.Parameters.Add(Constants.REPORT_TITLE, reportTitle);
                        break;
                    case Constants.SignedDischarge:
                        reportTitle = Strings.ActiveDischargeOrdersReportTitle + " - " + loggedUser.Facility.Name + " (" + loggedUser.Facility.Code + ")";
                        report.Parameters.Add(Constants.REPORT_TITLE, reportTitle);
                        break;
                    case Constants.AnticipatedDischarge:
                        reportTitle = Strings.AnticDischargeOrdersReportTitle + " - " + loggedUser.Facility.Name + " (" + loggedUser.Facility.Code + ")";
                        report.Parameters.Add(Constants.REPORT_TITLE, reportTitle);
                        break;
                    case Constants.DischargeAppointment1:
                        report.Parameters.Add(Constants.REPORT_TITLE, Strings.PatientsWDischargeAppointmentsReportTitle);
                        break;
                    case Constants.BED_TURNAROUND_TIME_REPORT:
                        reportTitle = Strings.BedTurnaroundTimeReportTitle + " - " + loggedUser.Facility.Name + " (" + loggedUser.Facility.Code + ")";
                        report.Parameters.Add(Constants.REPORT_TITLE, reportTitle);
                        break;
                    case Constants.BedsOutOfService:
                        report.Parameters.Add(Constants.REPORT_TITLE, Strings.BedsOutOfServiceReportByDateTitle);
                        break;
                    case Constants.ACTIVE_TRANSFER_REPORT:
                        reportTitle = Strings.ActiveTransferOrdersReportTitle + " - " + loggedUser.Facility.Name + " (" + loggedUser.Facility.Code + ")";
                        report.Parameters.Add(Constants.REPORT_TITLE, reportTitle);
                        break;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Fill all the properties used to display the page NewEvent. 
        /// </summary>
        /// <param name="model">The model.</param>
        /// 
        private void Fill(NewEventViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                DateTime currentDate = DateTimeNowOnCurrentFacility.AddHours(-8);
                model.LoggedUser = loggedUser;
                model.ViewReport = Strings.ViewReport;
                model.Name = string.Format(Strings.NewEvents_TitleH1, currentDate.ToString("MM/dd/yyyy"), currentDate.ToShortTimeString());
                model.StartDate = DateTimeNowOnCurrentFacility.AddHours(-8);
                model.EndDate = DateTimeNowOnCurrentFacility;
                model.ReturnUrl = Constants.NEW_EVENTS;
                StringBuilder wards = new StringBuilder();
                List<Ward> wardList = FacadeManager.EntityInterface.GetWardsByFacility(this.loggedUser.Facility.Id).ToList();
                foreach (Ward ward in wardList)
                {
                    wards.Append(ward.Id.extension);
                    wards.Append(",");
                }

                int timeZoneMinutesOffset = Convert.ToInt32(RepTimeZoneMinutesOffset);
                IList<NewEventInfo> eventsInfo = Facade.FacadeManager.NewEventInterface.GetNewEvents(wards.ToString(), Guid.Parse(this.loggedUser.Facility.Id.extension), timeZoneMinutesOffset);
                List<Module> flags = FacadeManager.ConfigurationInterface.GetModules(this.loggedUser.Domain, this.loggedUser.Facility.Id).ToList();
                foreach (NewEventInfo eventInfo in eventsInfo)
                {
                    AddDefaultParameters(eventInfo.Report, HttpContext.Request.Url.ToString(), Strings.ReturnToNewEventsPage, this.loggedUser);

                    switch (eventInfo.EventName)
                    {
                        case BMS.Utils.NewEvent.AdmittedPatient:
                            model.AdmittedPatients = string.Format(
                                Strings.NewEventsAdmittedPatients,
                                eventInfo.EventCount,
                                currentDate.ToString("MM/dd/yyyy"),
                                currentDate.ToShortTimeString());

                            if (eventInfo.EventCount == 0)
                                model.DisplayReportAdmittedPatients = Strings.DiplayActionLinkNoneValue;
                            else
                            {
                                if (eventInfo.Report != null)
                                {
                                    model.DisplayReportAdmittedPatients = Strings.DisplayActionLinkBlockValue;

                                    eventInfo.Report.Parameters.Add(
                                        Constants.REP_ADMITTED_PATIENT_TRANS, "Admissions");
                                    model.AdmittedPatientsUrl = eventInfo.Report.Url;
                                }
                                else
                                {
                                    model.DisplayReportAdmittedPatients = Strings.DiplayActionLinkNoneValue;
                                    model.AdmittedPatientsUrl = string.Empty;
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.BedOutOfService:
                            model.BedsOutOfService = string.Format(
                                Strings.NewEventsBedsOutOfService,
                                eventInfo.EventCount,
                                currentDate.ToString("MM/dd/yyyy"),
                                currentDate.ToShortTimeString());

                            if (eventInfo.EventCount == 0)
                                model.DisplayReportBedsOutOfService = Strings.DiplayActionLinkNoneValue;
                            else
                            {
                                if (eventInfo.Report != null)
                                {
                                    model.DisplayReportBedsOutOfService = Strings.DisplayActionLinkBlockValue;
                                    model.BedOutOfServiceUrl = eventInfo.Report.Url;
                                }
                                else
                                {
                                    model.DisplayReportBedsOutOfService = Strings.DiplayActionLinkNoneValue;
                                    model.BedOutOfServiceUrl = string.Empty;
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.CompletedCleaningBed:
                            if (flags.Where(a => a.Code.Equals(Constants.EMS_MODULE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                model.DivEMSActiveDisplay = "none;";
                                model.DivEMSInactiveDisplay = "block;";
                            }
                            else
                            {
                                model.DivEMSActiveDisplay = "block;";
                                model.DivEMSInactiveDisplay = "none;";
                                model.CompletedCleaningBeds = string.Format(
                                    Strings.NewEventsCompletedCleaningBeds,
                                    eventInfo.EventCount,
                                    currentDate.ToString("MM/dd/yyyy"),
                                    currentDate.ToShortTimeString());

                                if (eventInfo.EventCount == 0)
                                    model.DisplayReportCompletedCleaningBeds = Strings.DiplayActionLinkNoneValue;
                                else
                                {
                                    if (eventInfo.Report != null)
                                    {
                                        model.DisplayReportCompletedCleaningBeds = Strings.DisplayActionLinkBlockValue;
                                        model.CompletedCleaningBedsUrl = eventInfo.Report.Url;
                                    }
                                    else
                                    {
                                        model.DisplayReportCompletedCleaningBeds = Strings.DiplayActionLinkNoneValue;
                                        model.CompletedCleaningBedsUrl = string.Empty;
                                    }
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.CurrentlyCleaningBed:
                            if (flags.Where(a => a.Code.Equals(Constants.EMS_MODULE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                model.DivEMSActiveDisplay = "none;";
                                model.DivEMSInactiveDisplay = "block;";
                            }
                            else
                            {
                                model.DivEMSActiveDisplay = "block;";
                                model.DivEMSInactiveDisplay = "none;";
                                model.CurrentlyCleaningBeds = string.Format(
                                    Strings.NewEventsCurrentlyCleaningBeds,
                                    eventInfo.EventCount,
                                    currentDate.ToString("MM/dd/yyyy"),
                                    currentDate.ToShortTimeString());

                                if (eventInfo.EventCount == 0)
                                    model.DisplayReportCurrentlyCleaningBeds = Strings.DiplayActionLinkNoneValue;
                                else
                                {
                                    if (eventInfo.Report != null)
                                    {
                                        model.DisplayReportCurrentlyCleaningBeds = Strings.DisplayActionLinkBlockValue;
                                        model.CurrentlyCleaningBedsUrl = eventInfo.Report.Url;
                                    }
                                    else
                                    {
                                        model.DisplayReportCurrentlyCleaningBeds = Strings.DiplayActionLinkNoneValue;
                                        model.CurrentlyCleaningBedsUrl = string.Empty;
                                    }
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.DischargeAppointment:
                            if (flags.Where(a => a.Code.Equals(Constants.DISCHARGE_APPOINTMENT, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                model.DischargeAppointments = "The Discharge Appointment Module is currently inactivated.";
                                model.DisplayReportDischargeAppointment = Strings.DiplayActionLinkNoneValue;
                                model.DischargeAppointmentUrl = string.Empty;
                            }
                            else
                            {
                                model.DischargeAppointments = string.Format(
                                    Strings.NewEventsDischargeAppointment,
                                    eventInfo.EventCount,
                                    currentDate.ToString("MM/dd/yyyy"),
                                    currentDate.ToShortTimeString());

                                if (eventInfo.EventCount == 0)
                                    model.DisplayReportDischargeAppointment = Strings.DiplayActionLinkNoneValue;
                                else
                                {
                                    if (eventInfo.Report != null)
                                    {
                                        model.DisplayReportDischargeAppointment = Strings.DisplayActionLinkBlockValue;
                                        model.DischargeAppointmentUrl = eventInfo.Report.Url;
                                    }
                                    else
                                    {
                                        model.DisplayReportDischargeAppointment = Strings.DiplayActionLinkNoneValue;
                                        model.DischargeAppointmentUrl = string.Empty;
                                    }
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.PatientDischarged:
                            model.PatientDischarged = string.Format(
                                Strings.NewEventsPatientDischarged,
                                eventInfo.EventCount,
                                currentDate.ToString("MM/dd/yyyy"),
                                currentDate.ToShortTimeString());

                            if (eventInfo.EventCount == 0)
                                model.DisplayReportPatientDischarged = Strings.DiplayActionLinkNoneValue;
                            else
                            {
                                if (eventInfo.Report != null)
                                {
                                    model.DisplayReportPatientDischarged = Strings.DisplayActionLinkBlockValue;
                                    eventInfo.Report.Parameters.Add(
                                        Constants.REP_ADMITTED_PATIENT_TRANS, "Discharges");
                                    model.PatientDischargedUrl = eventInfo.Report.Url;
                                }
                                else
                                {
                                    model.DisplayReportPatientDischarged = Strings.DiplayActionLinkNoneValue;
                                    model.PatientDischargedUrl = string.Empty;
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.SignedAdmission:
                            if (flags.Where(a => a.Code.Equals(Constants.ADM_ORD, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                model.SignedAdmissionOrders = "The Admission Orders Module is currently inactivated.";
                                model.DisplayReportSignedAdmissions = Strings.DiplayActionLinkNoneValue;
                                model.SignedAdmissionUrl = string.Empty;
                            }
                            else
                            {
                                model.SignedAdmissionOrders = string.Format(
                                    Strings.NewEventsSignedAdmission,
                                    eventInfo.EventCount,
                                    currentDate.ToString("MM/dd/yyyy"),
                                    currentDate.ToShortTimeString());

                                if (eventInfo.EventCount == 0)
                                    model.DisplayReportSignedAdmissions = Strings.DiplayActionLinkNoneValue;
                                else
                                {
                                    if (eventInfo.Report != null)
                                    {
                                        model.DisplayReportSignedAdmissions = Strings.DisplayActionLinkBlockValue;
                                        model.SignedAdmissionUrl = eventInfo.Report.Url;
                                    }
                                    else
                                    {
                                        model.DisplayReportSignedAdmissions = Strings.DiplayActionLinkNoneValue;
                                        model.SignedAdmissionUrl = string.Empty;
                                    }
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.SignedAnticipatedDischarge:
                            if (flags.Where(a => a.Code.Equals(Constants.ANTIC_DISCH, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                model.SignedAnticipatedDischarge = "The Anticipated Discharge Orders Module is currently inactivated.";
                                model.DisplayReportSignedAnticipatedDischarge = Strings.DiplayActionLinkNoneValue;
                                model.SignedAnticipatedDischargeUrl = string.Empty;
                            }
                            else
                            {
                                model.SignedAnticipatedDischarge = string.Format(
                                    Strings.NewEventsSignedAnticipatedDischarge,
                                    eventInfo.EventCount, currentDate.ToString("MM/dd/yyyy"),
                                    currentDate.ToShortTimeString());

                                if (eventInfo.EventCount == 0)
                                    model.DisplayReportSignedAnticipatedDischarge = Strings.DiplayActionLinkNoneValue;
                                else
                                {
                                    if (eventInfo.Report != null)
                                    {
                                        model.DisplayReportSignedAnticipatedDischarge = Strings.DisplayActionLinkBlockValue;
                                        model.SignedAnticipatedDischargeUrl = eventInfo.Report.Url;
                                    }
                                    else
                                    {
                                        model.DisplayReportSignedAnticipatedDischarge = Strings.DiplayActionLinkNoneValue;
                                        model.SignedAnticipatedDischargeUrl = string.Empty;
                                    }
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.SignedDischarge:
                            if (flags.Where(a => a.Code.Equals(Constants.DISCH_ORD, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                model.SignedDischarge = "The Discharge Orders Module is currently inactivated.";
                                model.DisplayReportSignedDischarge = Strings.DiplayActionLinkNoneValue;
                                model.SignedDischargeUrl = string.Empty;
                            }
                            else
                            {
                                model.SignedDischarge = string.Format(
                                    Strings.NewEventsSignedDischarge,
                                    eventInfo.EventCount,
                                    currentDate.ToString("MM/dd/yyyy"),
                                    currentDate.ToShortTimeString());

                                if (eventInfo.EventCount == 0)
                                    model.DisplayReportSignedDischarge = Strings.DiplayActionLinkNoneValue;
                                else
                                {
                                    if (eventInfo.Report != null)
                                    {
                                        model.DisplayReportSignedDischarge = Strings.DisplayActionLinkBlockValue;
                                        model.SignedDischargeUrl = eventInfo.Report.Url;
                                    }
                                    else
                                    {
                                        model.DisplayReportSignedDischarge = Strings.DiplayActionLinkNoneValue;
                                        model.SignedDischargeUrl = string.Empty;
                                    }
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.SignedTransfer:
                            if (flags.Where(a => a.Code.Equals(Constants.TRSF_ORD, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                model.SignedTransfer = "The Transfer Orders Module is currently inactivated.";
                                model.DisplayReportSignedTransfer = Strings.DiplayActionLinkNoneValue;
                                model.SignedTransferUrl = string.Empty;
                            }
                            else
                            {
                                model.SignedTransfer = string.Format(
                                    Strings.NewEventsSignedTransfer,
                                    eventInfo.EventCount,
                                    currentDate.ToString("MM/dd/yyyy"),
                                    currentDate.ToShortTimeString());

                                if (eventInfo.EventCount == 0)
                                    model.DisplayReportSignedTransfer = Strings.DiplayActionLinkNoneValue;
                                else
                                {
                                    if (eventInfo.Report != null)
                                    {
                                        model.DisplayReportSignedTransfer = Strings.DisplayActionLinkBlockValue;
                                        model.SignedTransferUrl = eventInfo.Report.Url;
                                    }
                                    else
                                    {
                                        model.DisplayReportSignedTransfer = Strings.DiplayActionLinkNoneValue;
                                        model.SignedTransferUrl = string.Empty;
                                    }
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.VacatedBed:
                            if (flags.Where(a => a.Code.Equals(Constants.EMS_MODULE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                model.DivEMSActiveDisplay = "none;";
                                model.DivEMSInactiveDisplay = "block;";
                            }
                            else
                            {
                                model.DivEMSActiveDisplay = "block;";
                                model.DivEMSInactiveDisplay = "none;";
                                model.VacatedBeds = string.Format(
                                    Strings.NewEventsVacatedBeds,
                                    eventInfo.EventCount,
                                    currentDate.ToString("MM/dd/yyyy"),
                                    currentDate.ToShortTimeString());

                                if (eventInfo.EventCount == 0)
                                    model.DisplayReportVacatedBeds = Strings.DiplayActionLinkNoneValue;
                                else
                                {
                                    if (eventInfo.Report != null)
                                    {
                                        model.DisplayReportVacatedBeds = Strings.DisplayActionLinkBlockValue;
                                        model.VacatedBedsUrl = eventInfo.Report.Url;
                                    }
                                    else
                                    {
                                        model.DisplayReportVacatedBeds = Strings.DiplayActionLinkNoneValue;
                                        model.VacatedBedsUrl = string.Empty;
                                    }
                                }
                            }
                            break;

                        case BMS.Utils.NewEvent.BackToService:
                            model.BackToService = string.Format(
                                Strings.NewEventsBackToService,
                                eventInfo.EventCount,
                                currentDate.ToString("MM/dd/yyyy"),
                                currentDate.ToShortTimeString());

                            if (eventInfo.EventCount == 0)
                                model.DisplayReportBackToService = Strings.DiplayActionLinkNoneValue;
                            else
                            {
                                if (eventInfo.Report != null)
                                {
                                    model.DisplayReportBackToService = Strings.DisplayActionLinkBlockValue;
                                    model.BackToServiceUrl = eventInfo.Report.Url;
                                }
                                else
                                {
                                    model.DisplayReportBackToService = Strings.DiplayActionLinkNoneValue;
                                    model.BackToServiceUrl = string.Empty;
                                }
                            }
                            break;
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

    }
}
