﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade.Data;
using BMS.Facade;
using Microsoft.Web.Mvc;
using BMS.Utils;
using System.Text.RegularExpressions;
using BMS.Web.App_GlobalResource;
namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class IconLibraryController : BaseController
    {
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconLibraryViewModel model = new IconLibraryViewModel();
                List<IconInfo> list = FacadeManager.IconInterface.GetSiteConfigurableIcons(Guid.Parse(this.loggedUser.Facility.Id.extension));
                model.SiteConfigurableIcons = (from p in list
                                               orderby p.OrderIndex
                                               select p).ToList();
                model.PatientIcon = FacadeManager.IconInterface.GetIconByCode(Constants.PATIENT_ICON_CODE);
                model.RoomBedIcon = FacadeManager.IconInterface.GetIconByCode(Constants.ROOM_BED_ICON_CODE);
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Index(IconLibraryViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<IconInfo> list = FacadeManager.IconInterface.GetSiteConfigurableIcons(Guid.Parse(this.loggedUser.Facility.Id.extension));
                input.SiteConfigurableIcons = (from p in list
                                               orderby p.OrderIndex
                                               select p).ToList();
                input.PatientIcon = FacadeManager.IconInterface.GetIconByCode(Constants.PATIENT_ICON_CODE);
                input.RoomBedIcon = FacadeManager.IconInterface.GetIconByCode(Constants.ROOM_BED_ICON_CODE);

                for (int i = 0; i < input.SiteConfigurableIconList.Count; i++)
                    input.SiteConfigurableIcons[i].OrderIndex = input.SiteConfigurableIconList[i].OrderIndexView;

                IconInfo icon1 = input.SiteConfigurableIcons.Where(a => a.IconId == input.SwitchIconId1).FirstOrDefault();
                IconInfo icon2 = input.SiteConfigurableIcons.Where(a => a.IconId == input.SwitchIconId2).FirstOrDefault();
                int order = icon1.OrderIndex;
                icon1.OrderIndex = icon2.OrderIndex;
                icon2.OrderIndex = order;

                list = FacadeManager.IconInterface.UpdateIconOrderBulk(input.SiteConfigurableIcons, this.loggedUser.Facility);
                input.SiteConfigurableIcons = (from p in list
                                               orderby p.OrderIndex
                                               select p).ToList();
                input.LoggedUser = loggedUser;
                return View(input);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult Edit(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconLibraryViewModel model = new IconLibraryViewModel();
                model.IconId = Int32.Parse(QueryStrings["iconId"]);
                model.LoggedUser = this.loggedUser;
                IconDetail iconDetail = FacadeManager.IconInterface.GetIconDetail(model.IconId, this.loggedUser.Facility);
                if (iconDetail != null)
                {
                    model.Active = iconDetail.FacilityActive;
                    model.IconShortDescription = iconDetail.ShortDescription;
                    model.ImageBytes = iconDetail.ImageBytes;
                    model.ImageBytesInactive = iconDetail.ImageBytesInactive;
                    model.ImageName = iconDetail.ImageName;
                    model.PatientOrRoomBed = (iconDetail.FacilityPatientOrRoomBed.Equals('P')) ? true : false;
                    model.OrderIndex = (iconDetail.FacilityOrderIndex <= 0) ? iconDetail.OrderIndex : iconDetail.FacilityOrderIndex;
                    model.IsIconAssociated = iconDetail.IsAssociated;

                    if (bool.Parse(QueryStrings["hasButtonResetClicked"]))
                    {
                        model.IconName = null;
                        model.IconDescription = null;
                        model.Comment = null;
                        model.MouseOverText = null;
                        model.IconNameTitle = model.IconShortDescription;
                    }
                    else
                    {
                        model.Comment = iconDetail.FacilityComment;
                        model.IconDescription = iconDetail.FacilityDescription;
                        model.IconName = iconDetail.FacilityIconName;
                        model.MouseOverText = iconDetail.FacilityMouseOverText;
                        model.IconNameTitle = (string.IsNullOrEmpty(model.IconName)) ? iconDetail.ShortDescription : model.IconName;
                    }

                }
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Edit(IconLibraryViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrEmpty(input.ButtonSave))
                {
                    input.LoggedUser = loggedUser;
                    if (!ModelState.IsValid)
                        return View(input);

                    if (!string.IsNullOrWhiteSpace(input.IconName) && Regex.IsMatch(input.IconName, Constants.DNRDNIRegex))
                    {
                        ModelState.Clear();
                        ModelState.AddModelError("IconName", Strings.FacilityIconDNIDNRError);
                        return View(input);
                    }
                    if (!string.IsNullOrWhiteSpace(input.IconDescription) && Regex.IsMatch(input.IconDescription, Constants.DNRDNIRegex))
	                {
                        ModelState.Clear();
                        ModelState.AddModelError("IconDescription", Strings.FacilityIconDNIDNRError);
                        return View(input);
	                }
                    if (!string.IsNullOrWhiteSpace(input.Comment) && Regex.IsMatch(input.Comment, Constants.DNRDNIRegex))
                    {
                        ModelState.Clear();
                        ModelState.AddModelError("Comment", Strings.FacilityIconDNIDNRError);
                        return View(input);
                    }
                    if (!string.IsNullOrWhiteSpace(input.MouseOverText) && Regex.IsMatch(input.MouseOverText, Constants.DNRDNIRegex))
                    {
                        ModelState.Clear();
                        ModelState.AddModelError("MouseOverText", Strings.FacilityIconDNIDNRError);
                        return View(input);
                    }

                    if (input.Active)
                    {
                        List<IconInfo> icons = FacadeManager.IconInterface.GetSiteConfigurableIcons(Guid.Parse(this.loggedUser.Facility.Id.extension));
                        if (icons.Where(a => a.IconName.Trim().Equals(input.IconName.Trim(), StringComparison.InvariantCultureIgnoreCase) && a.Active && a.IconId != input.IconId).FirstOrDefault() != null)
                        {
                            ModelState.Clear();
                            ModelState.AddModelError("IconName", "The Facility Icon Name field must be unique!");
                            return View(input);
                        }
                    }
                    SaveIcon(input);
                    input.IconNameTitle = (string.IsNullOrEmpty(input.IconName)) ? input.IconShortDescription : input.IconName;
                    return View("SaveConfirmation", input);
                }
                return null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult ResetConfirmation(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconLibraryViewModel model = new IconLibraryViewModel();
                model.IconId = Int32.Parse(QueryStrings["iconId"]);
                model.LoggedUser = this.loggedUser;
                IconDetail icon = FacadeManager.IconInterface.GetIconDetail(model.IconId, null);
                model.IconNameTitle = icon.IconName;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult ResetConfirmation(IconLibraryViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return this.RedirectToAction<IconLibraryController>(act => act.Edit(EncryptQueryString(new string[] { "iconId", "hasButtonResetClicked" }, new string[] { model.IconId.ToString(), "true" }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #region Private Methods

        private void SaveIcon(IconLibraryViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconDetail icon = FacadeManager.IconInterface.GetIconDetail(model.IconId, this.loggedUser.Facility);
                bool _isNew = false;
                int orderIndex = icon.FacilityOrderIndex;
                if (icon.Facility == null)
                    _isNew = true;

                icon.IconFlagId = icon.Id;
                icon.Id = model.IconId;
                icon.Facility = new Place() { Id = this.loggedUser.Facility.Id, Name = this.loggedUser.Facility.Name };
                icon.FacilityActive = model.Active;
                icon.FacilityComment = model.Comment;
                icon.FacilityDescription = model.IconDescription;
                icon.FacilityIconName = model.IconName;
                icon.FacilityMouseOverText = model.MouseOverText;
                icon.FacilityOrderIndex = model.OrderIndex;
                icon.FacilityPatientOrRoomBed = (model.PatientOrRoomBed) ? 'P' : 'R';
                icon.EnteredBy = this.loggedUser.UserName;
                icon.EnteredDate = DateTimeNowOnCurrentFacility;
                icon.LastEditBy = this.loggedUser.UserName;
                icon.LastEditDate = DateTimeNowOnCurrentFacility;
                if (_isNew)
                    FacadeManager.IconInterface.CreateIconDetail(icon);
                else
                    FacadeManager.IconInterface.UpdateIconDetail(icon);

                if (orderIndex != icon.FacilityOrderIndex)
                {
                    // update order indexes
                    List<IconInfo> list = FacadeManager.IconInterface.GetSiteConfigurableIcons(Guid.Parse(this.loggedUser.Facility.Id.extension));
                    model.SiteConfigurableIcons = (from p in list
                                                   orderby p.OrderIndex
                                                   select p).ToList();
                    for (int i = 0; i < model.SiteConfigurableIconList.Count; i++)
                        model.SiteConfigurableIcons[i].OrderIndex = model.SiteConfigurableIconList[i].OrderIndexView;
                    list = FacadeManager.IconInterface.UpdateIconOrderBulk(model.SiteConfigurableIcons, this.loggedUser.Facility);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion
    }
}
