﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using BMS.Facade.Data;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class ContingencySettingsController : BaseController
    {
        [ReadPermissionAuthFilter]
        public ActionResult Index()
        {
            ContingencySettingsViewModel model = new ContingencySettingsViewModel();
            model.Divisions = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id).ToList();
            model.LoggedUser = loggedUser;
            return View(model);
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Index([Bind(Exclude = "RememberMe")] ContingencySettingsViewModel input)
        {
            List<Division> divisions = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id).ToList();
            Division division = null;
            foreach (ContingencySettings div in input.DivisionList)
            {    
                division = divisions.Where(a => a.Id.extension.Equals(div.Division.Id.extension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                division.WhiteboardReportPath = div.WhiteboardReportPath;
                FacadeManager.EntityInterface.UpdateDivision(division);                
            }
            return View("Confirmation");
        }
    }
}
